<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2025 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    
    <xsl:import href="odf-view:odf-pilotage://stylesheets/pilotage/report/maquette2doc.xsl"/>
    
    <xsl:template name="css-styles">
        <xsl:call-template name="css-styles-maquette"/>
        <xsl:call-template name="css-styles-maquettediff"/>
    </xsl:template>
    
    <xsl:template name="css-styles-maquettediff">
        <!-- Added -->
        .border-added 
        { 
            border-left:1px solid  #333333;
            text-align:center;
            text-decoration: underline;
            color: green !important;
        }
        
        .choisirElement-added
        {
            text-decoration: underline;
            color: green !important;
        }
        
        .codeAmetys-added 
        {
            text-decoration: underline;
            color: green !important;
        }
        
        .codeEtapePorteuse-added  
        { 
            text-decoration: underline;
            border-left:1px solid  #333333;
            text-align:left;
            color: green !important;
        }
        
        .h1-added,
        .h2-added
        {
            text-align: center;
            font-size: 15pt;
            text-decoration: underline;
            color: green !important;
        }
        
        .container-added,
        {
            font-weight: bold;
            text-decoration: underline;
            color: green !important;
        }
        
        .course-added
        {
            text-decoration: underline;
            color: green !important;
        }
        
        <!-- Modified new -->
        .border-modified_new 
        { 
            border-left:1px solid  #333333;
            text-align:center;
            text-decoration: underline;
            color: blue !important;
            padding-top: -5px !important;
        }
        
        .choisirElement-modified_new
        {
            text-decoration: underline;
            color: blue !important;
            border-left:1px solid  #333333;
            padding-top: -5px !important;
        }
        
        .codeAmetys-modified_new 
        {
            text-decoration: underline;
            color: blue !important;
            padding-top: -5px !important;
        }
        
        .codeEtapePorteuse-modified_new  
        { 
            text-decoration: underline;
            border-left:1px solid  #333333;
            text-align:left;
            color: blue !important;
            padding-top: -5px !important;
        }
        
        .h1-modified_new,
        .h2-modified_new
        {
            text-align: center;
            font-size: 15pt;
            text-decoration: underline;
            color: blue !important;
        }
        
        .container-modified_new 
        {
            font-weight: bold;
            text-decoration: underline;
            color: blue !important;
        }
        
        .course-modified_new 
        {
            padding-top: -5px !important;
            text-decoration: underline;
            color: blue !important;
        }
        
        <!-- Removed -->
        .border-removed
        { 
            border-left:1px solid  #333333;
            text-align:center;
            text-decoration: line-through;
            color: red !important;
        }
        
        .choisirElement-removed 
        {
            text-decoration: line-through;
            color: red !important;
        }
        
        .codeAmetys-removed 
        {
            text-decoration: line-through;
            color: red !important;
        }
        
        .codeEtapePorteuse-removed 
        { 
            border-left:1px solid  #333333;
            text-align:left;
            text-decoration: line-through;
            color: red !important;
        }
        
        .h1-removed,
        .h2-removed
        {
            text-align: center;
            font-size: 15pt;
            text-decoration: line-through;
            color: red !important;
        }
        
        .container-removed 
        {
            font-weight: bold;
            text-decoration: line-through;
            color: red !important;
        }
        
        .course-removed
        {
            text-decoration: line-through;
            color: red !important;
        }
        
        <!-- Modified old -->
        .border-modified_old
        { 
            border-left:1px solid  #333333;
            text-align:center;
            text-decoration: line-through;
            color: #cccccc !important;
            border-bottom:0px !important;
        }
        
        .choisirElement-modified_old 
        {
            text-decoration: line-through;
            color: #cccccc !important;
            border-bottom:0px !important;
        }
        
        .codeAmetys-modified_old 
        {
            text-decoration: line-through;
            color: #cccccc !important;
            border-bottom:0px !important;
        }
        
        .codeEtapePorteuse-modified_old 
        { 
            border-left:1px solid  #333333;
            text-align:left;
            text-decoration: line-through;
            color: #cccccc !important;
            border-bottom:0px !important;
        }
        
        .h1-modified_old,
        .h2-modified_old
        {
            text-align: center;
            font-size: 15pt;
            color: #cccccc !important;
            text-decoration: line-through;
        }
        
        .container-modified_old 
        {
            font-weight: bold;
            color: #cccccc !important;
            text-decoration: line-through;
        }
        
        .course-modified_old 
        {
            border-bottom:0px !important;
            color: #cccccc !important;
            text-decoration: line-through;
        }
    </xsl:template>

    <xsl:template match="courseList[@changeType = 'modified_old']"/>
    
    <xsl:template match="courseList[@changeType = 'modified_new']" mode="child">
        <xsl:param name="indent" />
        <xsl:param name="COD_ETP_YEAR" />
        
        <xsl:apply-templates select="../courseList[@changeType = 'modified_old' and code = current()/code]" mode="courselist-header">
            <xsl:with-param name="indent" select="$indent"/>
        </xsl:apply-templates>

        <xsl:apply-templates select="." mode="courselist-header">
            <xsl:with-param name="indent" select="$indent"/>
        </xsl:apply-templates>
        
        <xsl:apply-templates select="course">
            <xsl:with-param name="indent" select="$indent"/>
            <xsl:with-param name="COD_ETP_YEAR" select="$COD_ETP_YEAR"/>
        </xsl:apply-templates>
    </xsl:template>
    
    <xsl:template match="program|subProgram|container|courseList|course" mode="suffix">
        <xsl:if test="@changeType != ''">-<xsl:value-of select="@changeType"/></xsl:if>
    </xsl:template>
</xsl:stylesheet>