<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2018 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:exsl="http://exslt.org/common"
                              exclude-result-prefixes="exsl">
    
    <xsl:import href="view://stylesheets/helper/common.xsl"/>
    
    <xsl:decimal-format decimal-separator="," grouping-separator=" "/>
    
    <xsl:variable name="root" select="/"/>
    
    <xsl:variable name="shortLabelToDisplay">
        <!-- Syntax to force some values to be displayed by short label instead of code
        <display typeId="odf-enumeration.EnseignementNature"/>
        <display typeId="odf-enumeration.MccSessionNature"/>
        <display typeId="odf-enumeration.MccModaliteSession1"/>
         -->
    </xsl:variable>
    
    <xsl:variable name="referenceTables">
        <!-- Syntax to enumerate available reference tables
        <xsl:copy-of select="odf:getTableRefItems('odf-enumeration.CourseNature', /report/lang, true())"/>
        <xsl:copy-of select="odf:getTableRefItems('odf-enumeration.MccRegime', /report/lang, true())"/>
        <xsl:copy-of select="odf:getTableRefItems('odf-enumeration.MccModaliteSession1', /report/lang, true())"/>
        <xsl:copy-of select="odf:getTableRefItems('odf-enumeration.MccModaliteSession2', /report/lang, true())"/>
        <xsl:copy-of select="odf:getTableRefItems('odf-enumeration.MccSessionNature', /report/lang, true())"/>
         -->
    </xsl:variable>
    
    <xsl:template name="display-double">
        <xsl:param name="value" select="'0'" />
        <xsl:param name="showZero" select="false()" />
        <xsl:param name="format" select="'#,##'"/>
        
        <xsl:choose>
            <!-- display if NaN or if superior to 0 -->
            <xsl:when test="not($value) or number($value) != $value"><xsl:value-of select="$value" /></xsl:when>
            <xsl:when test="$value &gt; 0 or $showZero"><xsl:value-of select="format-number($value, $format)" /></xsl:when>
            <xsl:otherwise />
        </xsl:choose>
    </xsl:template>
    
    <xsl:template name="recursive-print">
        <xsl:param name="to-print" select="'&#8195;'" />
        <xsl:param name="times" select="'1'" />
        
        <xsl:if test="$times &gt; 0">
            <xsl:value-of select="$to-print" />
            <xsl:call-template name="recursive-print">
                <xsl:with-param name="to-print" select="$to-print" />
                <xsl:with-param name="times" select="$times - 1" />
            </xsl:call-template>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="displayCodeOrShortLabel">
        <xsl:param name="contentId"/>
        
        <xsl:variable name="currentEntry" select="$root/report/items//item[@id = $contentId]|exsl:node-set($referenceTables)/items//item[@id = $contentId]"/>
        <xsl:variable name="displayShortLabel" select="$currentEntry/@shortLabel != '' and count(exsl:node-set($shortLabelToDisplay)/display[@typeId = $currentEntry/ancestor::items/@id]) > 0" />
        <xsl:choose>
            <xsl:when test="$displayShortLabel">
                <xsl:value-of select="$currentEntry/@shortLabel"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="$currentEntry/@code"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template match="*" mode="code">
        <xsl:choose>
            <xsl:when test="displayCode != ''"><xsl:value-of select="displayCode"/></xsl:when>
            <xsl:otherwise><xsl:value-of select="code"/></xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template match="*" mode="code-parenthesis">
        <xsl:variable name="code"><xsl:apply-templates select="." mode="code"/></xsl:variable>
        <xsl:if test="$code != ''">
            <xsl:text> (</xsl:text><xsl:value-of select="$code"/><xsl:text>)</xsl:text>
        </xsl:if>
    </xsl:template>
</xsl:stylesheet>
