/*
 *  Copyright 2025 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.odfpilotage.restriction;

import java.util.Map;

import org.ametys.runtime.i18n.I18nizableText;

/**
 * Same as its parent and add the mccSessions
 */
public class ByEducationalPathAttributesEnumerator extends org.ametys.odf.restriction.ByEducationalPathAttributesEnumerator
{
    /** The entry value for both mccSessions */
    public static final String VALUE_MCCSESSIONS = "mccSessions";
    
    @Override
    public Map<String, I18nizableText> getEntries() throws Exception
    {
        Map<String, I18nizableText> entries = super.getEntries();
        
        if (_contentTypeExtensionPoint != null)
        {
            entries.remove("mccSession1");
            entries.remove("mccSession2");
            entries.put(VALUE_MCCSESSIONS, new I18nizableText("plugin.odf-pilotage", "PLUGINS_ODF_PILOTAGE_COURSE_MCC_SESSIONS_LABEL"));
        }
        
        return entries;
    }
}
