/*
 *  Copyright 2024 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.odfpilotage.rule.clientsideelement;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

import org.ametys.odf.ODFHelper;

/**
 * Client side element to add the odf root as a parent path to create new thematics.
 */
public class ODFThematicCreationClientSideElement extends RulesStaticClientSideElement
{
    /** ODF helper */
    protected ODFHelper _odfHelper;
    
    private String _rootContentPath;
    
    @Override
    public void service(ServiceManager manager) throws ServiceException
    {
        super.service(manager);
        _odfHelper = (ODFHelper) manager.lookup(ODFHelper.ROLE);
    }
    
    @Override
    public List<Script> getScripts(boolean ignoreRights, Map<String, Object> contextParameters)
    {
        List<Script> clonedScripts = new ArrayList<>();
        
        List<Script> scripts = super.getScripts(ignoreRights, contextParameters);
        for (Script script : scripts)
        {
            Script clonedScript = new Script(script);
            clonedScript.getParameters().put("rootContentPath", _getRootContentPath());
            clonedScripts.add(clonedScript);
        }
        
        return clonedScripts;
    }
    
    private String _getRootContentPath()
    {
        if (_rootContentPath == null)
        {
            _rootContentPath = _odfHelper.getRootContent(false).getPath();
        }
        return _rootContentPath;
    }
}
