/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfpilotage.helper;

import com.opensymphony.workflow.WorkflowException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.ametys.cms.data.ContentValue;
import org.ametys.cms.data.holder.group.IndexableRepeater;
import org.ametys.cms.data.holder.group.IndexableRepeaterEntry;
import org.ametys.cms.repository.Content;
import org.ametys.cms.repository.WorkflowAwareContent;
import org.ametys.core.ui.Callable;
import org.ametys.odf.ODFHelper;
import org.ametys.odf.ProgramItem;
import org.ametys.odf.course.Course;
import org.ametys.odf.data.EducationalPath;
import org.ametys.odf.program.Program;
import org.ametys.odf.rights.ODFRightHelper;
import org.ametys.plugins.odfpilotage.helper.MicroSkillsTreeHelper;
import org.ametys.plugins.repository.model.RepeaterDefinition;
import org.ametys.runtime.model.ModelHelper;
import org.ametys.runtime.model.ModelItem;
import org.ametys.runtime.model.ModelItemGroup;
import org.ametys.runtime.model.View;
import org.ametys.runtime.model.ViewItemAccessor;
import org.ametys.runtime.model.disableconditions.AbstractRelativeDisableCondition;
import org.ametys.runtime.model.disableconditions.DisableCondition;
import org.ametys.runtime.model.disableconditions.DisableConditions;
import org.ametys.runtime.model.type.DataContext;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Request;
import org.apache.commons.lang3.StringUtils;

public class MicroSkillsWeightTreeHelper
extends MicroSkillsTreeHelper {
    protected static final String MCC_SESSION_1_ATTRIBUTE_NAME = "mccSession1";
    protected static final String MCC_SESSION_2_ATTRIBUTE_NAME = "mccSession2";
    protected ODFHelper _odfHelper;

    @Override
    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._odfHelper = (ODFHelper)smanager.lookup(ODFHelper.ROLE);
    }

    @Override
    protected Map<String, Object> content2Json(Content content, List<String> path) {
        Map<String, Object> json = super.content2Json(content, path);
        if (json != null && content instanceof Course) {
            Course course = (Course)content;
            Program program = (Program)this._resolver.resolveById(path.get(0));
            json.putAll(this._sessionToJSON((IndexableRepeater)course.getRepeater(MCC_SESSION_1_ATTRIBUTE_NAME), null));
            json.putAll(this._sessionToJSON((IndexableRepeater)course.getRepeater(MCC_SESSION_2_ATTRIBUTE_NAME), null));
            json.computeIfAbsent("notEditableDataIndex", l -> new ArrayList());
            List notEditableDataIndex = (List)json.get("notEditableDataIndex");
            ContentValue[] acquiredSkills = course.getAcquiredSkills(program.getId());
            List<String> acquiredSkillsIds = Arrays.stream(acquiredSkills).map(ContentValue::getContentId).toList();
            List<ContentValue> macroSkills = this.getMacroskills(program);
            for (ContentValue macroSkillContentValue : macroSkills) {
                Content macroSkill;
                ContentValue[] microSkills;
                Optional optionalContent = macroSkillContentValue.getContentIfExists();
                if (!optionalContent.isPresent() || (microSkills = (ContentValue[])(macroSkill = (Content)optionalContent.get()).getValue("microSkills")) == null) continue;
                for (ContentValue microSkill : microSkills) {
                    if (acquiredSkillsIds.contains(microSkill.getContentId())) continue;
                    notEditableDataIndex.add(microSkill.getContentId());
                }
            }
        }
        return json;
    }

    @Override
    protected Object _skill2Json(Course course, String skillId) {
        LinkedHashMap<String, Object> json = new LinkedHashMap<String, Object>();
        json.putAll(this._sessionToJSON((IndexableRepeater)course.getRepeater(MCC_SESSION_1_ATTRIBUTE_NAME), skillId));
        json.putAll(this._sessionToJSON((IndexableRepeater)course.getRepeater(MCC_SESSION_2_ATTRIBUTE_NAME), skillId));
        return json;
    }

    private Map<? extends String, ? extends Object> _sessionToJSON(IndexableRepeater session, String skillId) {
        LinkedHashMap json = new LinkedHashMap();
        if (session != null && session.getSize() > 0) {
            LinkedHashMap evalsJson = new LinkedHashMap();
            for (IndexableRepeaterEntry evaluations : session.getEntries()) {
                IndexableRepeater notes = evaluations.getRepeater("notes");
                boolean isCommon = !evaluations.hasDefinition("common") || evaluations.getValue("common") != Boolean.FALSE;
                ArrayList<Map<String, ? extends Object>> notesJson = new ArrayList<Map<String, ? extends Object>>();
                if (notes != null && notes.getSize() > 0) {
                    for (IndexableRepeaterEntry note : notes.getEntries()) {
                        notesJson.add(this._noteToJSON(isCommon, note, skillId));
                    }
                } else {
                    notesJson.add(this._noteToJSON(isCommon, null, skillId));
                }
                LinkedHashMap<String, Object> evalJson = new LinkedHashMap<String, Object>();
                if (StringUtils.isBlank((CharSequence)skillId)) {
                    evalJson.put("label", StringUtils.defaultIfBlank((CharSequence)((String)evaluations.getValue("label")), (CharSequence)""));
                }
                evalJson.put("notes", notesJson);
                evalJson.put("common", isCommon);
                evalJson.put("path", this._toString((EducationalPath)evaluations.getValue("path")));
                evalsJson.put(Integer.toString(evaluations.getPosition()), evalJson);
            }
            if (evalsJson.size() > 0) {
                LinkedHashMap<String, Object> sessionJson = new LinkedHashMap<String, Object>();
                if (StringUtils.isBlank((CharSequence)skillId)) {
                    sessionJson.put("label", session.getModel().getLabel());
                }
                sessionJson.put("data", evalsJson);
                return Map.of(session.getModel().getName(), sessionJson);
            }
        }
        return json;
    }

    private Map<String, ? extends Object> _noteToJSON(boolean commonParentEvaluation, IndexableRepeaterEntry note, String skillId) {
        IndexableRepeater skills;
        if (StringUtils.isBlank((CharSequence)skillId)) {
            return Map.of("label", (Serializable)((Object)StringUtils.defaultIfBlank(note != null ? (String)note.getValue("label") : null, (CharSequence)"")), "ponderation", note != null ? (Double)note.getValue("ponderation", true, (Object)100.0) : 100.0);
        }
        HashMap<String, Double> skillPonderations = new HashMap<String, Double>();
        IndexableRepeater indexableRepeater = skills = note != null ? note.getRepeater("skills") : null;
        if (skills != null && skills.getSize() > 0) {
            for (IndexableRepeaterEntry skill : skills.getEntries()) {
                if (!skillId.equals(((ContentValue)skill.getValue("skill")).getContentId())) continue;
                EducationalPath p = (EducationalPath)skill.getValue("path");
                skillPonderations.put(commonParentEvaluation ? this._toString(p) : "", (Double)skill.getValue("ponderation"));
            }
        }
        return skillPonderations;
    }

    private String _toString(EducationalPath value) {
        return value != null ? value.toString() : "";
    }

    @Override
    @Callable(rights={""})
    public Map<String, Object> saveEdition(String courseId, Map<String, Object> changes, String programRootId) {
        Content content = (Content)this._resolver.resolveById(courseId);
        if (content instanceof Course) {
            RepeaterDefinition mccSession2Def;
            List<Map<String, Object>> mccSession2Values;
            Course course = (Course)content;
            HashMap<String, List<Map<String, Object>>> values = new HashMap<String, List<Map<String, Object>>>();
            RepeaterDefinition mccSession1Def = (RepeaterDefinition)content.getDefinition(MCC_SESSION_1_ATTRIBUTE_NAME);
            List<Map<String, Object>> mccSession1Values = this._getRepeaterEntries(content, mccSession1Def);
            if (mccSession1Values != null && !mccSession1Values.isEmpty()) {
                this._applyChanges(mccSession1Values, MCC_SESSION_1_ATTRIBUTE_NAME, changes);
                values.put(MCC_SESSION_1_ATTRIBUTE_NAME, mccSession1Values);
            }
            if ((mccSession2Values = this._getRepeaterEntries(content, mccSession2Def = (RepeaterDefinition)content.getDefinition(MCC_SESSION_2_ATTRIBUTE_NAME))) != null && !mccSession2Values.isEmpty()) {
                this._applyChanges(mccSession2Values, MCC_SESSION_2_ATTRIBUTE_NAME, changes);
                values.put(MCC_SESSION_2_ATTRIBUTE_NAME, mccSession2Values);
            }
            try {
                if (this._contentWorkflowHelper.isAvailableAction((WorkflowAwareContent)course, 2)) {
                    this._contentWorkflowHelper.editContent((WorkflowAwareContent)course, values, 2);
                } else {
                    List<EducationalPath> educationPaths = this._odfHelper.getEducationalPaths((ProgramItem)course, true, true).stream().filter(p -> p.getProgramItemIds().contains(programRootId)).toList();
                    Request request = ContextHelper.getRequest((Context)this._context);
                    request.setAttribute(ODFRightHelper.REQUEST_ATTR_EDUCATIONAL_PATHS, educationPaths);
                    this._contentWorkflowHelper.editContent((WorkflowAwareContent)course, values, 20);
                }
                return Map.of("success", true);
            }
            catch (WorkflowException e) {
                HashMap<String, Object> result = new HashMap<String, Object>();
                result.put("success", false);
                result.put("errorMsg", "An error occured while trying to save the changes of the course \"" + course.getTitle() + "\" (" + course.getId() + ") : " + e.getMessage());
                return result;
            }
        }
        throw new IllegalArgumentException("The content with id \"" + courseId + "\" is not a course or does not exist.");
    }

    private void _applyChanges(List<Map<String, Object>> currentMccEntries, String mccSessionName, Map<String, Object> changes) {
        for (String microSkillId : changes.keySet()) {
            Map microSkillChanges = (Map)changes.get(microSkillId);
            if (!microSkillChanges.containsKey(mccSessionName)) continue;
            Map microSkillChangesForMccSession = ((Map)microSkillChanges.get(mccSessionName)).getOrDefault("data", Map.of());
            for (String mccEntryPos : microSkillChangesForMccSession.keySet()) {
                int entryPos = Integer.valueOf(mccEntryPos);
                Map<String, Object> currentMCCEntry = currentMccEntries.get(entryPos - 1);
                if (!currentMCCEntry.containsKey("notes")) {
                    currentMCCEntry.put("notes", new ArrayList());
                }
                List currentNotes = (List)currentMCCEntry.get("notes");
                Map mccEntryChanges = (Map)microSkillChangesForMccSession.get(mccEntryPos);
                List notesChanges = mccEntryChanges.getOrDefault("notes", List.of());
                boolean common = (Boolean)currentMCCEntry.getOrDefault("common", true);
                int noteIndex = 0;
                for (Map noteChanges : notesChanges) {
                    Map currentNote;
                    if (currentNotes.size() < noteIndex + 1) {
                        HashMap<String, Double> newNoteEntry = new HashMap<String, Double>();
                        newNoteEntry.put("ponderation", 100.0);
                        currentNotes.add(newNoteEntry);
                    }
                    if (!(currentNote = (Map)currentNotes.get(noteIndex)).containsKey("skills")) {
                        currentNote.put("skills", new ArrayList());
                    }
                    List currentSkills = (List)currentNote.get("skills");
                    for (String elpPath : noteChanges.keySet()) {
                        Number ponderation = (Number)noteChanges.get(elpPath);
                        if (common && StringUtils.isNotEmpty((CharSequence)elpPath)) {
                            this._applyChangesOnCommonEntry(currentSkills, microSkillId, elpPath, ponderation);
                            continue;
                        }
                        if (common) continue;
                        this._applyChangesOnNotCommonEntry(currentSkills, microSkillId, ponderation);
                    }
                    ++noteIndex;
                }
            }
        }
    }

    private void _applyChangesOnCommonEntry(List<Map<String, Object>> currentSkills, String microSkillId, String elpPath, Number ponderation) {
        Optional<Map> matchedSkillEntry = currentSkills.stream().filter(e -> {
            String skillId;
            Object patt1$temp;
            ContentValue skillContent;
            Object patt0$temp = e.get("skill");
            return patt0$temp instanceof ContentValue && microSkillId.equals((skillContent = (ContentValue)patt0$temp).getContentId()) || (patt1$temp = e.get("skill")) instanceof String && microSkillId.equals(skillId = (String)patt1$temp);
        }).filter(e -> elpPath.equals(e.get("path").toString())).findFirst();
        if (matchedSkillEntry.isPresent()) {
            if (ponderation == null) {
                currentSkills.remove(matchedSkillEntry.get());
            } else {
                matchedSkillEntry.get().put("ponderation", ponderation.doubleValue());
            }
        } else if (ponderation != null) {
            HashMap<String, Object> newSkillEntry = new HashMap<String, Object>();
            newSkillEntry.put("skill", microSkillId);
            newSkillEntry.put("ponderation", ponderation.doubleValue());
            newSkillEntry.put("path", elpPath);
            currentSkills.add(newSkillEntry);
        }
    }

    private void _applyChangesOnNotCommonEntry(List<Map<String, Object>> currentSkills, String microSkillId, Number ponderation) {
        Optional<Map> matchedSkillEntry = currentSkills.stream().filter(e -> {
            String skillId;
            Object patt1$temp;
            ContentValue skillContent;
            Object patt0$temp = e.get("skill");
            return patt0$temp instanceof ContentValue && microSkillId.equals((skillContent = (ContentValue)patt0$temp).getContentId()) || (patt1$temp = e.get("skill")) instanceof String && microSkillId.equals(skillId = (String)patt1$temp);
        }).findFirst();
        if (matchedSkillEntry.isPresent()) {
            if (ponderation == null) {
                currentSkills.remove(matchedSkillEntry.get());
            } else {
                matchedSkillEntry.get().put("ponderation", ponderation.doubleValue());
            }
        } else if (ponderation != null) {
            HashMap<String, Object> newSkillEntry = new HashMap<String, Object>();
            newSkillEntry.put("skill", microSkillId);
            newSkillEntry.put("ponderation", ponderation.doubleValue());
            currentSkills.add(newSkillEntry);
        }
    }

    private List<Map<String, Object>> _getRepeaterEntries(Content content, RepeaterDefinition repeaterDefinition) {
        ArrayList<String> itemPaths = new ArrayList<String>();
        itemPaths.add(repeaterDefinition.getPath());
        itemPaths.addAll(this._getDisabledConditionPaths((ModelItem)repeaterDefinition));
        View view = View.of((Collection)content.getModel(), (String[])((String[])itemPaths.toArray(String[]::new)));
        Map dataToMap = content.dataToMap((ViewItemAccessor)view, DataContext.newInstance().withDisabledValues(true).withEmptyValues(false));
        return this._getRepeaterEntries(dataToMap, repeaterDefinition.getPath());
    }

    private List<Map<String, Object>> _getRepeaterEntries(Map<String, Object> data, String path) {
        Object[] pathSegments = StringUtils.split((String)path, (String)"/");
        if (pathSegments.length == 1) {
            return (List)data.get(pathSegments[0]);
        }
        Map subData = (Map)data.get(pathSegments[0]);
        String remainPath = StringUtils.join((Object[])pathSegments, (String)"/", (int)1, (int)pathSegments.length);
        return this._getRepeaterEntries(subData, remainPath);
    }

    private Set<String> _getDisabledConditionPaths(ModelItem modelItem) {
        DisableConditions disableConditions = modelItem.getDisableConditions();
        if (disableConditions != null) {
            Set<String> disableConditionPaths = disableConditions.getConditions().stream().filter(AbstractRelativeDisableCondition.class::isInstance).map(c -> ModelHelper.getDisableConditionAbsolutePath((DisableCondition)c, (String)modelItem.getPath())).collect(Collectors.toSet());
            if (modelItem instanceof ModelItemGroup) {
                ModelItemGroup group = (ModelItemGroup)modelItem;
                for (ModelItem childModelItem : group.getChildren()) {
                    disableConditionPaths.addAll(this._getDisabledConditionPaths(childModelItem));
                }
            }
            return disableConditionPaths;
        }
        return Set.of();
    }

    @Override
    protected boolean _canEditCourse(Course course, List<String> path) {
        Request request = ContextHelper.getRequest((Context)this._context);
        request.setAttribute(ODFRightHelper.REQUEST_ATTR_EDUCATIONAL_PATHS, List.of(EducationalPath.of((String[])((String[])path.toArray(String[]::new)))));
        return super._canEditCourse(course, path) || this._contentWorkflowHelper.isAvailableAction((WorkflowAwareContent)course, 20);
    }

    @Callable(rights={"*"})
    public boolean canEditRepeaterWithPath(String contentId, List<String> path) {
        WorkflowAwareContent content = (WorkflowAwareContent)this._ametysResolver.resolveById(contentId);
        Request request = ContextHelper.getRequest((Context)this._context);
        request.setAttribute(ODFRightHelper.REQUEST_ATTR_EDUCATIONAL_PATHS, List.of(EducationalPath.of((String[])((String[])path.toArray(String[]::new)))));
        return this._contentWorkflowHelper.isAvailableAction(content, 20);
    }
}

