/*
 *  Copyright 2024 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
/**
 * This controller is used for the steering buttons of MCC workflow on a program
 */
Ext.define('Ametys.plugins.odf.pilotage.controller.ProgramMCCWorkflowController', {
    extend: 'Ametys.plugins.odf.pilotage.controller.MCCWorkflowController',
    
	constructor: function(config)
    {
        this.callParent(arguments);
        
        this._mccStatus = this.getInitialConfig("mcc-status");
		this._onIconDecorator = this.getInitialConfig("on-icon-decorator");
    },
		
    
    _onModified: function(message)
    {
        var containerTargets = message.getTargets((t) => {
            return t.getId() == Ametys.message.MessageTarget.CONTENT && Ext.Array.contains(t.getParameters().types || [], 'org.ametys.plugins.odf.Content.container');
        });
        
        if (containerTargets.length > 0 || this.updateTargetsInCurrentSelectionTargets(message))
        {
            this.refresh();
        }
    },
    
    
    /**
	 * Refresh the controller from the content informations state of given targets
	 * @param targets The content targets
	 * @protected
	 */
	_getStatus: function (targets)
	{
		this.disable();
		
        if (targets.length > 0)
        {
            var contentId = targets[0].getParameters().id; // mutiselection not supported
			this.serverCall ('getStatus', [contentId, this._mccStatus], this._getStatusCb, { 
				arguments: targets, 
				cancelCode: this.self.getName() + "$" + this.getId(), 
				refreshing: true,
				priority: Ametys.data.ServerComm.PRIORITY_LONG_REQUEST
			});
        }
	},
    
    _getStatusCb: function (params, targets)
    {
        this._contentIds = [];
        
        if (params["no-years"])
        {
            this.setDescription(this.getInitialConfig("description"));
            this.setIconDecorator(null);
            this.disable();
            this.toggle(false);
            this.setAdditionalDescription(this.getInitialConfig("noyears-description"));
        }
        else if (params["all-valid"])
        {
            // All child years are currently validated
            this.setDescription(this.getInitialConfig("description"));
            this.setIconDecorator(this._onIconDecorator);
            this.disable();
            this.toggle(true);
            this.setAdditionalDescription(this.getInitialConfig("all-valid-description"));
        }
        else if (params["no-available"])
        {
            // Action not available for all years
            this.setDescription(this.getInitialConfig("description"));
            this.setIconDecorator(null);
            this.disable();
            this.toggle(false);
            this.setAdditionalDescription(this.getInitialConfig("no-available-description"));
        }
        else
        {
			if (params['noread-contents'])
	        {
	            params['noread-contents'] = this._convertIdsToParams(params['noread-contents'], this.getInitialConfig("noread-content-description"), targets || this.getMatchingTargets());
	        }
					
	        var description = this.getInitialConfig("description");
	        
	        var allRightContents = params['allright-contents'];
	        if (allRightContents.length > 0)
	        {
	            for (var i=0; i < allRightContents.length; i++)
	            {
	                this._contentIds.push(allRightContents[i].id)
	            }
	            this.enable();
	        }
	        
	        var validContents = params['valid-contents'] || [];
	        this.toggle(validContents.length > 0);
	        
	        this.setIconDecorator(null);
	        
	        this._updateTooltipDescription (description, params);
        
        }
    },
    
    _updateTooltipDescription: function (description, params)
    {
        description = this._handlingMultiple(description, "valid", params['valid-contents']);
		description = this._handlingMultiple(description, "noright", params['noright-contents']);
		description = this._handlingMultiple(description, "noread", params['noread-contents']);
		
        this.setDescription (description);
    }
    
});
