<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2024 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                              xmlns:exsl="http://exslt.org/common"
                              xmlns:fo="http://www.w3.org/1999/XSL/Format"
                              exclude-result-prefixes="exsl">
    
    <xsl:template name="legende">
        <fo:block id="legende" xsl:use-attribute-sets="legend-title"><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_LEGENDE"/></fo:block>
        <fo:table xsl:use-attribute-sets="body legend" padding="2pt" table-layout="fixed">
            <fo:table-column column-width="10mm"/>
            <fo:table-column column-width="40mm"/>
            <fo:table-column/>
            <fo:table-body>
                <xsl:if test="/report/skills/macro">
                    <xsl:call-template name="legende-colors"/>
                </xsl:if>
                <xsl:call-template name="legende-titles"/>
                <xsl:call-template name="legende-enseignement-nature"/>
                <xsl:apply-templates select="exsl:node-set($referenceTables)/items" mode="legende"/>
            </fo:table-body>
        </fo:table>
    </xsl:template>
    
    <xsl:template name="legende-colors">
        <fo:table-row>
            <fo:table-cell number-columns-spanned="3">
                <fo:block font-weight="bold"><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_LEGEND_COLORS"/></fo:block>
            </fo:table-cell>
        </fo:table-row>
        <fo:table-row>
            <fo:table-cell><fo:block>&#160;</fo:block></fo:table-cell>
            <fo:table-cell background-color="#F0F8FF"><fo:block/></fo:table-cell>
            <fo:table-cell><fo:block><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_LEGEND_ENABLED_SKILL"/></fo:block></fo:table-cell>
        </fo:table-row>
    </xsl:template>
    
    <xsl:template name="legende-titles">
        <fo:table-row>
            <fo:table-cell number-columns-spanned="3">
                <fo:block font-weight="bold"><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_LEGEND_COLUMN_TITLES"/></fo:block>
            </fo:table-cell>
        </fo:table-row>
        <fo:table-row>
            <fo:table-cell><fo:block>&#160;</fo:block></fo:table-cell>
            <fo:table-cell><fo:block font-weight="bold"><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_COL_EVALUATED"/></fo:block></fo:table-cell>
            <fo:table-cell><fo:block><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_LEGEND_EVALUATED"/></fo:block></fo:table-cell>
        </fo:table-row>
        <fo:table-row>
            <fo:table-cell><fo:block>&#160;</fo:block></fo:table-cell>
            <fo:table-cell><fo:block font-weight="bold"><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_COL_NATURE"/></fo:block></fo:table-cell>
            <fo:table-cell><fo:block><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_LEGEND_NATURE"/></fo:block></fo:table-cell>
        </fo:table-row>
        <fo:table-row>
            <fo:table-cell><fo:block>&#160;</fo:block></fo:table-cell>
            <fo:table-cell><fo:block font-weight="bold"><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_COL_SHARED"/></fo:block></fo:table-cell>
            <fo:table-cell><fo:block><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_LEGEND_SHARED"/></fo:block></fo:table-cell>
        </fo:table-row>
        <fo:table-row>
            <fo:table-cell><fo:block>&#160;</fo:block></fo:table-cell>
            <fo:table-cell><fo:block font-weight="bold"><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_COL_COEF"/></fo:block></fo:table-cell>
            <fo:table-cell><fo:block><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_LEGEND_COEF"/></fo:block></fo:table-cell>
        </fo:table-row>
        <fo:table-row>
            <fo:table-cell><fo:block>&#160;</fo:block></fo:table-cell>
            <fo:table-cell><fo:block font-weight="bold"><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_COL_NOTE_ELIM"/></fo:block></fo:table-cell>
            <fo:table-cell><fo:block><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_LEGEND_NOTE_ELIM"/></fo:block></fo:table-cell>
        </fo:table-row>
        <fo:table-row>
            <fo:table-cell><fo:block>&#160;</fo:block></fo:table-cell>
            <fo:table-cell><fo:block font-weight="bold"><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_COL_MCC_SESSION_NB_NOTES"/></fo:block></fo:table-cell>
            <fo:table-cell><fo:block><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_LEGEND_NB_NOTES"/></fo:block></fo:table-cell>
        </fo:table-row>
        <fo:table-row>
            <fo:table-cell><fo:block>&#160;</fo:block></fo:table-cell>
            <fo:table-cell><fo:block font-weight="bold"><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_COL_MCC_SESSION_PONDERATION"/></fo:block></fo:table-cell>
            <fo:table-cell><fo:block><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_LEGEND_PONDERATION"/></fo:block></fo:table-cell>
        </fo:table-row>
        <fo:table-row>
            <fo:table-cell><fo:block>&#160;</fo:block></fo:table-cell>
            <fo:table-cell><fo:block font-weight="bold"><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_COL_MCC_SESSION_REPORT_SESSION_2"/></fo:block></fo:table-cell>
            <fo:table-cell><fo:block><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_LEGEND_REPORT_SESSION_2"/></fo:block></fo:table-cell>
        </fo:table-row>
    </xsl:template>
    
    <xsl:template name="legende-enseignement-nature">
        <!-- Display the legend items which are referenced in the report (already filtered) -->
        <xsl:if test="count(exsl:node-set($naturesEnseignement)/*) > 0">
            <fo:table-row>
                <fo:table-cell number-columns-spanned="3">
                    <fo:block font-weight="bold"><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_LEGEND_TITLE_ENSEIGNEMENT_NATURE"/></fo:block>
                </fo:table-cell>
            </fo:table-row>
            <xsl:for-each select="exsl:node-set($naturesEnseignement)/*">
                <fo:table-row>
                    <fo:table-cell><fo:block>&#160;</fo:block></fo:table-cell>
                    <fo:table-cell>
                        <fo:block font-weight="bold">
                            <xsl:call-template name="displayCodeOrShortLabel">
                                <xsl:with-param name="contentId" select="@id"/>
                            </xsl:call-template>
                        </fo:block>
                    </fo:table-cell>
                    <fo:table-cell><fo:block><xsl:value-of select="."/></fo:block></fo:table-cell>
                </fo:table-row>
            </xsl:for-each>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="items" mode="legende">
        <!-- Display the legend items which are referenced in the report -->
        <xsl:variable name="items">
            <xsl:for-each select="item">
                <xsl:variable name="currentId" select="@id"/>
                <xsl:if test="$root//*[@id = $currentId and local-name() != 'item']">
                    <xsl:copy-of select="."/>
                </xsl:if>
            </xsl:for-each>
        </xsl:variable>
        
        <!-- Display the legend only if at least one item has to be displayed -->
        <xsl:if test="count(exsl:node-set($items)/item) > 0">
            <fo:table-row>
                <fo:table-cell number-columns-spanned="3">
                    <fo:block font-weight="bold"><xsl:apply-templates select="." mode="legende-title"/></fo:block>
                </fo:table-cell>
            </fo:table-row>
            <xsl:for-each select="exsl:node-set($items)/item">
                <xsl:sort select="@order" data-type="number"/>
                <xsl:sort select="@code"/>
                <fo:table-row>
                    <fo:table-cell><fo:block>&#160;</fo:block></fo:table-cell>
                    <fo:table-cell>
                        <fo:block font-weight="bold">
                            <xsl:call-template name="displayCodeOrShortLabel">
                                <xsl:with-param name="contentId" select="@id"/>
                            </xsl:call-template>
                        </fo:block>
                    </fo:table-cell>
                    <fo:table-cell><fo:block><xsl:value-of select="@title"/></fo:block></fo:table-cell>
                </fo:table-row>
            </xsl:for-each>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="items[@id = 'odf-enumeration.CourseNature']" mode="legende-title">
        <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_LEGEND_TITLE_COURSE_NATURE"/>
    </xsl:template>
    
    <xsl:template match="items[@id = 'odf-enumeration.MccRegime']" mode="legende-title">
        <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_LEGEND_TITLE_REGIME"/>
    </xsl:template>
    
    <xsl:template match="items[@id = 'odf-enumeration.MccModaliteSession1']" mode="legende-title">
        <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_LEGEND_TITLE_SESSION_MODALITE_1"/>
    </xsl:template>
    
    <xsl:template match="items[@id = 'odf-enumeration.MccModaliteSession2']" mode="legende-title">
        <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_LEGEND_TITLE_SESSION_MODALITE_2"/>
    </xsl:template>
    
    <xsl:template match="items[@id = 'odf-enumeration.MccSessionNature']" mode="legende-title">
        <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_LEGEND_TITLE_SESSION_NATURE"/>
    </xsl:template>
</xsl:stylesheet>
