<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2020 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                              xmlns:cms="http://ametys.org/cms/3.0"
                              xmlns:exsl="http://exslt.org/common"
                              xmlns:su="org.ametys.core.util.StringUtils"
                              xmlns:docbook="http://docbook.org/ns/docbook"
                              xmlns:odf="org.ametys.plugins.odfweb.xslt.OdfXSLTHelper"
                              xmlns:double="java.lang.Double"
                              exclude-result-prefixes="exsl cms docbook odf su double">
    
    <xsl:import href="odf-view:odf-pilotage://stylesheets/pilotage/report/params/mcc.xsl"/>
    <xsl:import href="odf-view:odf-pilotage://stylesheets/pilotage/utils/xls.xsl"/>
    <xsl:import href="odf-view:odf-pilotage://stylesheets/pilotage/report/mcc/styles2xls.xsl"/>
    <xsl:import href="odf-view:odf-pilotage://stylesheets/pilotage/report/mcc/header2xls.xsl"/>
    <xsl:import href="odf-view:odf-pilotage://stylesheets/pilotage/report/mcc/legende2xls.xsl"/>
    
    <xsl:template name="css-styles">
        <xsl:call-template name="css-styles-mcc"/>
    </xsl:template>
    
    <xsl:template name="table-head">
        <xsl:apply-templates select="program|subProgram|container" mode="title" />
        <xsl:call-template name="table-header"/>
    </xsl:template>
    
    <xsl:template name="table-body">
        <xsl:apply-templates select="program|subProgram|container" mode="document-content" />
        <xsl:call-template name="legende" />
    </xsl:template>
    
    <xsl:template name="section-header">
        <xsl:apply-templates select="ancestor-or-self::*[parent::program or parent::subProgram or parent::container][local-name() = 'subProgram' or local-name() = 'container']" mode="section-header-line"/>
        <tr class="new-header"><td colspan="{$nbColumns}">&#160;</td></tr>
    </xsl:template>
    
    <xsl:template name="table-header">
        <tr>
            <td class="maquette" colspan="{$nbColumnsMaquette}"><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_COL_MAQUETTE"/></td>
            <td class="evaluation" colspan="{$nbColumnsElpEval + $nbColumnsMccSession1 + $nbColumnsMccSession2}"><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_COL_EVALUATION"/></td>
        </tr>
        <tr>
            <xsl:call-template name="table-header-maquette"/>
            <xsl:call-template name="table-header-evaluation-elp"/>
            <td class="session1" colspan="{$nbColumnsMccSession1}"><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_COL_MCC_SESSION_1"/></td>
            <td class="session2" colspan="{$nbColumnsMccSession2}"><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_COL_MCC_SESSION_2"/></td>
        </tr>
        <tr>
            <xsl:call-template name="table-header-session1"/>
            <xsl:call-template name="table-header-session2"/>
        </tr>
    </xsl:template>
    
    <xsl:template name="table-header-maquette">
        <td class="maquette" style="width: 10mm" rowspan="2"><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_COL_EVALUATED"/></td>
        <td class="maquette" style="width: 20mm;" rowspan="2"><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_COL_CODE"/></td>
        <td class="maquette" style="width: 15mm;" rowspan="2"><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_COL_NATURE"/></td>
        <td class="maquette" style="width: 85mm;" rowspan="2"><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_COL_LABEL"/></td>
        <td class="maquette" style="width: 10mm;" rowspan="2"><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_COL_SHARED"/></td>
        <td class="maquette" style="width: 10mm;" rowspan="2"><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_COL_ECTS"/></td>
        <td class="maquette" style="width: 10mm;" rowspan="2"><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_COL_COEF"/></td>
        <td class="maquette" style="width: 10mm;" rowspan="2"><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_COL_NOTE_ELIM"/></td>
        <td class="maquette" style="width: 15mm;" rowspan="2"><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_COL_REGIME"/></td>
        <td class="maquette" style="width: 20mm;" rowspan="2" colspan="2"><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_COL_VOLUME_HORAIRE"/></td>
    </xsl:template>
    
    <xsl:template name="table-header-evaluation-elp"/>
    
    <xsl:template name="table-header-session1">
        <td class="session1" style="width: 70mm;"><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_COL_MCC_SESSION_LABEL"/></td>
        <td class="session1" style="width: 15mm;"><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_COL_MCC_SESSION_MODALITE"/></td>
        <td class="session1" style="width: 15mm;"><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_COL_MCC_SESSION_NATURE"/></td>
        <td class="session1" style="width: 15mm;"><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_COL_MCC_SESSION_DUREE"/></td>
        <td class="session1" style="width: 15mm;"><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_COL_MCC_SESSION_COEF"/></td>
        <td class="session1" style="width: 15mm;"><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_COL_MCC_SESSION_NOTE_ELIM"/></td>
        <td class="session1" style="width: 15mm;"><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_COL_MCC_SESSION_NB_NOTES"/></td>
        <td class="session1" style="width: 15mm;"><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_COL_MCC_SESSION_PONDERATION"/></td>
        <td class="session1" style="width: 10mm;"><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_COL_MCC_SESSION_REPORT_SESSION_2"/></td>
    </xsl:template>
    
    <xsl:template name="table-header-session2">
        <td class="session2" style="width: 70mm;"><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_COL_MCC_SESSION_LABEL"/></td>
        <td class="session2" style="width: 15mm;"><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_COL_MCC_SESSION_MODALITE"/></td>
        <td class="session2" style="width: 15mm;"><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_COL_MCC_SESSION_NATURE"/></td>
        <td class="session2" style="width: 15mm;"><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_COL_MCC_SESSION_DUREE"/></td>
        <td class="session2" style="width: 15mm;"><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_COL_MCC_SESSION_COEF"/></td>
        <td class="session2" style="width: 15mm;"><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_COL_MCC_SESSION_NOTE_ELIM"/></td>
        <td class="session2" style="width: 15mm;"><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_COL_MCC_SESSION_NB_NOTES"/></td>
        <td class="session2" style="width: 15mm;"><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_COL_MCC_SESSION_PONDERATION"/></td>
    </xsl:template>
    
    <xsl:template match="program|subProgram|container" mode="document-content">
        <xsl:apply-templates select="subProgram|container|courseList"/>
    </xsl:template>
    
    <xsl:template match="program|subProgram|container">
        <xsl:if test="courseList/course">
            <xsl:call-template name="mcc-table">
                <xsl:with-param name="courseLists" select="courseList[course]"/>
            </xsl:call-template>
        </xsl:if>
        <xsl:apply-templates select="subProgram|container" />
    </xsl:template>
    
    <xsl:template match="courseList">
        <xsl:if test="course">
            <xsl:call-template name="mcc-table">
                <xsl:with-param name="courseLists" select="."/>
            </xsl:call-template>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="mcc-table">
        <xsl:param name="courseLists"/>
        
        <xsl:if test="$courseLists/course">
            <xsl:variable name="displayMcc2" select="count($courseLists//course[@session2 = 'available']) > 0"/>
            
            <xsl:call-template name="section-header"/>
            <xsl:apply-templates select="$courseLists" mode="table-content">
                <xsl:with-param name="displayMcc2" select="$displayMcc2"/>
            </xsl:apply-templates>
            <xsl:apply-templates select="controles" />
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="courseList" mode="table-content">
        <xsl:param name="depth" select="'0'" />
        <xsl:param name="displayMcc2" />
        
        <xsl:variable name="courseListChoice" select="choiceType/@value"/>
        <xsl:choose>
            <xsl:when test="$courseListChoice = 'CHOICE'">
                <tr class="courselist">
                    <td colspan="{$titleColumnPosition - 1}" class="first-cell"/>
                    <td colspan="{$nbColumns - $titleColumnPosition + 1 - $nbColumnsMccSession2 * not($displayMcc2)}">
                        <xsl:call-template name="recursive-print">
                            <xsl:with-param name="times" select="$depth" />
                        </xsl:call-template>
                        <i18n:translate>
                            <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_COURSELIST_CHOICE"/>
                            <i18n:param><xsl:value-of select="min" /></i18n:param>
                        </i18n:translate>
                    </td>
                </tr>
            </xsl:when>
            <xsl:when test="$courseListChoice = 'OPTIONAL'">
                <tr class="courselist">
                    <td colspan="{$titleColumnPosition - 1}" class="first-cell"/>
                    <td colspan="{$nbColumns - $titleColumnPosition + 1 - $nbColumnsMccSession2 * not($displayMcc2)}">
                        <xsl:call-template name="recursive-print">
                            <xsl:with-param name="times" select="$depth" />
                        </xsl:call-template>
                        <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_COURSELIST_OPTIONAL"/>
                    </td>
                </tr>
            </xsl:when>
        </xsl:choose>
        
        <xsl:apply-templates select="course">
            <xsl:with-param name="depth" select="$depth + ($courseListChoice != 'MANDATORY')"/>
            <xsl:with-param name="displayMcc2" select="$displayMcc2"/>
        </xsl:apply-templates>
    </xsl:template>
    
    <xsl:template match="course">
        <xsl:param name="depth" select="'0'" />
        <xsl:param name="displayMcc2" select="true()"/>
        
        <xsl:variable name="currentCourse" select="."/>
        <xsl:variable name="courseParts">
            <xsl:for-each select="exsl:node-set($naturesEnseignement)/*">
                <xsl:call-template name="enseignement-cells">
                    <xsl:with-param name="code">
                        <xsl:call-template name="displayCodeOrShortLabel">
                            <xsl:with-param name="contentId" select="@id"/>
                        </xsl:call-template>
                    </xsl:with-param>
                    <xsl:with-param name="volumeHoraire" select="$currentCourse/courseParts[nature/@id = current()/@id]/nbHours"/>
                    <xsl:with-param name="mcc1" select="$currentCourse/mcc/mccSession1/entry[natureEnseignement/@id = current()/@id]"/>
                    <xsl:with-param name="mcc2" select="$currentCourse[@session2 = 'available']/mcc/mccSession2/entry[natureEnseignement/@id = current()/@id]"/>
                    <xsl:with-param name="displayMcc2" select="$displayMcc2"/>
                </xsl:call-template>
            </xsl:for-each>
            
            <!-- Ajouter les lignes sans nature d'enseignement -->
            <xsl:if test="$currentCourse/mcc/*/entry[not(natureEnseignement/@id)]">
                <xsl:call-template name="enseignement-cells">
                    <xsl:with-param name="mcc1" select="$currentCourse/mcc/mccSession1/entry[not(natureEnseignement/@id)]"/>
                    <xsl:with-param name="mcc2" select="$currentCourse[@session2 = 'available']/mcc/mccSession2/entry[not(natureEnseignement/@id)]"/>
                    <xsl:with-param name="displayMcc2" select="$displayMcc2"/>
                </xsl:call-template>
            </xsl:if>
        </xsl:variable>
        
        <xsl:choose>
            <xsl:when test="exsl:node-set($courseParts)/row">
                <xsl:for-each select="exsl:node-set($courseParts)/row">
                    <xsl:choose>
                        <xsl:when test="position() = 1">
                            <tr>
                                <xsl:call-template name="course-attributes">
                                    <xsl:with-param name="type" select="$currentCourse/courseType/code"/>
                                </xsl:call-template>
                                
                                <xsl:apply-templates select="$currentCourse" mode="cells">
                                    <xsl:with-param name="depth" select="$depth"/>
                                    <!-- Sum all computed rows from course parts and evaluations to get the total course rowspan -->
                                    <xsl:with-param name="courseRowspan" select="count(exsl:node-set($courseParts)/row)"/>
                                </xsl:apply-templates>
                                
                                <xsl:copy-of select="*"/>
                            </tr>
                        </xsl:when>
                        <xsl:otherwise>
                            <tr>
                                <xsl:call-template name="course-attributes">
                                    <xsl:with-param name="type" select="$currentCourse/courseType/code"/>
                                    <xsl:with-param name="isFirst" select="false()"/>
                                </xsl:call-template>
                                
                                <xsl:copy-of select="*"/>
                            </tr>
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:for-each>
            </xsl:when>
            <xsl:otherwise>
                <tr>
                    <xsl:call-template name="course-attributes">
                        <xsl:with-param name="type" select="$currentCourse/courseType/code"/>
                    </xsl:call-template>
                    
                    <xsl:apply-templates select="." mode="cells">
                        <xsl:with-param name="depth" select="$depth"/>
                    </xsl:apply-templates>
                    
                    <xsl:call-template name="mcc-empty-cells">
                        <xsl:with-param name="displayMcc2" select="$displayMcc2"/>
                    </xsl:call-template>
                </tr>
            </xsl:otherwise>
        </xsl:choose>
        
        <xsl:apply-templates select="courseList[course]" mode="table-content">
            <xsl:with-param name="depth" select="$depth + 1"/>
            <xsl:with-param name="displayMcc2" select="$displayMcc2"/>
        </xsl:apply-templates>
    </xsl:template>
    
    <xsl:template name="enseignement-cells">
        <xsl:param name="code"/>
        <xsl:param name="volumeHoraire" select="foo/*"/>
        <xsl:param name="mcc1"/>
        <xsl:param name="mcc2"/>
        <xsl:param name="displayMcc2"/>
        
        <xsl:variable name="mccLines" select="double:max(1, double:max(count($mcc1), count($mcc2) * $displayMcc2))"/>
        
        <xsl:if test="count($volumeHoraire) > 0 or $mccLines > 0">
            <xsl:variable name="natureEnseignementRowspan" select="cms:getTotalNotesRowspan($mcc1, $mcc2, $displayMcc2)"/>
            
            <row>
                <td class="nature-ens" rowspan="{$natureEnseignementRowspan}">
                    <xsl:value-of select="$code"/>
                </td>
                <td rowspan="{$natureEnseignementRowspan}">
                    <xsl:if test="$code or count($volumeHoraire) > 0">
                        <xsl:call-template name="display-double">
                            <xsl:with-param name="value" select="sum($volumeHoraire)"/>
                        </xsl:call-template>
                    </xsl:if>
                </td>
                <xsl:call-template name="mcc">
                    <xsl:with-param name="mcc1" select="$mcc1[1]"/>
                    <xsl:with-param name="mcc2" select="$mcc2[1]"/>
                    <xsl:with-param name="displayMcc2" select="$displayMcc2"/>
                </xsl:call-template>
            </row>
            
            <!-- Other notes on same MCC session line -->
            <xsl:call-template name="mcc-recursive-row-notes">
                <xsl:with-param name="currentPosition" select="2"/>
                <xsl:with-param name="mcc1" select="$mcc1[1]"/>
                <xsl:with-param name="mcc2" select="$mcc2[1]"/>
                <xsl:with-param name="displayMcc2" select="$displayMcc2"/>
            </xsl:call-template>
            
            <!-- Other MCC session lines -->
            <xsl:call-template name="mcc-recursive-row">
                <xsl:with-param name="currentPosition" select="2"/>
                <xsl:with-param name="maxPosition" select="$mccLines"/>
                <xsl:with-param name="mcc1" select="$mcc1"/>
                <xsl:with-param name="mcc2" select="$mcc2"/>
                <xsl:with-param name="displayMcc2" select="$displayMcc2"/>
            </xsl:call-template>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="mcc-recursive-row-notes">
        <xsl:param name="currentPosition"/>
        <xsl:param name="mcc1"/>
        <xsl:param name="mcc2"/>
        <xsl:param name="displayMcc2"/>
        <xsl:param name="maxPosition" select="double:max(count($mcc1/notes/entry), count($mcc2/notes/entry) * $displayMcc2)"/>
        
        <xsl:if test="$currentPosition &lt;= $maxPosition">
            <row>
                <!-- session 1 -->
                <xsl:apply-templates select="$mcc1" mode="cell-session-ponderation">
                    <xsl:with-param name="position" select="$currentPosition"/>
                    <xsl:with-param name="suffix"><xsl:apply-templates select="$mcc1" mode="suffix"/></xsl:with-param>
                    <xsl:with-param name="isLast" select="false()"/>
                </xsl:apply-templates>
                
                <!-- session 2 -->
                <xsl:if test="$displayMcc2">
                    <xsl:apply-templates select="$mcc2" mode="cell-session-ponderation">
                        <xsl:with-param name="position" select="$currentPosition"/>
                        <xsl:with-param name="suffix"><xsl:apply-templates select="$mcc2" mode="suffix"/></xsl:with-param>
                    </xsl:apply-templates>
                </xsl:if>
            </row>
            
            <!-- Recursive call -->
            <xsl:call-template name="mcc-recursive-row-notes">
                <xsl:with-param name="currentPosition" select="$currentPosition + 1"/>
                <xsl:with-param name="mcc1" select="$mcc1"/>
                <xsl:with-param name="mcc2" select="$mcc2"/>
                <xsl:with-param name="displayMcc2" select="$displayMcc2"/>
                <xsl:with-param name="maxPosition" select="$maxPosition"/>
            </xsl:call-template>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="mcc-recursive-row">
        <xsl:param name="currentPosition"/>
        <xsl:param name="maxPosition"/>
        <xsl:param name="mcc1"/>
        <xsl:param name="mcc2"/>
        <xsl:param name="displayMcc2"/>
        
        <xsl:if test="$currentPosition &lt;= $maxPosition">
            <row>
                <xsl:call-template name="mcc">
                    <xsl:with-param name="mcc1" select="$mcc1[$currentPosition]"/>
                    <xsl:with-param name="mcc2" select="$mcc2[$currentPosition]"/>
                    <xsl:with-param name="displayMcc2" select="$displayMcc2"/>
                </xsl:call-template>
            </row>
            
            <!-- Other notes on same MCC session line -->
            <xsl:call-template name="mcc-recursive-row-notes">
                <xsl:with-param name="currentPosition" select="2"/>
                <xsl:with-param name="mcc1" select="$mcc1[$currentPosition]"/>
                <xsl:with-param name="mcc2" select="$mcc2[$currentPosition]"/>
                <xsl:with-param name="displayMcc2" select="$displayMcc2"/>
            </xsl:call-template>
            
            <!-- Recursive call -->
            <xsl:call-template name="mcc-recursive-row">
                <xsl:with-param name="currentPosition" select="$currentPosition + 1"/>
                <xsl:with-param name="maxPosition" select="$maxPosition"/>
                <xsl:with-param name="mcc1" select="$mcc1"/>
                <xsl:with-param name="mcc2" select="$mcc2"/>
                <xsl:with-param name="displayMcc2" select="$displayMcc2"/>
            </xsl:call-template>
        </xsl:if>
    </xsl:template>

    <xsl:template name="mcc">
        <xsl:param name="mcc1"/>
        <xsl:param name="mcc2"/>
        <xsl:param name="displayMcc2"/>
        
        <!-- Rowspan is the max number of notes between the entry of session1 and session2, it there is no notes, it is set to 1 -->
        <xsl:variable name="sessionRowspan" select="double:max(1, double:max(count($mcc1/notes/entry), count($mcc2/notes/entry) * $displayMcc2))"/>
        
        <!-- session 1 -->
        <xsl:call-template name="mcc-session-cells-1">
            <xsl:with-param name="entry" select="$mcc1" />
            <xsl:with-param name="sessionRowspan" select="$sessionRowspan" />
        </xsl:call-template>
        
        <!-- session 2 -->
        <xsl:if test="$displayMcc2">
            <xsl:call-template name="mcc-session-cells-2">
                <xsl:with-param name="entry" select="$mcc2" />
                <xsl:with-param name="sessionRowspan" select="$sessionRowspan" />
            </xsl:call-template>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="mcc-session-cells-1">
        <xsl:param name="entry" />
        <xsl:param name="sessionRowspan" />
        
        <xsl:choose>
            <xsl:when test="$entry">
                <xsl:apply-templates select="$entry" mode="mcc-session-cells-non-empty-1">
                    <xsl:with-param name="sessionRowspan" select="$sessionRowspan"/>
                </xsl:apply-templates>
            </xsl:when>
            <xsl:otherwise>
                <xsl:call-template name="mcc-session-empty-cells-1">
                    <xsl:with-param name="sessionRowspan" select="$sessionRowspan"/>
                </xsl:call-template>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template name="mcc-session-cells-2">
        <xsl:param name="entry" />
        <xsl:param name="sessionRowspan" />
        
        <xsl:choose>
            <xsl:when test="$entry">
                <xsl:apply-templates select="$entry" mode="mcc-session-cells-non-empty-2">
                    <xsl:with-param name="sessionRowspan" select="$sessionRowspan"/>
                </xsl:apply-templates>
            </xsl:when>
            <xsl:otherwise>
                <xsl:call-template name="mcc-session-empty-cells-2">
                    <xsl:with-param name="sessionRowspan" select="$sessionRowspan"/>
                </xsl:call-template>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template match="entry" mode="suffix"/>
    
    <xsl:template match="entry" mode="mcc-session-cells-non-empty-1">
        <xsl:param name="sessionRowspan" select="1"/>
        
        <xsl:variable name="suffix">
            <xsl:apply-templates select="." mode="suffix"/>
        </xsl:variable>
        
        <xsl:apply-templates select="." mode="cell-session-label">
            <xsl:with-param name="suffix" select="$suffix"/>
            <xsl:with-param name="sessionRowspan" select="$sessionRowspan"/>
        </xsl:apply-templates>
        <xsl:apply-templates select="." mode="cell-session-modalite">
            <xsl:with-param name="suffix" select="$suffix"/>
            <xsl:with-param name="sessionRowspan" select="$sessionRowspan"/>
        </xsl:apply-templates>
        <xsl:apply-templates select="." mode="cell-session-nature">
            <xsl:with-param name="suffix" select="$suffix"/>
            <xsl:with-param name="sessionRowspan" select="$sessionRowspan"/>
        </xsl:apply-templates>
        <xsl:apply-templates select="." mode="cell-session-duree">
            <xsl:with-param name="suffix" select="$suffix"/>
            <xsl:with-param name="sessionRowspan" select="$sessionRowspan"/>
        </xsl:apply-templates>
        <xsl:apply-templates select="." mode="cell-session-coef">
            <xsl:with-param name="suffix" select="$suffix"/>
            <xsl:with-param name="sessionRowspan" select="$sessionRowspan"/>
        </xsl:apply-templates>
        <xsl:apply-templates select="." mode="cell-session-note">
            <xsl:with-param name="suffix" select="$suffix"/>
            <xsl:with-param name="sessionRowspan" select="$sessionRowspan"/>
        </xsl:apply-templates>
        <xsl:apply-templates select="." mode="cell-session-nb-notes">
            <xsl:with-param name="suffix" select="$suffix"/>
            <xsl:with-param name="sessionRowspan" select="$sessionRowspan"/>
        </xsl:apply-templates>
        <xsl:apply-templates select="." mode="cell-session-ponderation">
            <xsl:with-param name="suffix" select="$suffix"/>
            <xsl:with-param name="isLast" select="false()"/>
        </xsl:apply-templates>
        <xsl:apply-templates select="." mode="cell-session-report">
            <xsl:with-param name="suffix" select="$suffix"/>
            <xsl:with-param name="sessionRowspan" select="$sessionRowspan"/>
        </xsl:apply-templates>
    </xsl:template>
    
    <xsl:template match="entry" mode="mcc-session-cells-non-empty-2">
        <xsl:param name="sessionRowspan" select="1"/>
        
        <xsl:variable name="suffix">
            <xsl:apply-templates select="." mode="suffix"/>
        </xsl:variable>
        
        <xsl:apply-templates select="." mode="cell-session-label">
            <xsl:with-param name="suffix" select="$suffix"/>
            <xsl:with-param name="sessionRowspan" select="$sessionRowspan"/>
        </xsl:apply-templates>
        <xsl:apply-templates select="." mode="cell-session-modalite">
            <xsl:with-param name="suffix" select="$suffix"/>
            <xsl:with-param name="sessionRowspan" select="$sessionRowspan"/>
        </xsl:apply-templates>
        <xsl:apply-templates select="." mode="cell-session-nature">
            <xsl:with-param name="suffix" select="$suffix"/>
            <xsl:with-param name="sessionRowspan" select="$sessionRowspan"/>
        </xsl:apply-templates>
        <xsl:apply-templates select="." mode="cell-session-duree">
            <xsl:with-param name="suffix" select="$suffix"/>
            <xsl:with-param name="sessionRowspan" select="$sessionRowspan"/>
        </xsl:apply-templates>
        <xsl:apply-templates select="." mode="cell-session-coef">
            <xsl:with-param name="suffix" select="$suffix"/>
            <xsl:with-param name="sessionRowspan" select="$sessionRowspan"/>
        </xsl:apply-templates>
        <xsl:apply-templates select="." mode="cell-session-note">
            <xsl:with-param name="suffix" select="$suffix"/>
            <xsl:with-param name="sessionRowspan" select="$sessionRowspan"/>
        </xsl:apply-templates>
        <xsl:apply-templates select="." mode="cell-session-nb-notes">
            <xsl:with-param name="suffix" select="$suffix"/>
            <xsl:with-param name="sessionRowspan" select="$sessionRowspan"/>
        </xsl:apply-templates>
        <xsl:apply-templates select="." mode="cell-session-ponderation">
            <xsl:with-param name="suffix" select="$suffix"/>
        </xsl:apply-templates>
    </xsl:template>
    
    <xsl:template match="entry" mode="cell-session-label">
        <xsl:param name="suffix"/>
        <xsl:param name="sessionRowspan"/>
        
        <td class="session-cell{$suffix}" rowspan="{$sessionRowspan}">
            <xsl:if test="label != ''">
                <strong><xsl:value-of select="label"/></strong>
            </xsl:if>
            <xsl:if test="foreignLanguage/@id">
                <xsl:if test="label != ''"><xsl:text> - </xsl:text></xsl:if>
                <span class="lang">
                    <xsl:if test="foreignLanguage/@id">
                        <strong><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_COL_MCC_SESSION_LANG"/></strong>
                        <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_LABEL_VALUE_SEPARATOR"/>
                        <xsl:value-of select="foreignLanguage/@title"/>
                    </xsl:if>
                </span>
            </xsl:if>
            <xsl:if test="remarques != ''">
                <xsl:if test="label != '' or foreignLanguage/@id"><xsl:text> - </xsl:text></xsl:if>
                <span class="remarques">
                    <xsl:call-template name="text.nl2hyphen">  
                        <xsl:with-param name="input" select="remarques"/>
                    </xsl:call-template>
                </span>
            </xsl:if>
        </td>
    </xsl:template>
    
    <xsl:template match="entry" mode="cell-session-modalite">
        <xsl:param name="suffix"/>
        <xsl:param name="sessionRowspan"/>
        
        <td class="session-cell-centered{$suffix}" rowspan="{$sessionRowspan}">
            <xsl:if test="nombre != ''">
                <xsl:value-of select="nombre" />
                <xsl:if test="modalite/@id">
                    <xsl:text> </xsl:text>
                </xsl:if>
            </xsl:if>
            <xsl:call-template name="displayCodeOrShortLabel">
                <xsl:with-param name="contentId" select="modalite/@id"/>
            </xsl:call-template>
        </td>
    </xsl:template>
    
    <xsl:template match="entry" mode="cell-session-nature">
        <xsl:param name="suffix"/>
        <xsl:param name="sessionRowspan"/>
        
        <td class="session-cell-centered{$suffix}" rowspan="{$sessionRowspan}">
            <xsl:call-template name="displayCodeOrShortLabel">
                <xsl:with-param name="contentId" select="nature/@id"/>
            </xsl:call-template>
        </td>
    </xsl:template>
    
    <xsl:template match="entry" mode="cell-session-duree">
        <xsl:param name="suffix"/>
        <xsl:param name="sessionRowspan"/>
        
        <td class="session-cell-centered{$suffix}" rowspan="{$sessionRowspan}">
            <xsl:if test="duree != ''"><xsl:value-of select="odf:minute2hour(duree)" /></xsl:if>
        </td>
    </xsl:template>
    
    <xsl:template match="entry" mode="cell-session-coef">
        <xsl:param name="suffix"/>
        <xsl:param name="sessionRowspan"/>
        
        <td class="session-cell-coef{$suffix}" rowspan="{$sessionRowspan}">
            <xsl:if test="coefficient != ''">
                <xsl:choose>
                    <xsl:when test="contains(coefficient, '%') or contains(coefficient, '/')">
                        <xsl:value-of select="coefficient"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:call-template name="display-double">
                            <xsl:with-param name="value" select="coefficient" />
                            <xsl:with-param name="showZero" select="true()" />
                        </xsl:call-template>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:if>
        </td>
    </xsl:template>
    
    <xsl:template match="entry" mode="cell-session-note">
        <xsl:param name="suffix"/>
        <xsl:param name="sessionRowspan"/>
        
        <td class="session-cell-centered{$suffix}" rowspan="{$sessionRowspan}">
            <xsl:call-template name="display-double">
                <xsl:with-param name="value" select="noteEliminatoire" />
                <xsl:with-param name="showZero" select="true()" />
            </xsl:call-template>
        </td>
    </xsl:template>
    
    <xsl:template match="entry" mode="cell-session-nb-notes">
        <xsl:param name="suffix"/>
        <xsl:param name="sessionRowspan"/>
        
        <td class="session-cell-centered{$suffix}" rowspan="{$sessionRowspan}">
            <xsl:choose>
                <xsl:when test="notes/entry">
                    <xsl:value-of select="count(notes/entry)"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:call-template name="default-nb-notes"/>
                </xsl:otherwise>
            </xsl:choose>
        </td>
    </xsl:template>
    
    <xsl:template match="entry" mode="cell-session-ponderation">
        <xsl:param name="position" select="1"/>
        <xsl:param name="suffix"/>
        <xsl:param name="isLast" select="true()"/>
        
        <xsl:variable name="value" select="notes/entry[$position]/ponderation"/>
        
        <xsl:variable name="class"><xsl:if test="not($isLast)">session-cell-</xsl:if>centered<xsl:value-of select="$suffix"/></xsl:variable>
        <td class="{$class}">
            <xsl:choose>
                <xsl:when test="$value">
                    <xsl:call-template name="display-double">
                        <xsl:with-param name="value" select="$value"/>
                        <xsl:with-param name="showZero" select="true()" />
                        <xsl:with-param name="format" select="'#,##'"/>
                    </xsl:call-template>
                    <xsl:text>%</xsl:text>
                </xsl:when>
                <xsl:when test="$position = 1">
                    <xsl:call-template name="default-ponderation"/>
                </xsl:when>
            </xsl:choose>
        </td>
    </xsl:template>
    
    <xsl:template match="entry" mode="cell-session-report">
        <xsl:param name="suffix"/>
        <xsl:param name="sessionRowspan"/>
        
        <td class="centered{$suffix}" rowspan="{$sessionRowspan}">
            <xsl:if test="reportSession2 = 'true'">X</xsl:if>
        </td>
    </xsl:template>
    
    <xsl:template match="course" mode="cells">
        <xsl:param name="depth" select="'0'" />
        <xsl:param name="courseRowspan" select="1"/>
        
        <xsl:apply-templates select="." mode="cell-course-evaluated">
            <xsl:with-param name="courseRowspan" select="$courseRowspan"/>
        </xsl:apply-templates>
        <xsl:apply-templates select="." mode="cell-course-code">
            <xsl:with-param name="courseRowspan" select="$courseRowspan"/>
        </xsl:apply-templates>
        <xsl:apply-templates select="." mode="cell-course-nature">
            <xsl:with-param name="courseRowspan" select="$courseRowspan"/>
        </xsl:apply-templates>
        <xsl:apply-templates select="." mode="cell-course-label">
            <xsl:with-param name="courseRowspan" select="$courseRowspan"/>
            <xsl:with-param name="depth" select="$depth"/>
        </xsl:apply-templates>
        <xsl:apply-templates select="." mode="cell-course-shared">
            <xsl:with-param name="courseRowspan" select="$courseRowspan"/>
        </xsl:apply-templates>
        <xsl:apply-templates select="." mode="cell-course-ects">
            <xsl:with-param name="courseRowspan" select="$courseRowspan"/>
        </xsl:apply-templates>
        <xsl:apply-templates select="." mode="cell-course-coef">
            <xsl:with-param name="courseRowspan" select="$courseRowspan"/>
        </xsl:apply-templates>
        <xsl:apply-templates select="." mode="cell-course-note">
            <xsl:with-param name="courseRowspan" select="$courseRowspan"/>
        </xsl:apply-templates>
        <xsl:apply-templates select="." mode="cell-course-regime">
            <xsl:with-param name="courseRowspan" select="$courseRowspan"/>
        </xsl:apply-templates>
    </xsl:template>
    
    <xsl:template match="course" mode="cell-course-evaluated">
        <xsl:param name="courseRowspan"/>
        <td class="first-cell" rowspan="{$courseRowspan}">
            <xsl:if test="not(isEvaluated) or isEvaluated = 'true'">X</xsl:if>
        </td>
    </xsl:template>
    
    <xsl:template match="course" mode="cell-course-code">
        <xsl:param name="courseRowspan"/>
        <td class="codeAmetys" rowspan="{$courseRowspan}">
            <xsl:apply-templates select="." mode="code"/>
        </td>
    </xsl:template>
    
    <xsl:template match="course" mode="cell-course-nature">
        <xsl:param name="courseRowspan"/>
        <td rowspan="{$courseRowspan}">
            <xsl:value-of select="courseType/code" />
        </td>
    </xsl:template>
    
    <xsl:template match="course" mode="cell-course-label">
        <xsl:param name="courseRowspan"/>
        <xsl:param name="depth"/>
        <td rowspan="{$courseRowspan}">
            <!-- Identation. Print 4 spaces per level -->
            <xsl:call-template name="recursive-print">
                <xsl:with-param name="times" select="$depth" />
            </xsl:call-template>
            <xsl:value-of select="su:sanitizeXlsHtml(title)" />
        </td>
    </xsl:template>
    
    <xsl:template match="course" mode="cell-course-shared">
        <xsl:param name="courseRowspan"/>
        <td class="centered" rowspan="{$courseRowspan}">
            <xsl:if test="isShared = 'true'">X</xsl:if>
        </td>
    </xsl:template>
    
    <xsl:template match="course" mode="cell-course-ects">
        <xsl:param name="courseRowspan"/>
        <td class="centered" rowspan="{$courseRowspan}">
            <xsl:call-template name="display-double">
                <xsl:with-param name="value" select="odf:getEcts(@id, @path)" />
            </xsl:call-template>
        </td>
    </xsl:template>
    
    <xsl:template match="course" mode="cell-course-coef">
        <xsl:param name="courseRowspan"/>
        <td class="centered" rowspan="{$courseRowspan}">
            <xsl:call-template name="display-double">
                <xsl:with-param name="value" select="odf:getValueForPath(@id, 'mccCoefficientByEducationalPath/coefficient', @path, 'mccCoefficient')" />
            </xsl:call-template>
        </td>
    </xsl:template>
    
    <xsl:template match="course" mode="cell-course-regime">
        <xsl:param name="courseRowspan"/>
        <td rowspan="{$courseRowspan}">
            <xsl:call-template name="displayCodeOrShortLabel">
                <xsl:with-param name="contentId" select="mccRegime/@id"/>
            </xsl:call-template>
        </td>
    </xsl:template>
    
    <xsl:template match="course" mode="cell-course-note">
        <xsl:param name="courseRowspan"/>
        <td rowspan="{$courseRowspan}">
            <xsl:call-template name="display-double">
                <xsl:with-param name="value" select="mccNoteEliminatoire" />
                <xsl:with-param name="showZero" select="true()" />
            </xsl:call-template>
        </td>
    </xsl:template>
    
    <xsl:template name="mcc-empty-cells">
        <xsl:param name="displayMcc2" />
        
        <xsl:call-template name="volume-horaire-empty-cells" />
        <xsl:call-template name="mcc-session-empty-cells-1" />
        <xsl:if test="$displayMcc2">
            <xsl:call-template name="mcc-session-empty-cells-2" />
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="volume-horaire-empty-cells">
        <td colspan="2"/>
    </xsl:template>
    
    <xsl:template name="mcc-session-empty-cells-1">
        <xsl:param name="sessionRowspan" select="1"/>
        <td colspan="{$nbColumnsMccSession1}" rowspan="{$sessionRowspan}"/>
    </xsl:template>
    
    <xsl:template name="mcc-session-empty-cells-2">
        <xsl:param name="sessionRowspan" select="1"/>
        <td colspan="{$nbColumnsMccSession2}" rowspan="{$sessionRowspan}"/>
    </xsl:template>
    
    <xsl:template match="knowledgeCheck|controles">
        <xsl:param name="padding" select="0"/>
        
        <xsl:if test="cms:isNotRichTextEmpty(.)">
            <tr>
                <td colspan="{$nbColumns}" style="padding-left: {$padding}mm;">
                    <xsl:apply-templates select="docbook:article">
                        <xsl:with-param name="level" select="3"/>
                    </xsl:apply-templates>
                </td>
            </tr>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="course-attributes">
        <xsl:param name="type"/>
        <xsl:param name="isFirst" select="true()"/>
        
        <xsl:attribute name="class">
            <xsl:choose>
                <xsl:when test="$type='UE'"><xsl:if test="$isFirst">first-</xsl:if>ue</xsl:when>
                <xsl:otherwise>elp</xsl:otherwise>
            </xsl:choose>
        </xsl:attribute>
    </xsl:template>
</xsl:stylesheet>
