<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2024 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:fo="http://www.w3.org/1999/XSL/Format"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:docbook="http://docbook.org/ns/docbook"
                xmlns:cms="http://ametys.org/cms/3.0"
                exclude-result-prefixes="i18n docbook cms">
    
    <xsl:import href="view://stylesheets/io/docbook2fo.xsl" />
    <xsl:import href="odf-view:odf-pilotage://stylesheets/pilotage/utils/common/mcc2pdf.xsl"/>
    <xsl:import href="odf-view:odf-pilotage://stylesheets/pilotage/thematics/functions.xsl" />
    <xsl:import href="odf-view:odf-pilotage://stylesheets/pilotage/thematics/export/common.xsl"/>
    
    <xsl:param name="showArchived" select="true()"/>
    
    <xsl:template name="menu-items">
        <fo:bookmark-tree>
            <xsl:call-template name="contents-menu-items">
                <xsl:with-param name="contents" select="contents/content"/>
            </xsl:call-template>
        </fo:bookmark-tree>
    </xsl:template>
    
    <xsl:template name="contents-menu-items">
        <xsl:param name="contents"/>
        <xsl:param name="prefix" select="''"/>
        
        <xsl:apply-templates select="$contents" mode="menu-item">
            <xsl:sort select="cms:getOrder(order)" data-type="number"/>
            <xsl:sort select="title" order="ascending"/>
            <xsl:with-param name="prefix" select="$prefix"/>
        </xsl:apply-templates>
    </xsl:template>
    
    <xsl:template match="*" mode="menu-item">
        <xsl:param name="prefix" select="''"/>
        
        <fo:bookmark internal-destination="{$prefix}rg-{code}">
            <fo:bookmark-title><xsl:value-of select="title"/> (<xsl:value-of select="code"/>)</fo:bookmark-title>
        </fo:bookmark>
    </xsl:template>
    
    <xsl:template name="body">
        <xsl:call-template name="flow-header"/>
        <fo:block font-size="4mm">&#160;</fo:block>
        <xsl:call-template name="flow-content"/>
    </xsl:template>
    
    <xsl:template name="flow-content">
        <xsl:call-template name="contents">
            <xsl:with-param name="contents" select="contents/content"/>
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template name="contents">
        <xsl:param name="contents"/>
        <xsl:param name="prefix" select="''"/>
        
        <xsl:apply-templates select="$contents">
            <xsl:sort select="cms:getOrder(order)" data-type="number"/>
            <xsl:sort select="title" order="ascending"/>
            <xsl:with-param name="prefix" select="$prefix"/>
        </xsl:apply-templates>
    </xsl:template>
    
    <xsl:template match="content">
        <xsl:param name="prefix" select="''"/>
        
        <xsl:if test="position() > 1">
            <fo:block keep-with-next.within-page="1" margin-bottom="0" margin-right="5mm" margin-left="5mm" margin-top="5mm" border-before-style="solid" border-before-width="thin" border-before-color="grey"/>
        </xsl:if>
        <fo:table table-layout="fixed" id="{$prefix}rg-{code}" margin-top="5mm">
            <fo:table-column/>
            <fo:table-column column-width="40mm"/>
            <fo:table-body>
                <xsl:call-template name="thematic-title"/>
                <xsl:call-template name="thematic-scope"/>
                <xsl:apply-templates select="rules"/>
            </fo:table-body>
        </fo:table>
    </xsl:template>
    
    <xsl:template name="thematic-title">
        <fo:table-row color="{$mainColor}" keep-together.within-page="1" keep-with-next.within-page="1" margin-right="5mm" margin-left="5mm">
            <fo:table-cell>
                <fo:block font-weight="bold">
                    <xsl:value-of select="title"/>
                </fo:block>
            </fo:table-cell>
            <fo:table-cell text-align="right" font-size="80%">
                <fo:block>
                    <xsl:value-of select="code"/>
                    <xsl:if test="archived = 'true'">
                        <xsl:text> </xsl:text>[<i18n:text i18n:key="PLUGINS_ODF_PILOTAGE_EXPORT_ARCHIVED" i18n:catalogue="plugin.odf-pilotage"/>]
                    </xsl:if>
                </fo:block>
            </fo:table-cell>
        </fo:table-row>
    </xsl:template>
    
    <xsl:template name="thematic-scope"/>
    
    <xsl:template match="rules">
        <xsl:for-each select="entry[$showArchived or not(archived = 'true')]">
            <fo:table-row keep-together.within-page="1" margin-right="5mm" margin-left="5mm">
                <xsl:if test="position() != last()">
                    <xsl:attribute name="border-after-color">lightgrey</xsl:attribute>
                    <xsl:attribute name="border-after-style">solid</xsl:attribute>
                    <xsl:attribute name="border-after-width">thin</xsl:attribute>
                </xsl:if>
                <fo:table-cell padding-right="2mm" padding-top="2mm" padding-bottom="2mm" text-align="justify">
                    <fo:block margin="0" padding="0">
                        <xsl:apply-templates select="text/docbook:article"/>
                    </fo:block>
                </fo:table-cell>
                <fo:table-cell color="grey" padding-top="2mm" padding-bottom="2mm" text-align="right" font-size="80%">
                    <fo:block>
                        <xsl:value-of select="code"/>
                        <xsl:if test="status/@value != 'NON_MODIFIED'">
                            <xsl:text> </xsl:text>[<i18n:text i18n:key="PLUGINS_ODF_PILOTAGE_TS_RULE_STATUS_ENUM_{status/@value}" i18n:catalogue="plugin.odf-pilotage"/>]
                        </xsl:if>
                    </fo:block>
                    <xsl:if test="isDerogable = 'true'">
                        <fo:block><i18n:text i18n:key="PLUGINS_ODF_PILOTAGE_EXPORT_DEROGATION" i18n:catalogue="plugin.odf-pilotage"/></fo:block>
                    </xsl:if>
                </fo:table-cell>
            </fo:table-row>
        </xsl:for-each>
    </xsl:template>
    
    <xsl:template name="list-item">
        <xsl:param name="label"/>
        <xsl:param name="values"/>
        
        <xsl:if test="$values">
            <fo:list-item>
                <fo:list-item-label><fo:block/></fo:list-item-label>
                <fo:list-item-body start-indent="body-start()-5mm">
                    <fo:block>
                        <fo:inline font-weight="bold"><xsl:copy-of select="$label"/><i18n:text i18n:key="PLUGINS_ODF_PILOTAGE_EXPORT_SEPARATOR" i18n:catalogue="plugin.odf-pilotage"/></fo:inline>
                        <xsl:for-each select="$values">
                            <xsl:apply-templates select="." mode="value"/>
                            <xsl:if test="position() != last()">, </xsl:if>
                        </xsl:for-each>
                    </fo:block>
                </fo:list-item-body>
            </fo:list-item>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="*[ancestor::*[@type = 'DATE' or @type = 'DATETIME']]" mode="value">
        <i18n:date src-pattern="yyyy-MM-dd" pattern="short" value="{text()}"/>
    </xsl:template>
    
    <xsl:template match="*" mode="value">
        <xsl:value-of select="@title|text()"/>
    </xsl:template>
    
    <!-- // Header -->
    <xsl:template name="flow-header">
        <xsl:call-template name="title"/>
        <xsl:call-template name="filters"/>
    </xsl:template>
    
    <xsl:template name="property-title">
        <i18n:text key="PLUGINS_ODF_PILOTAGE_EXPORT_TITLE" catalogue="plugin.odf-pilotage"/>
    </xsl:template>
    
    <xsl:template name="title">
        <fo:block text-align="center" font-size="140%" font-weight="bold" color="{$mainColor}"><i18n:text key="PLUGINS_ODF_PILOTAGE_EXPORT_TITLE" catalogue="plugin.odf-pilotage"/></fo:block>
        <fo:block text-align="center" font-size="130%" font-weight="bold" color="{$mainColor}"><i18n:text key="PLUGINS_ODF_PILOTAGE_EXPORT_SUBTITLE" catalogue="plugin.odf-pilotage"/></fo:block>
    </xsl:template>
    
    <xsl:template name="filters"/>
    <!-- // END Header -->
</xsl:stylesheet>
