/*
 *  Copyright 2024 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.odfpilotage.helper;

/**
 * Common exception for MCC workflow.
 */
public class MCCWorkflowException extends RuntimeException
{
    /**
     * Information about the exception
     */
    public enum ExceptionType
    {
        /** Exception when the container is not of type year */
        NOT_TYPE_YEAR,
        /** Exception when the workflow does not allow to perform the action */
        UNAVAILABLE_ACTION,
        /** Nothing defined */
        UNKNOWN;
    }
    
    private ExceptionType _type = ExceptionType.UNKNOWN;
    /**
     * Constructs a new exception with the specified detail message.
     * @param message the detail message.
     */
    public MCCWorkflowException(String message)
    {
        this(message, ExceptionType.UNKNOWN);
    }
    /**
     * Constructs a new exception with the specified detail message.
     * @param message the detail message.
     * @param type reason of the exception
     */
    public MCCWorkflowException(String message, ExceptionType type)
    {
        super(message);
        this._type = type;
    }

    /**
     * Constructs a new exception with the specified detail message and cause.
     * @param message the detail message.
     * @param cause the cause.
     */
    public MCCWorkflowException(String message, Throwable cause)
    {
        this(message, ExceptionType.UNKNOWN, cause);
    }
    
    /**
     * Constructs a new exception with the specified detail message and cause.
     * @param message the detail message.
     * @param type reason of the exception
     * @param cause the cause.
     */
    public MCCWorkflowException(String message, ExceptionType type, Throwable cause)
    {
        super(message, cause);
        this._type = type;
    }

    /**
     * Constructs a new exception with the specified cause.
     * @param cause the specified cause.
     */
    public MCCWorkflowException(Throwable cause)
    {
        this(ExceptionType.UNKNOWN, cause);
    }

    /**
     * Constructs a new exception with the specified cause.
     * @param type reason of the exception
     * @param cause the specified cause.
     */
    public MCCWorkflowException(ExceptionType type, Throwable cause)
    {
        super(cause);
        this._type = type;
    }
    
    /**
     * Get the type of exception
     * @return {@link ExceptionType}
     */
    public ExceptionType getType()
    {
        return _type;
    }
}
