/*
 *  Copyright 2018 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.odfpilotage.workflow;

import java.util.Map;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

import org.ametys.cms.repository.Content;
import org.ametys.odf.catalog.CopyCatalogUpdater;
import org.ametys.odf.program.Program;
import org.ametys.plugins.odfpilotage.helper.PilotageStatusHelper;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;

/**
 * Implementation of {@link CopyCatalogUpdater} to remove the pilotage workflow if available.
 */
public class WorkflowPilotageUpdater extends AbstractLogEnabled implements CopyCatalogUpdater, Serviceable
{
    private PilotageStatusHelper _pilotageStatusHelper;
    
    @Override
    public void service(ServiceManager manager) throws ServiceException
    {
        _pilotageStatusHelper = (PilotageStatusHelper) manager.lookup(PilotageStatusHelper.ROLE);
    }
    
    @Override
    public void updateContents(String initialCatalogName, String newCatalogName, Map<Content, Content> copiedContents, Content targetParentContent)
    {
        for (Content copiedContent : copiedContents.values())
        {
            if (copiedContent instanceof Program createdProgram)
            {
                _pilotageStatusHelper.removePilotageWorkflow(createdProgram);
            }
        }
    }
}
