/*
 *  Copyright 2021 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.odfpilotage.cost.eqtd.impl;

import java.util.Optional;

import org.ametys.plugins.odfpilotage.cost.entity.Groups;
import org.ametys.plugins.odfpilotage.cost.entity.ProgramItemData;
import org.ametys.plugins.odfpilotage.cost.eqtd.AbstractEqTDComputationMode;

/**
 * TD equivalent computation mode based on groups.
 */
public class GroupsMode extends AbstractEqTDComputationMode
{
    @Override
    public Double computeEqTD(ProgramItemData programItemData, Double eqTDCoef)
    {
        if (eqTDCoef != null)
        {
            Groups groups = programItemData.getGroups();
            Long nbGroups = Optional.ofNullable(groups.getOverriddenGroups())
                    .or(() -> Optional.ofNullable(groups.getGroupsToOpen()))
                    .orElseGet(() -> groups.getComputedGroups());
            Double nbHours = programItemData.getVolumesOfHours().getTotal();
            return eqTDCoef * nbGroups * nbHours; 
        }
        return 0D;
    }
}
