/*
 *  Copyright 2024 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.odfpilotage.report.pipeline;

import java.io.IOException;
import java.util.Map;

import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.generation.AbstractGenerator;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.SAXException;

import org.ametys.plugins.odfpilotage.report.PilotageReport;

/**
 * Generator to get data to build a pilotage report.
 */
public class PilotageReportGenerator extends AbstractGenerator
{
    public void generate() throws IOException, SAXException, ProcessingException
    {
        Request request = ObjectModelHelper.getRequest(objectModel);
        PilotageReport pilotageReport = (PilotageReport) request.getAttribute("report");
        @SuppressWarnings("unchecked")
        Map<String, String> reportParameters = (Map<String, String>) request.getAttribute("reportParameters");
        
        // Launch on a program item
        String programItemId = request.getParameter("programItem");
        if (StringUtils.isNotEmpty(programItemId))
        {
            pilotageReport.saxProgramItem(contentHandler, programItemId, reportParameters);
        }
        // Launch on an orgunit
        else
        {
            String orgUnitId = request.getParameter("orgUnit");
            pilotageReport.saxOrgUnit(contentHandler, orgUnitId, reportParameters);
        }
    }
}
