/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfpilotage.helper;

import java.time.LocalDate;
import java.util.Comparator;
import java.util.Set;
import org.ametys.cms.data.holder.group.IndexableComposite;
import org.ametys.cms.data.holder.group.ModifiableIndexableComposite;
import org.ametys.cms.repository.Content;
import org.ametys.cms.repository.ModifiableDefaultContent;
import org.ametys.core.cache.Cache;
import org.ametys.core.right.RightManager;
import org.ametys.core.user.UserIdentity;
import org.ametys.odf.ProgramItem;
import org.ametys.odf.coursepart.CoursePart;
import org.ametys.odf.program.Program;
import org.ametys.plugins.odfpilotage.helper.AbstractWorkflowHelper;
import org.ametys.plugins.repository.data.holder.ModelAwareDataHolder;
import org.ametys.plugins.repository.data.holder.ModifiableModelAwareDataHolder;
import org.ametys.runtime.i18n.I18nizableText;
import org.apache.avalon.framework.activity.Initializable;

public class PilotageStatusHelper
extends AbstractWorkflowHelper
implements Initializable {
    public static final String ROLE = PilotageStatusHelper.class.getName();
    public static final String MENTION_VALIDATION_SUPER_RIGHT_ID = "ODF_Pilotage_Mention_Validated_Super_Rights";
    public static final String ORGUNIT_VALIDATION_SUPER_RIGHT_ID = "ODF_Pilotage_OrgUnit_Validated_Super_Rights";
    public static final String CFVU_VALIDATION_SUPER_RIGHT_ID = "ODF_Pilotage_CFVU_Validated_Super_Rights";
    private static final String __PARENT_PROGRAMS_WITH_HIGHER_STATUS_CACHE_ID = PilotageStatusHelper.class.getName() + "$parentPrograms";
    private static final String __PILOTAGE_COMPOSITE = "pilotage";
    private static final String __PILOTAGE_STATUS = "pilotage_status";
    private static final String __MENTION_VALIDATION_PREFIX = "mention_validation";
    private static final String __ORGUNIT_VALIDATION_PREFIX = "orgunit_validation";
    private static final String __CFVU_VALIDATION_PREFIX = "cfvu_validation";

    public void initialize() throws Exception {
        this._cacheManager.createRequestCache(__PARENT_PROGRAMS_WITH_HIGHER_STATUS_CACHE_ID, new I18nizableText("plugin.odf-pilotage", "PLUGINS_ODF_PILOTAGE_CACHE_PROGRAM_WITH_HIGHER_PILOTAGE_STATUS_LABEL"), new I18nizableText("plugin.odf-pilotage", "PLUGINS_ODF_PILOTAGE_CACHE_PROGRAM_WITH_HIGHER_PILOTAGE_STATUS_DESCRIPTION"), true);
    }

    private Cache<String, String> _getProgramParentsCache() {
        return this._cacheManager.get(__PARENT_PROGRAMS_WITH_HIGHER_STATUS_CACHE_ID);
    }

    public boolean hasEditSuperRight(Program program) {
        PilotageStatus pilotageStatus = this.getPilotageStatus((Content)program);
        UserIdentity user = this._currentUserProvider.getUser();
        switch (pilotageStatus.ordinal()) {
            case 0: {
                return true;
            }
            case 1: {
                return this._rightManager.hasRight(user, MENTION_VALIDATION_SUPER_RIGHT_ID, (Object)program) == RightManager.RightResult.RIGHT_ALLOW;
            }
            case 2: {
                return this._rightManager.hasRight(user, ORGUNIT_VALIDATION_SUPER_RIGHT_ID, (Object)program) == RightManager.RightResult.RIGHT_ALLOW;
            }
            case 3: {
                return this._rightManager.hasRight(user, CFVU_VALIDATION_SUPER_RIGHT_ID, (Object)program) == RightManager.RightResult.RIGHT_ALLOW;
            }
        }
        return false;
    }

    public Program getParentProgramWithHigherPilotageStatus(CoursePart coursePart) {
        Cache<String, String> cache = this._getProgramParentsCache();
        if (cache.hasKey((Object)coursePart.getId())) {
            String parentId = (String)cache.get((Object)coursePart.getId());
            return parentId != null ? (Program)this._resolver.resolveById(parentId) : null;
        }
        Program parentProgram = this._computeParentProgramWithHigherPilotageStatus(coursePart);
        cache.put((Object)coursePart.getId(), (Object)(parentProgram != null ? parentProgram.getId() : null));
        return parentProgram;
    }

    private Program _computeParentProgramWithHigherPilotageStatus(CoursePart coursePart) {
        return this._getParentPrograms(coursePart).stream().filter(p -> !PilotageStatus.NONE.equals((Object)this.getPilotageStatus((Content)p))).sorted(new PilotageStatusComparator().reversed()).findFirst().orElse(null);
    }

    public Program getParentProgramWithHigherPilotageStatus(ProgramItem programItem) {
        Cache<String, String> cache = this._getProgramParentsCache();
        if (cache.hasKey((Object)programItem.getId())) {
            String parentId = (String)cache.get((Object)programItem.getId());
            return parentId != null ? (Program)this._resolver.resolveById(parentId) : null;
        }
        Program parentProgram = this._computeParentProgramWithHigherPilotageStatus(programItem);
        cache.put((Object)programItem.getId(), (Object)(parentProgram != null ? parentProgram.getId() : null));
        return parentProgram;
    }

    private Program _computeParentProgramWithHigherPilotageStatus(ProgramItem programItem) {
        Set<Program> parentPrograms = this._getParentPrograms(programItem);
        return parentPrograms.stream().filter(p -> !PilotageStatus.NONE.equals((Object)this.getPilotageStatus((Content)p))).sorted(new PilotageStatusComparator().reversed()).findFirst().orElse(null);
    }

    public PilotageStatus getPilotageStatus(Content content) {
        String pilotageStatusDataPath = "pilotage/pilotage_status";
        String status = (String)content.getValue(pilotageStatusDataPath, false, (Object)PilotageStatus.NONE.name());
        return PilotageStatus.valueOf(status);
    }

    public void setValidationAttribute(ModifiableDefaultContent content, LocalDate validationDate, UserIdentity user, String comment, PilotageStatus status) {
        switch (status.ordinal()) {
            case 0: {
                break;
            }
            case 1: {
                this.setMentionValidationAttribute(content, validationDate, user, comment);
                break;
            }
            case 2: {
                this.setOrgUnitValidationAttribute(content, validationDate, user, comment);
                break;
            }
            case 3: {
                this.setCFVUValidationAttribute(content, validationDate, user, comment);
                break;
            }
            default: {
                this.getLogger().error("{} is an unknown pilotage status", (Object)status);
            }
        }
        this.saveContentAndNotify(content);
    }

    public void removePilotageStatus(ModifiableDefaultContent content, PilotageStatus status) {
        switch (status.ordinal()) {
            case 0: {
                break;
            }
            case 1: {
                this.removeMentionValidationAttribute(content);
                break;
            }
            case 2: {
                this.removeOrgUnitValidationAttribute(content);
                break;
            }
            case 3: {
                this.removeCFVUValidationAttribute(content);
                break;
            }
            default: {
                this.getLogger().error("{} is an unknown pilotage status", (Object)status);
            }
        }
        this.saveContentAndNotify(content);
    }

    public void setMentionValidationAttribute(ModifiableDefaultContent content, LocalDate validationDate, UserIdentity user, String comment) {
        ModifiableIndexableComposite composite = content.getComposite(__PILOTAGE_COMPOSITE, true);
        composite.setValue(__PILOTAGE_STATUS, (Object)PilotageStatus.MENTION_VALIDATED.name());
        this.setWorkflowStep(content, (ModifiableModelAwareDataHolder)composite, __MENTION_VALIDATION_PREFIX, validationDate, user, comment);
    }

    public void removeMentionValidationAttribute(ModifiableDefaultContent content) {
        this.removePilotageWorkflow(content);
    }

    public void setOrgUnitValidationAttribute(ModifiableDefaultContent content, LocalDate validationDate, UserIdentity user, String comment) {
        ModifiableIndexableComposite composite = content.getComposite(__PILOTAGE_COMPOSITE, true);
        composite.setValue(__PILOTAGE_STATUS, (Object)PilotageStatus.ORGUNIT_VALIDATED.name());
        this.setWorkflowStep(content, (ModifiableModelAwareDataHolder)composite, __ORGUNIT_VALIDATION_PREFIX, validationDate, user, comment);
    }

    public void removeOrgUnitValidationAttribute(ModifiableDefaultContent content) {
        ModifiableIndexableComposite compositeMetadata = content.getComposite(__PILOTAGE_COMPOSITE, true);
        compositeMetadata.setValue(__PILOTAGE_STATUS, (Object)PilotageStatus.MENTION_VALIDATED.name());
        this.removeWorkflowStep(content, (ModifiableModelAwareDataHolder)compositeMetadata, __ORGUNIT_VALIDATION_PREFIX);
    }

    public void setCFVUValidationAttribute(ModifiableDefaultContent content, LocalDate validationDate, UserIdentity user, String comment) {
        ModifiableIndexableComposite composite = content.getComposite(__PILOTAGE_COMPOSITE, true);
        composite.setValue(__PILOTAGE_STATUS, (Object)PilotageStatus.CFVU_VALIDATED.name());
        this.setWorkflowStep(content, (ModifiableModelAwareDataHolder)composite, __CFVU_VALIDATION_PREFIX, validationDate, user, comment);
    }

    public void removeCFVUValidationAttribute(ModifiableDefaultContent content) {
        ModifiableIndexableComposite composite = content.getComposite(__PILOTAGE_COMPOSITE, true);
        composite.setValue(__PILOTAGE_STATUS, (Object)PilotageStatus.ORGUNIT_VALIDATED.name());
        this.removeWorkflowStep(content, (ModifiableModelAwareDataHolder)composite, __CFVU_VALIDATION_PREFIX);
    }

    public LocalDate getMentionValidationDate(Content content) {
        if (content.hasValue(__PILOTAGE_COMPOSITE)) {
            IndexableComposite pilotageWorkflow = content.getComposite(__PILOTAGE_COMPOSITE);
            return this.getWorkflowStepDate((ModelAwareDataHolder)pilotageWorkflow, __MENTION_VALIDATION_PREFIX);
        }
        return null;
    }

    public LocalDate getOrgUnitValidationDate(Content content) {
        if (content.hasValue(__PILOTAGE_COMPOSITE)) {
            IndexableComposite pilotageWorkflow = content.getComposite(__PILOTAGE_COMPOSITE);
            return this.getWorkflowStepDate((ModelAwareDataHolder)pilotageWorkflow, __ORGUNIT_VALIDATION_PREFIX);
        }
        return null;
    }

    public LocalDate getCFVUValidationDate(Content content) {
        if (content.hasValue(__PILOTAGE_COMPOSITE)) {
            IndexableComposite pilotageWorkflow = content.getComposite(__PILOTAGE_COMPOSITE);
            return this.getWorkflowStepDate((ModelAwareDataHolder)pilotageWorkflow, __CFVU_VALIDATION_PREFIX);
        }
        return null;
    }

    public AbstractWorkflowHelper.ODFWorkflowStep getMentionValidationStep(Content content) {
        if (content.hasValue(__PILOTAGE_COMPOSITE)) {
            IndexableComposite pilotageWorkflow = content.getComposite(__PILOTAGE_COMPOSITE);
            return this.getWorkflowStep((ModelAwareDataHolder)pilotageWorkflow, __MENTION_VALIDATION_PREFIX, PilotageStatus.MENTION_VALIDATED.name());
        }
        return null;
    }

    public AbstractWorkflowHelper.ODFWorkflowStep getOrgUnitValidationStep(Content content) {
        if (content.hasValue(__PILOTAGE_COMPOSITE)) {
            IndexableComposite pilotageWorkflow = content.getComposite(__PILOTAGE_COMPOSITE);
            return this.getWorkflowStep((ModelAwareDataHolder)pilotageWorkflow, __ORGUNIT_VALIDATION_PREFIX, PilotageStatus.ORGUNIT_VALIDATED.name());
        }
        return null;
    }

    public AbstractWorkflowHelper.ODFWorkflowStep getCFVUValidationStep(Content content) {
        if (content.hasValue(__PILOTAGE_COMPOSITE)) {
            IndexableComposite pilotageWorkflow = content.getComposite(__PILOTAGE_COMPOSITE);
            return this.getWorkflowStep((ModelAwareDataHolder)pilotageWorkflow, __CFVU_VALIDATION_PREFIX, PilotageStatus.CFVU_VALIDATED.name());
        }
        return null;
    }

    public void removePilotageWorkflow(ModifiableDefaultContent content) {
        content.removeValue(__PILOTAGE_COMPOSITE);
    }

    public static enum PilotageStatus {
        NONE,
        MENTION_VALIDATED,
        ORGUNIT_VALIDATED,
        CFVU_VALIDATED;

    }

    private final class PilotageStatusComparator
    implements Comparator<Program> {
        private PilotageStatusComparator() {
        }

        @Override
        public int compare(Program p1, Program p2) {
            PilotageStatus pilotageStatus1 = PilotageStatusHelper.this.getPilotageStatus((Content)p1);
            PilotageStatus pilotageStatus2 = PilotageStatusHelper.this.getPilotageStatus((Content)p2);
            switch (pilotageStatus1.ordinal()) {
                case 0: {
                    return PilotageStatus.NONE.equals((Object)pilotageStatus2) ? 0 : -1;
                }
                case 3: {
                    return PilotageStatus.CFVU_VALIDATED.equals((Object)pilotageStatus2) ? 0 : 1;
                }
                case 2: {
                    if (PilotageStatus.NONE.equals((Object)pilotageStatus2) || PilotageStatus.MENTION_VALIDATED.equals((Object)pilotageStatus2)) {
                        return 1;
                    }
                    return PilotageStatus.ORGUNIT_VALIDATED.equals((Object)pilotageStatus2) ? 0 : -1;
                }
                case 1: {
                    if (PilotageStatus.NONE.equals((Object)pilotageStatus2)) {
                        return 1;
                    }
                    return PilotageStatus.MENTION_VALIDATED.equals((Object)pilotageStatus2) ? 0 : -1;
                }
            }
            return -2;
        }
    }
}

