/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfpilotage.helper;

import java.io.File;
import java.math.RoundingMode;
import java.text.NumberFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.ametys.cms.data.ContentDataHelper;
import org.ametys.cms.data.ContentValue;
import org.ametys.cms.repository.Content;
import org.ametys.cms.repository.ModifiableContent;
import org.ametys.cms.repository.ModifiableDefaultContent;
import org.ametys.core.ui.Callable;
import org.ametys.odf.ODFHelper;
import org.ametys.odf.ProgramItem;
import org.ametys.odf.course.Course;
import org.ametys.odf.enumeration.OdfReferenceTableEntry;
import org.ametys.odf.enumeration.OdfReferenceTableHelper;
import org.ametys.odf.orgunit.OrgUnit;
import org.ametys.odf.orgunit.RootOrgUnitProvider;
import org.ametys.odf.program.Container;
import org.ametys.odf.program.Program;
import org.ametys.plugins.odfpilotage.helper.MCCWorkflowHelper;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.UnknownAmetysObjectException;
import org.ametys.plugins.repository.data.holder.ModelAwareDataHolder;
import org.ametys.plugins.repository.data.holder.group.ModelAwareRepeaterEntry;
import org.ametys.runtime.config.Config;
import org.ametys.runtime.util.AmetysHomeHelper;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class ReportHelper
implements Component,
Serviceable,
Initializable {
    public static final String ROLE = ReportHelper.class.getName();
    public static final NumberFormat FORMAT_2_DIGITS = NumberFormat.getInstance(Locale.FRANCE);
    public static final Comparator<Content> CONTENT_TITLE_COMPARATOR;
    private static final String __READABLE_DF = "dd/MM/yyyy";
    protected AmetysObjectResolver _resolver;
    protected RootOrgUnitProvider _rootOrgUnitProvider;
    protected ODFHelper _odfHelper;
    protected OdfReferenceTableHelper _refTableHelper;
    protected MCCWorkflowHelper _mccWorkflowHelper;
    private File _pilotageFolder;

    public void initialize() throws Exception {
        this._pilotageFolder = new File(AmetysHomeHelper.getAmetysHomeData(), "odf/gestion");
        FileUtils.forceMkdir((File)this._pilotageFolder);
    }

    public void service(ServiceManager manager) throws ServiceException {
        this._rootOrgUnitProvider = (RootOrgUnitProvider)manager.lookup(RootOrgUnitProvider.ROLE);
        this._resolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
        this._odfHelper = (ODFHelper)manager.lookup(ODFHelper.ROLE);
        this._refTableHelper = (OdfReferenceTableHelper)manager.lookup(OdfReferenceTableHelper.ROLE);
        this._mccWorkflowHelper = (MCCWorkflowHelper)((Object)manager.lookup(MCCWorkflowHelper.ROLE));
    }

    public String getReadableCurrentDate() {
        return LocalDate.now().format(DateTimeFormatter.ofPattern(__READABLE_DF));
    }

    public List<OrgUnit> getOrgUnits(String orgUnitId) {
        return Optional.ofNullable(orgUnitId).filter(StringUtils::isNotEmpty).map(arg_0 -> ((AmetysObjectResolver)this._resolver).resolveById(arg_0)).map(List::of).orElseGet(this::_getRootOrgUnits);
    }

    private List<OrgUnit> _getRootOrgUnits() {
        return Stream.of((ContentValue[])this._rootOrgUnitProvider.getRoot().getValue("childOrgUnits")).map(ContentValue::getContentIfExists).flatMap(Optional::stream).map(OrgUnit.class::cast).toList();
    }

    public String getAcronymOrUaiCode(OrgUnit orgUnit) {
        return Optional.of(orgUnit).map(OrgUnit::getAcronym).filter(StringUtils::isNotBlank).orElseGet(() -> ((OrgUnit)orgUnit).getUAICode());
    }

    public String formatNumberToSax(Long number) {
        return number > 0L ? String.valueOf(number) : "";
    }

    public Map<ProgramItem, Object> getCoursesFromContent(ProgramItem programItem) {
        LinkedHashMap<ProgramItem, Object> contentTree = new LinkedHashMap<ProgramItem, Object>();
        for (ProgramItem childProgramItem : this._odfHelper.getChildProgramItems(programItem)) {
            if (childProgramItem instanceof Course) {
                contentTree.put(childProgramItem, this.getCoursesFromContent(childProgramItem));
                continue;
            }
            Map<ProgramItem, Object> childTree = this.getCoursesFromContent(childProgramItem);
            if (!MapUtils.isNotEmpty(childTree)) continue;
            contentTree.put(childProgramItem, childTree);
        }
        return contentTree;
    }

    public void saxContentAttribute(ContentHandler handler, ModifiableDefaultContent content, String attributeName, String tagName) throws SAXException {
        Locale lang = LocaleUtils.toLocale((String)content.getLanguage());
        if (!"content".equals(content.getType(attributeName).getId())) {
            throw new IllegalArgumentException("The attribute '" + attributeName + "' should be of type 'content'.");
        }
        Object value = content.getValue(attributeName);
        if (value != null) {
            Stream<ContentValue> values = content.isMultiple(attributeName) ? Stream.of((ContentValue[])value) : Stream.of((ContentValue)value);
            String tagValue = values.map(ContentValue::getContentIfExists).flatMap(Optional::stream).map(c -> c.getTitle(lang)).filter(StringUtils::isNotBlank).collect(Collectors.joining(", "));
            XMLUtils.createElement((ContentHandler)handler, (String)tagName, (String)tagValue);
        }
    }

    public void saxNaturesEnseignement(ContentHandler handler, Logger logger) throws SAXException {
        String lang = (String)Config.getInstance().getValue("odf.programs.lang");
        Locale langAsLocale = LocaleUtils.toLocale((String)lang);
        Map<String, List<OdfReferenceTableEntry>> itemsByCategory = this._refTableHelper.getItems("odf-enumeration.EnseignementNature").stream().collect(Collectors.groupingBy(item -> ContentDataHelper.getContentIdFromContentData((ModelAwareDataHolder)item.getContent(), (String)"category")));
        AttributesImpl rootAttrs = new AttributesImpl();
        rootAttrs.addCDATAAttribute("id", "odf-enumeration.EnseignementNature");
        XMLUtils.startElement((ContentHandler)handler, (String)"items", (Attributes)rootAttrs);
        for (String categoryId : itemsByCategory.keySet()) {
            AttributesImpl attr;
            block4: {
                attr = new AttributesImpl();
                try {
                    Optional<Content> category = Optional.ofNullable(categoryId).filter(StringUtils::isNotBlank).map(arg_0 -> ((AmetysObjectResolver)this._resolver).resolveById(arg_0));
                    attr.addCDATAAttribute("title", category.map(c -> c.getTitle(langAsLocale)).orElse(""));
                    attr.addCDATAAttribute("code", category.map(c -> (String)c.getValue("code")).orElse(""));
                    attr.addCDATAAttribute("order", String.valueOf(category.map(c -> (Long)c.getValue("order")).orElse(Long.MAX_VALUE)));
                }
                catch (UnknownAmetysObjectException e) {
                    if (!StringUtils.isNotEmpty((CharSequence)categoryId)) break block4;
                    logger.warn("There is no content matching with the ID {}.", (Object)categoryId);
                }
            }
            XMLUtils.startElement((ContentHandler)handler, (String)"category", (Attributes)attr);
            for (OdfReferenceTableEntry item2 : itemsByCategory.get(categoryId)) {
                attr = new AttributesImpl();
                attr.addCDATAAttribute("id", item2.getId());
                attr.addCDATAAttribute("code", item2.getCode());
                attr.addCDATAAttribute("order", item2.getOrder().toString());
                attr.addCDATAAttribute("archived", item2.isArchived().toString());
                attr.addCDATAAttribute("shortLabel", (String)item2.getContent().getValue("shortLabel", false, (Object)""));
                XMLUtils.createElement((ContentHandler)handler, (String)"item", (Attributes)attr, (String)item2.getLabel(lang));
            }
            XMLUtils.endElement((ContentHandler)handler, (String)"category");
        }
        XMLUtils.endElement((ContentHandler)handler, (String)"items");
    }

    public File getPilotageFolder() {
        return this._pilotageFolder;
    }

    @Callable(rights={"ODF_Rights_Pilotage_Report_Delete"})
    public Map<String, List<String>> deleteReports(List<String> reports) {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        File pilotageFolder = this.getPilotageFolder();
        for (String report : reports) {
            File reportFile = new File(pilotageFolder, report);
            FileUtils.deleteQuietly((File)reportFile);
            result.computeIfAbsent(reportFile.exists() ? "undeletedReports" : "deletedReports", __ -> new ArrayList()).add(report);
        }
        return result;
    }

    public void saxMCCWorkflow(ContentHandler handler, Container container) throws SAXException {
        XMLUtils.startElement((ContentHandler)handler, (String)"mcc-workflow");
        for (MCCWorkflowHelper.MCCWorkflowStep step : this._mccWorkflowHelper.getCurrentSteps(container)) {
            XMLUtils.createElement((ContentHandler)handler, (String)"workflow-step", (String)step.name());
        }
        XMLUtils.endElement((ContentHandler)handler, (String)"mcc-workflow");
    }

    public void saxAcquiredMicroSkills(ContentHandler handler, ProgramItem programItem) throws SAXException {
        this._saxAcquiredMicroSkills(handler, programItem, this._odfHelper.getParentPrograms(programItem));
    }

    public void saxAcquiredMicroSkills(ContentHandler handler, ProgramItem programItem, Program parentProgram) throws SAXException {
        this._saxAcquiredMicroSkills(handler, programItem, Set.of(parentProgram));
    }

    private void _saxAcquiredMicroSkills(ContentHandler handler, ProgramItem programItem, Set<Program> acceptedParentPrograms) throws SAXException {
        Set<? extends Content> blockingMicroSkills = this._getBlockingMicroSkills(acceptedParentPrograms);
        Map<Content, List<? extends Content>> filteredMacroSkills = this._getFilteredSkills(programItem, acceptedParentPrograms);
        XMLUtils.startElement((ContentHandler)handler, (String)"skills");
        for (Content macroSkill : filteredMacroSkills.keySet()) {
            AttributesImpl attrs = new AttributesImpl();
            attrs.addCDATAAttribute("id", macroSkill.getId());
            XMLUtils.startElement((ContentHandler)handler, (String)"macro", (Attributes)attrs);
            XMLUtils.createElement((ContentHandler)handler, (String)"code", (String)((String)macroSkill.getValue("skillCode")));
            XMLUtils.createElement((ContentHandler)handler, (String)"title", (String)macroSkill.getTitle());
            for (Content content : filteredMacroSkills.get(macroSkill)) {
                attrs.clear();
                attrs.addCDATAAttribute("id", content.getId());
                attrs.addCDATAAttribute("isBlocking", Boolean.toString(blockingMicroSkills.contains(content)));
                XMLUtils.startElement((ContentHandler)handler, (String)"micro", (Attributes)attrs);
                XMLUtils.createElement((ContentHandler)handler, (String)"code", (String)((String)content.getValue("skillCode")));
                XMLUtils.createElement((ContentHandler)handler, (String)"title", (String)content.getTitle());
                XMLUtils.endElement((ContentHandler)handler, (String)"micro");
            }
            XMLUtils.endElement((ContentHandler)handler, (String)"macro");
        }
        XMLUtils.endElement((ContentHandler)handler, (String)"skills");
    }

    private Map<Content, List<? extends Content>> _getFilteredSkills(ProgramItem programItem, Set<Program> acceptedParentPrograms) {
        Set<Content> acceptedMicroSkills = this._getAcquiredMicroSkills(programItem, acceptedParentPrograms);
        LinkedHashMap<Content, List<? extends Content>> skills = new LinkedHashMap<Content, List<? extends Content>>();
        for (Program program : acceptedParentPrograms) {
            skills.putAll(this._getMicroSkills(program.getSkills(), acceptedMicroSkills));
        }
        for (Program program : acceptedParentPrograms) {
            skills.putAll(this._getMicroSkills(program.getTransversalSkills(), acceptedMicroSkills));
        }
        return skills;
    }

    private Set<Content> _getAcquiredMicroSkills(ProgramItem programItem, Set<Program> acceptedParentPrograms) {
        HashSet<Content> acquiredMicroSkills = new HashSet<Content>();
        if (programItem instanceof Course) {
            Course course = (Course)programItem;
            for (ModelAwareRepeaterEntry entry : course.getRepeater("acquiredMicroSkills", true).getEntries()) {
                if (!Optional.ofNullable((ContentValue)entry.getValue("program")).flatMap(ContentValue::getContentIfExists).map(acceptedParentPrograms::contains).orElse(false).booleanValue()) continue;
                acquiredMicroSkills.addAll(Arrays.stream((ContentValue[])entry.getValue("microSkills", false, (Object)new ContentValue[0])).distinct().map(ContentValue::getContentIfExists).filter(Optional::isPresent).map(Optional::get).toList());
            }
        }
        for (ProgramItem child : this._odfHelper.getChildProgramItems(programItem)) {
            acquiredMicroSkills.addAll(this._getAcquiredMicroSkills(child, acceptedParentPrograms));
        }
        return acquiredMicroSkills;
    }

    private Map<Content, List<? extends Content>> _getMicroSkills(List<Content> macroSkills, Set<Content> acceptedMicroSkills) {
        LinkedHashMap<Content, List<? extends Content>> skills = new LinkedHashMap<Content, List<? extends Content>>();
        for (Content macroSkill : macroSkills) {
            List<ModifiableContent> microSkills = ((Stream)Stream.of((ContentValue[])macroSkill.getValue("microSkills", false, (Object)new ContentValue[0])).sequential()).map(ContentValue::getContentIfExists).filter(Optional::isPresent).map(Optional::get).filter(acceptedMicroSkills::contains).toList();
            if (microSkills.isEmpty()) continue;
            skills.put(macroSkill, microSkills);
        }
        return skills;
    }

    private Set<? extends Content> _getBlockingMicroSkills(Set<Program> parentPrograms) {
        return parentPrograms.stream().map(p -> (ContentValue[])p.getValue("blockingMicroSkills", false, (Object)new ContentValue[0])).flatMap(Stream::of).distinct().map(ContentValue::getContentIfExists).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
    }

    static {
        FORMAT_2_DIGITS.setRoundingMode(RoundingMode.HALF_UP);
        FORMAT_2_DIGITS.setMaximumFractionDigits(2);
        FORMAT_2_DIGITS.setGroupingUsed(false);
        CONTENT_TITLE_COMPARATOR = Comparator.comparing(Content::getTitle).thenComparing(AmetysObject::hashCode);
    }
}

