/*
 *  Copyright 2023 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

logger.info("Move attributes poidsModu to mccCoefficient in courses");

let courses = Repository.query("//element(*, ametys:courseContent)");
let total = courses.getSize();
let updated = 0;
let handled = 0;
let hasChanges = false;

courses.forEach(
    course =>
    {
        hasChanges = false;
        
        Content.migrate( 
            course, 
            [_migrateMccCoefficient], 
            true, /* old version still comptatible */ 
            null, /* no tag */ 
            false, /* verbose */
            true /* synchronize live */
        );
        
        if (hasChanges)
        {
            updated++;
        }
        
        handled++;
        
        if (handled % 500 == 0)
        {
            logger.info(`${handled}/${total} handled courses`);
        }
    }
);

logger.info(`${updated} updated on a total of ${total} courses.`);

/* Functions */

function _migrateMccCoefficient(content)
{
    let node = content.getNode();
    _movePoidsModuProperty(node, "");
    _movePoidsModuProperty(node, "__alt");
    _movePoidsModuProperty(node, "__status");
}

function _movePoidsModuProperty(node, suffix)
{
    if (node.hasProperty("ametys:poidsModu" + suffix))
    {
        let oldProperty = node.getProperty("ametys:poidsModu" + suffix);
        node.setProperty(
            "ametys:mccCoefficient" + suffix,
            oldProperty.isMultiple()
                ? oldProperty.getValues()
                : oldProperty.getValue(),
            oldProperty.getType());
        oldProperty.remove();
        node.save();
        
        hasChanges = true;
    }
}
