/*
 *  Copyright 2024 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
 
 /**
 * This class controls the ribbon button to copy rule
 * @private
 */
Ext.define('Ametys.plugins.odfpilotage.controllers.CopyRuleController', {
    extend: 'Ametys.plugins.odfpilotage.controllers.RuleController',

    updateState: function()
    {
        this.disable();
        
        var targets = this.getMatchingTargets();
        if (targets.length > 0)
        {
            var contentTarget = targets[0]; // No multiselection
            var isGeneralThematic  = contentTarget.getSubtarget().getParameters().type == "general";
            var ruleParameters = contentTarget.getSubtarget().getSubtarget().getParameters();
            
            if (isGeneralThematic && (ruleParameters.derogated || ruleParameters.type == "additional"))
            {
                this.callParent(arguments);
            }
            else
            {
                this.disable();
                this.setAdditionalDescription("{{i18n plugin.odf-pilotage:PLUGINS_ODF_PILOTAGE_RULES_COPY_CONTROLLER_ERROR_NO_RULE_MSG}}");
            }
        }
    }
});