/*
 *  Copyright 2023 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * Widget to modify the mcc double repeater in a grid
 */
Ext.define('Ametys.plugins.odfpilotage.widget.DoubleMCCRepeater', {
    extend:'Ametys.cms.form.widget.Repeater',
   
   _getRepeaterInfo(record, grid, dataIndex, disabled)
   {
       let obj = [];
       
       for (let dataIndexConfigured of this.getInitialConfig()['dataIndexes'])
       {
           let repeaterCfg = this.callParent([record, grid, dataIndexConfigured, Ametys.plugins.cms.search.SearchGridHelper._evaluateDisableCondition(record, dataIndexConfigured)]);
           repeaterCfg.dataIndex = dataIndexConfigured;
           obj.push(repeaterCfg);
       }
       
       return obj;
   },
   
    _openDialog: function(repeaterInfos, parentGridId, recordId, contentId, dataIndex, contentGridId, callback)
    {
        let dataIndexes = repeaterInfos.map(a => a.dataIndex);
        dataIndexes.push({
            authorizeCopy: this.getInitialConfig()['authorizeCopy'],
            doNotCopy: this.getInitialConfig()['doNotCopy']
        });
        this._dialogId = Ametys.plugins.odfpilotage.widget.DoubleMCCSearchGridRepeater.showRepeaterDialog(repeaterInfos.map(a => a.dialogTitle), parentGridId, recordId, contentId, repeaterInfos.map(a => a.subcolumns), repeaterInfos.map(a => a.repeaterCfg), dataIndexes, repeaterInfos.map(a => a.attributePath), contentGridId, callback).getId();
    },
    
    _saveRepeaterValues: function(repeaterValuesAll, record, originalDataIndex)
    {
        var values = Ext.clone(Ametys.plugins.cms.search.SearchGridHelper.convertRepeater(repeaterValuesAll[originalDataIndex], record, originalDataIndex));
        if (JSON.stringify(Ametys.cms.form.widget.Repeater.superclass.getValue.call(this)) != JSON.stringify(values)) // Otherwise the record will be marked as dirty
        {
            Ametys.cms.form.widget.Repeater.superclass.setValue.call(this, values);
        }

        for (let dataIndex of Object.keys(repeaterValuesAll))
        {
            if (dataIndex != originalDataIndex) 
            {
                // report manually since we have no parent field
                var values = Ext.clone(Ametys.plugins.cms.search.SearchGridHelper.convertRepeater(repeaterValuesAll[dataIndex], record, dataIndex));
                if (JSON.stringify(values) != JSON.stringify(record.get(dataIndex))) // Otherwise the record will be marked as dirty
                {
                    record.set(dataIndex, values);
                }
            }
        }
        
    }
});
