<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2014 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:exsl="http://exslt.org/common"
                xmlns:su="org.ametys.core.util.StringUtils"
                exclude-result-prefixes="i18n exsl su">
    
    <xsl:import href="odf-view:odf-pilotage://stylesheets/pilotage/utils/utils.xsl"/>
    <xsl:import href="odf-view:odf-pilotage://stylesheets/pilotage/utils/xls.xsl"/>
    
    <xsl:variable name="naturesEnseignement">
        <xsl:for-each select="/report/items[@id = 'odf-enumeration.EnseignementNature']/category/item">
            <xsl:sort select="../@order" data-type="number"/>
            <xsl:sort select="../@code" data-type="text"/>
            <xsl:sort select="@order" data-type="number"/>
            <xsl:sort select="@code" data-type="text"/>
            <xsl:if test="@archived = 'false' or //volumeHoraire[@nature = current()/@id]">
                <item id="{@id}" code="{@code}"><xsl:value-of select="."/></item>
            </xsl:if>
        </xsl:for-each>
    </xsl:variable>
    
    <xsl:template name="table-head">
        <tr>
            <th><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_APOGEE_COLUMN_ORDRE"/></th>
            <th><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_APOGEE_COLUMN_COMPOSANTE"/></th>
            <th><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_APOGEE_COLUMN_FORMATION"/></th>
            <th><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_APOGEE_COLUMN_FORMATION_CODE"/></th>
            <th><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_APOGEE_COLUMN_PARCOURS"/></th>
            <th><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_APOGEE_COLUMN_PARCOURS_CODE"/></th>
            <th><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_APOGEE_COLUMN_ANNEE"/></th>
            <th><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_APOGEE_COLUMN_COD_ETP"/></th>
            <th><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_APOGEE_COLUMN_COD_VRS_ETP"/></th>
            <th><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_APOGEE_COLUMN_CODE_ELP_PERE"/></th>
            <th><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_APOGEE_COLUMN_LISTE"/></th>
            <th><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_APOGEE_COLUMN_TYPE"/></th>
            <th><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_APOGEE_COLUMN_MIN"/></th>
            <th><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_APOGEE_COLUMN_A_DES_FILS"/></th>
            <th><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_APOGEE_COLUMN_PARTAGE"/></th>
            <th><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_APOGEE_COLUMN_OCCURRENCE"/></th>
            <th><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_APOGEE_COLUMN_PORTE"/></th>
            <th><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_APOGEE_COLUMN_NIVEAU"/></th>
            <th><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_APOGEE_COLUMN_CREATION_DATE"/></th>
            <th><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_APOGEE_COLUMN_CODE_ELP_APOGEE"/></th>
            <th><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_APOGEE_COLUMN_NATURE"/></th>
            <th><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_APOGEE_COLUMN_LIBELLE_COURT"/></th>
            <th><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_APOGEE_COLUMN_LIBELLE"/></th>
            <th><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_APOGEE_COLUMN_CODE_ELP"/></th>
            <th><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_APOGEE_COLUMN_LIEU"/></th>
            <th><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_APOGEE_COLUMN_ECTS"/></th>
            <th><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_APOGEE_COLUMN_ELEMENT_STAGE"/></th>
            <th><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_APOGEE_COLUMN_CODE_SEMESTRE"/></th>
            <th><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_APOGEE_COLUMN_CODE_TYPE_PERIODE"/></th>
            <th><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_APOGEE_COLUMN_CODE_COMPOSANTE"/></th>
            <th><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_APOGEE_COLUMN_CODE_CIP"/></th>
            <th><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_APOGEE_COLUMN_CODE_ANU"/></th>
            <th><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_APOGEE_COLUMN_CALCUL_DES_CHARGES"/></th>
            <xsl:for-each select="exsl:node-set($naturesEnseignement)/*">
                <th><xsl:value-of select="@code"/></th>
            </xsl:for-each>
            <th><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_APOGEE_COLUMN_ETAPE_PORTEUSE"/></th>
            <th><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_APOGEE_COLUMN_VET_ETAPE_PORTEUSE"/></th>
            <th><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_APOGEE_COLUMN_DISCIPLINE"/></th>
        </tr>
    </xsl:template>
    
    <xsl:template name="table-body">
        <xsl:for-each select="course">
            <xsl:variable name="level">
                <xsl:value-of select="niveau"/>
            </xsl:variable>
            <tr>
                <td><xsl:value-of select="ordre"/></td>
                <td><xsl:value-of select="su:sanitizeXlsHtml(orgUnit)"/></td>
                <td><xsl:value-of select="su:sanitizeXlsHtml(formation)"/></td>
                <td><xsl:value-of select="su:sanitizeXlsHtml(formationCode)"/></td>
                <td><xsl:value-of select="su:sanitizeXlsHtml(parcours)"/></td>
                <td><xsl:value-of select="su:sanitizeXlsHtml(parcoursCode)"/></td>
                <td><xsl:value-of select="su:sanitizeXlsHtml(annee)"/></td>
                <td><xsl:value-of select="su:sanitizeXlsHtml(COD_ETP)"/></td>
                <td><xsl:value-of select="su:sanitizeXlsHtml(COD_VRS_ETP)"/></td>
                <td><xsl:value-of select="su:sanitizeXlsHtml(codeELPPere)"/></td>
                <td><xsl:value-of select="su:sanitizeXlsHtml(list)"/></td>
                <td><xsl:value-of select="su:sanitizeXlsHtml(typeList)"/></td>
                <td><xsl:value-of select="su:sanitizeXlsHtml(minmax)"/></td>
                <td><xsl:value-of select="aDesFils"/></td>
                <td><xsl:value-of select="partage"/></td>
                <td><xsl:value-of select="occurrences"/></td>
                <td><xsl:value-of select="su:sanitizeXlsHtml(porte)"/></td>
                <td><xsl:value-of select="su:sanitizeXlsHtml(niveau)"/></td>
                <td><i18n:date src-pattern="yyyy-MM-dd'T'HH:mm:ss" pattern="long"><xsl:value-of select="creationDate"/></i18n:date></td>
                <td><xsl:value-of select="su:sanitizeXlsHtml(codeApogee)"/></td>
                <td><xsl:value-of select="su:sanitizeXlsHtml(nature)"/></td>
                <td><xsl:value-of select="su:sanitizeXlsHtml(libelleCourt)"/></td>
                <td>
                    <xsl:choose>
                        <xsl:when test="$level = 'niv1'">
                            <B><xsl:value-of select="su:sanitizeXlsHtml(libelle)"/></B> 
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:value-of select="su:sanitizeXlsHtml(libelle)"/>
                        </xsl:otherwise>
                    </xsl:choose>
                </td>
                <td><xsl:value-of select="su:sanitizeXlsHtml(elpCode)"/></td>
                <td><xsl:value-of select="su:sanitizeXlsHtml(campus)"/></td>
                <td>
                    <xsl:call-template name="display-double">
                        <xsl:with-param name="value"><xsl:value-of select="ects"/></xsl:with-param>
                    </xsl:call-template>
                </td>
                <td><xsl:value-of select="su:sanitizeXlsHtml(stage)"/></td>
                <td><xsl:value-of select="su:sanitizeXlsHtml(periode)"/></td>
                <td><xsl:value-of select="su:sanitizeXlsHtml(periodeType)"/></td>
                <td><xsl:value-of select="su:sanitizeXlsHtml(codeComposante)"/></td>
                <td><xsl:value-of select="su:sanitizeXlsHtml(codeCIP)"/></td>
                <td><xsl:value-of select="su:sanitizeXlsHtml(CodeAnu)"/></td>
                <td><xsl:value-of select="calculCharges"/></td>
                <xsl:variable name="currentCourse" select="."/> 
                <xsl:for-each select="exsl:node-set($naturesEnseignement)/*">
                    <td>
                        <xsl:if test="count($currentCourse/volumeHoraire[@nature = current()/@id]) > 0">
                            <xsl:call-template name="display-double">
                                <xsl:with-param name="value"><xsl:value-of select="sum($currentCourse/volumeHoraire[@nature = current()/@id])"/></xsl:with-param>
                                <xsl:with-param name="showZero" select="true()"/>
                            </xsl:call-template>
                        </xsl:if>
                    </td>
                </xsl:for-each>
                <td><xsl:value-of select="su:sanitizeXlsHtml(etapePorteuse)"/></td>
                <td><xsl:value-of select="su:sanitizeXlsHtml(vetEtapePorteuse)"/></td>
                <td><xsl:value-of select="su:sanitizeXlsHtml(discipline)"/></td>
            </tr>
        </xsl:for-each>
    </xsl:template>
</xsl:stylesheet>
