<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2025 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                              xmlns:exsl="http://exslt.org/common"
                              xmlns:su="org.ametys.core.util.StringUtils"
                              exclude-result-prefixes="exsl su">
                              
    <xsl:template name="legende">
        <tr/>
        <tr>
            <td class="legend-title" colspan="{$nbColumns}">
                <strong><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_LEGENDE"/></strong>
            </td>
        </tr>
        <tr/>
        <xsl:if test="/report/skills/macro">
            <xsl:call-template name="legende-colors"/>
        </xsl:if>
        <xsl:apply-templates select="exsl:node-set($referenceTables)/items" mode="legende"/>
    </xsl:template>
    
    <xsl:template name="legende-colors">
        <tr>
            <td colspan="{$nbColumns}">
                <p><strong><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_LEGEND_COLORS"/></strong></p>
            </td>
        </tr>
        <tr/>
        <tr class="legend">
            <td colspan="{$nbColumns}" class="enabled"><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_LEGEND_ENABLED_SKILL"/></td>
        </tr>
        <tr/>
    </xsl:template>
    
    <xsl:template match="items" mode="legende">
        <!-- Display the legend items which are referenced in the report -->
        <xsl:variable name="items">
            <xsl:for-each select="item">
                <xsl:variable name="currentId" select="@id"/>
                <xsl:if test="$root//*[@id = $currentId and local-name() != 'item']">
                    <xsl:copy-of select="."/>
                </xsl:if>
            </xsl:for-each>
        </xsl:variable>
        
        <!-- Display the legend only if at least one item has to be displayed -->
        <xsl:if test="count(exsl:node-set($items)/item) > 0">
            <tr class="legend">
                <td colspan="{$nbColumns}">
                    <p><strong><xsl:apply-templates select="." mode="legende-title"/></strong></p>
                    <ul>
                        <xsl:for-each select="exsl:node-set($items)/item">
                            <xsl:sort select="@order" data-type="number"/>
                            <xsl:sort select="@code"/>
                            <li>
                                <strong>
                                    <xsl:call-template name="displayCodeOrShortLabel">
                                        <xsl:with-param name="contentId" select="@id"/>
                                    </xsl:call-template>
                                </strong>
                                <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_LEGEND_SEPARATOR"/>
                                <xsl:value-of select="su:sanitizeXlsHtml(@title)"/>
                            </li>
                        </xsl:for-each>
                    </ul>
                </td>
            </tr>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="items[@id = 'odf-enumeration.MccModaliteSession1']" mode="legende-title">
        <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_LEGEND_TITLE_SESSION_MODALITE_1"/>
    </xsl:template>
    
    <xsl:template match="items[@id = 'odf-enumeration.MccModaliteSession2']" mode="legende-title">
        <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_LEGEND_TITLE_SESSION_MODALITE_2"/>
    </xsl:template>
</xsl:stylesheet>
