/*
 *  Copyright 2018 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.odfpilotage.manager;

import java.io.File;
import java.io.IOException;

import org.apache.avalon.framework.component.Component;
import org.apache.commons.io.FileUtils;

import org.ametys.core.ui.Callable;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.ametys.runtime.util.AmetysHomeHelper;

/**
 * The manager for pilotage log files.
 */
public class PilotageLogFileManager extends AbstractLogEnabled implements Component
{
    /** The avalon role */
    public static final String ROLE = PilotageLogFileManager.class.getName();
    
    /**
     * Delete the given log file.
     * @param logFileName The log file name
     */
    @Callable (rights = "ODF_Rights_Pilotage_Tool")
    public void deleteLog(String logFileName)
    {
        File logFile = new File(getLogsDirectory(), logFileName);  
        if (logFile.exists())
        {
            try
            {
                FileUtils.forceDelete(logFile);
            }
            catch (IOException e)
            {
                getLogger().error("An error occurs during deletion of the file {}", logFile.getAbsolutePath(), e);
            }
        }
    }
    
    /**
     * Get the logs directory.
     * @return The directory where the pilotage logs are stored
     */
    public File getLogsDirectory()
    {
        return new File(AmetysHomeHelper.getAmetysHome(), "logs/pilotage");
    }
}
