/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfpilotage.clientsideelement;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ametys.cms.repository.Content;
import org.ametys.core.ui.Callable;
import org.ametys.odf.program.Container;
import org.ametys.odf.program.Program;
import org.ametys.odf.program.TraversableProgramPart;
import org.ametys.plugins.odfpilotage.clientsideelement.MCCWorkflowClientSideElement;
import org.ametys.plugins.odfpilotage.helper.MCCWorkflowHelper;
import org.ametys.plugins.repository.jcr.SimpleAmetysObject;
import org.ametys.runtime.i18n.I18nizableText;

public class ProgramMCCWorkflowClientSideElement
extends MCCWorkflowClientSideElement {
    @Callable(rights={""})
    public Map<String, Object> getStatus(String programId, String mccStatus) {
        Map results = super.getStatus(List.of(programId));
        List allrightContents = (List)results.get("allright-contents");
        if (allrightContents.isEmpty()) {
            return results;
        }
        Program program = (Program)this._resolver.resolveById(programId);
        Set childYears = this._odfHelper.getYears((TraversableProgramPart)program);
        if (childYears.isEmpty()) {
            return Map.of("no-years", true);
        }
        switch (MCCWorkflowHelper.MCCWorkflowStep.valueOf(mccStatus)) {
            case MCC_ORGUNIT_VALIDATED: {
                if (childYears.stream().allMatch(this._mccWorkflowHelper::isMCCOrgUnitValidated)) {
                    return Map.of("all-valid", true);
                }
                if (childYears.stream().anyMatch(c -> this._mccWorkflowHelper.isAvailableAction((Container)c, MCCWorkflowHelper.MCCWorkflowAction.VALIDATE_ORGUNIT, false))) break;
                return Map.of("no-available", true);
            }
            case MCC_CFVU_VALIDATED: {
                if (childYears.stream().allMatch(this._mccWorkflowHelper::isMCCCFVUValidated)) {
                    return Map.of("all-valid", true);
                }
                if (childYears.stream().anyMatch(c -> this._mccWorkflowHelper.isAvailableAction((Container)c, MCCWorkflowHelper.MCCWorkflowAction.VALIDATE_CFVU, false))) break;
                return Map.of("no-available", true);
            }
            default: {
                throw new IllegalArgumentException("Unexpected value for MCC status : " + mccStatus);
            }
        }
        results.put("valid-contents", new ArrayList());
        List validContents = (List)results.get("valid-contents");
        for (Container year : childYears) {
            this.getStatus(year, MCCWorkflowHelper.MCCWorkflowStep.valueOf(mccStatus), validContents);
        }
        return results;
    }

    protected void getStatus(Container container, MCCWorkflowHelper.MCCWorkflowStep mccStatus, List<Map<String, Object>> validContents) {
        Map defaultContentParams = this.getContentDefaultParameters((Content)container);
        if (this._mccWorkflowHelper.isStepValid(container, mccStatus)) {
            HashMap<String, I18nizableText> validContentParams = new HashMap<String, I18nizableText>(defaultContentParams);
            validContentParams.put("description", this._getValidDescription((Content)container));
            validContents.add(validContentParams);
        }
    }

    protected I18nizableText _getActiveDescription(Content content) {
        ArrayList<String> workflowI18nParameters = new ArrayList<String>();
        workflowI18nParameters.add(this._contentHelper.getTitle(content));
        I18nizableText ed = (I18nizableText)this._script.getParameters().get("active-content-description");
        return new I18nizableText(ed.getCatalogue(), ed.getKey(), workflowI18nParameters);
    }

    protected I18nizableText _getValidDescription(Content content) {
        ArrayList<String> workflowI18nParameters = new ArrayList<String>();
        workflowI18nParameters.add(this._contentHelper.getTitle(content));
        I18nizableText ed = (I18nizableText)this._script.getParameters().get("valid-content-description");
        return new I18nizableText(ed.getCatalogue(), ed.getKey(), workflowI18nParameters);
    }

    @Callable(rights={""})
    public LocalDate getMinDateForMCCOrgUnitValidation(String programItemId) {
        TraversableProgramPart programItem = (TraversableProgramPart)this._resolver.resolveById(programItemId);
        List<String> childYearIds = this._odfHelper.getYears(programItem).stream().filter(c -> this._mccWorkflowHelper.isAvailableAction((Container)c, MCCWorkflowHelper.MCCWorkflowAction.VALIDATE_ORGUNIT)).map(SimpleAmetysObject::getId).toList();
        return super.getMinDateForMCCOrgUnitValidation(childYearIds);
    }

    @Callable(rights={""})
    public LocalDate getMinDateForMCCCFVUValidation(String programItemId) {
        TraversableProgramPart programItem = (TraversableProgramPart)this._resolver.resolveById(programItemId);
        List<String> childYearIds = this._odfHelper.getYears(programItem).stream().filter(c -> this._mccWorkflowHelper.isAvailableAction((Container)c, MCCWorkflowHelper.MCCWorkflowAction.VALIDATE_CFVU)).map(SimpleAmetysObject::getId).toList();
        return super.getMinDateForMCCCFVUValidation(childYearIds);
    }

    @Callable(rights={"ODF_Pilotage_Global_MCC_Orgunit_Validated_Rights"}, paramIndex=0, rightContext="right.assignment.context.content")
    public Map<String, Object> validateOrgunitMCC(String programItemId, String validationDate, String comment) {
        TraversableProgramPart programItem = (TraversableProgramPart)this._resolver.resolveById(programItemId);
        List<String> childYearIds = this._odfHelper.getYears(programItem).stream().filter(y -> !this._mccWorkflowHelper.isMCCOrgUnitValidated((Container)y)).map(SimpleAmetysObject::getId).toList();
        return this.validateOrgunitMCC(childYearIds, null, validationDate, comment, Map.of());
    }

    @Callable(rights={"ODF_Pilotage_Global_CFVU_MCC_Validated_Rights"}, paramIndex=0, rightContext="right.assignment.context.content")
    public Map<String, Object> validateMCCForCVFU(String programItemId, String validationDate, String comment, Map<String, Object> contextualParameters) {
        TraversableProgramPart programItem = (TraversableProgramPart)this._resolver.resolveById(programItemId);
        List<String> containerIds = this._odfHelper.getYears(programItem).stream().filter(y -> !this._mccWorkflowHelper.isMCCCFVUValidated((Container)y)).map(SimpleAmetysObject::getId).toList();
        return this.validateMCCForCFVU(containerIds, null, validationDate, comment, contextualParameters);
    }
}

