/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfpilotage.report.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.ametys.cms.data.Binary;
import org.ametys.cms.repository.Content;
import org.ametys.cms.transformation.xslt.ResolveURIComponent;
import org.ametys.core.util.URIUtils;
import org.ametys.odf.ProgramItem;
import org.ametys.odf.course.Course;
import org.ametys.odf.program.Container;
import org.ametys.odf.skill.ODFSkillsHelper;
import org.ametys.plugins.odfpilotage.helper.MCCWorkflowHelper;
import org.ametys.plugins.odfpilotage.report.PilotageReport;
import org.ametys.plugins.odfpilotage.report.impl.AbstractMCCReport;
import org.ametys.plugins.odfpilotage.report.impl.tree.ProgramItemTree;
import org.ametys.plugins.odfpilotage.rule.RulesManager;
import org.ametys.plugins.odfpilotage.rule.export.SetMCCHeaderAction;
import org.ametys.plugins.odfpilotage.schedulable.AbstractReportSchedulable;
import org.ametys.plugins.odfpilotage.schedulable.OrgUnitMCCReportSchedulable;
import org.ametys.plugins.odfpilotage.schedulable.ProgramMCCReportSchedulable;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.data.holder.group.ModelAwareRepeater;
import org.ametys.plugins.repository.data.holder.group.ModelAwareRepeaterEntry;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class MCCReport
extends AbstractMCCReport {
    public static final String PARAMETER_DEFINITIVE = "definitive";
    public static final String PARAMETER_RULES_VERSION = "rulesVersion";
    public static final String PARAMETER_MCC_MODE = "mccMode";
    protected MCCWorkflowHelper _mccWorkflowHelper;

    @Override
    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._mccWorkflowHelper = (MCCWorkflowHelper)((Object)manager.lookup(MCCWorkflowHelper.ROLE));
    }

    @Override
    protected boolean isCompatibleSchedulable(AbstractReportSchedulable schedulable) {
        return schedulable instanceof ProgramMCCReportSchedulable || schedulable instanceof OrgUnitMCCReportSchedulable;
    }

    @Override
    protected boolean isSupportedTarget(PilotageReport.PilotageReportTarget target) {
        return super.isSupportedTarget(target) || PilotageReport.PilotageReportTarget.PROGRAM.equals((Object)target);
    }

    @Override
    protected PilotageReport.PilotageReportContent getReportContentForProgram(String outputFormat, Map<String, String> reportParameters) {
        return this._getReportContentForProgram(outputFormat, reportParameters);
    }

    @Override
    public String getType(Map<String, String> reportParameters, boolean shortName) {
        Object type = "mcc";
        if (reportParameters != null) {
            if (ODFSkillsHelper.isSkillsEnabled() && reportParameters.get("outputFormat").equals("xls") && "skills".equals(reportParameters.get(PARAMETER_MCC_MODE))) {
                type = (String)type + "c";
            }
            if (!shortName) {
                if (Boolean.parseBoolean(reportParameters.get(PARAMETER_DEFINITIVE))) {
                    type = (String)type + "-definitif";
                } else if (RulesManager.isRulesEnabled() && !reportParameters.get("outputFormat").equals("xls")) {
                    String rulesVersion = reportParameters.getOrDefault(PARAMETER_RULES_VERSION, "final");
                    type = (String)type + SetMCCHeaderAction.VERSION_TO_SUFFIX.getOrDefault(rulesVersion, "-" + rulesVersion);
                }
            }
        }
        return type;
    }

    @Override
    protected boolean isExcludedFromMCC(ProgramItemTree tree) {
        return this._pilotageHelper.isExcludedFromMCC((Course)tree.getCurrent());
    }

    @Override
    protected void saxSession(ContentHandler handler, ProgramItemTree tree, String sessionName) throws SAXException {
        Course course = (Course)tree.getCurrent();
        if (course.hasValue(sessionName) && !this._disableConditionsEvaluator.evaluateDisableConditions(this._sessionsView.getModelViewItem(sessionName).getDefinition(), sessionName, (Object)course)) {
            XMLUtils.startElement((ContentHandler)handler, (String)sessionName);
            List educationalPaths = this._odfHelper.getEducationPathFromPath(tree.getPath().getProgramItems(this._resolver));
            for (ModelAwareRepeaterEntry sessionEntry : this._odfHelper.getRepeaterEntriesByPath((ModelAwareRepeater)course.getRepeater(sessionName), educationalPaths).toList()) {
                this._saxSessionEntry(handler, sessionEntry, (Content)course);
            }
            XMLUtils.endElement((ContentHandler)handler, (String)sessionName);
        }
    }

    private void _saxSessionEntry(ContentHandler handler, ModelAwareRepeaterEntry sessionEntry, Content rootContent) throws SAXException {
        AttributesImpl entryAttrs = new AttributesImpl();
        entryAttrs.addCDATAAttribute("name", String.valueOf(sessionEntry.getPosition()));
        XMLUtils.startElement((ContentHandler)handler, (String)"entry", (Attributes)entryAttrs);
        this.saxSessionEntryDetails(handler, sessionEntry, rootContent);
        XMLUtils.endElement((ContentHandler)handler, (String)"entry");
    }

    @Override
    protected void populateMCCTree(ProgramItemTree tree) {
        ProgramItem programItem = tree.getCurrent();
        List children = this._odfHelper.getChildProgramItems(programItem);
        for (ProgramItem child : children) {
            ProgramItemTree childTree = tree.addChild(child);
            this.populateMCCTree(childTree);
        }
    }

    @Override
    protected Function<ProgramItem, List<Pair<String, String>>> _getProgramItemTransform(String outputFormat, Map<String, String> reportParameters) {
        if (Boolean.parseBoolean(reportParameters.get(PARAMETER_DEFINITIVE))) {
            return programItem -> {
                String attributePath;
                String uri;
                String fileUri;
                if (!(programItem instanceof Container)) {
                    throw new UnsupportedOperationException("The content '" + programItem.getId() + "' is not a Container and cannot be managed.");
                }
                Container container = (Container)programItem;
                ModelAwareRepeaterEntry entry = this._mccWorkflowHelper.getLastMCCValidatedEntry(container);
                if (entry != null && StringUtils.isNotEmpty((CharSequence)(fileUri = ResolveURIComponent.resolve((String)"attribute", (String)(uri = (attributePath = entry.getHoldingRepeater().getModel().getName() + "[" + entry.getPosition() + "]/pdf") + "?contentId=" + programItem.getId()), (boolean)false, (boolean)false, (boolean)true)))) {
                    return List.of(Pair.of((Object)((Binary)entry.getValue("pdf")).getFilename(), (Object)fileUri));
                }
                return null;
            };
        }
        if (ODFSkillsHelper.isSkillsEnabled() && "xls".equals(outputFormat)) {
            return programItem -> {
                HashMap<String, String> mcccReportParameters = new HashMap<String, String>(reportParameters);
                mcccReportParameters.put(PARAMETER_MCC_MODE, "skills");
                return List.of(this.programItemOutput((ProgramItem)programItem, outputFormat, reportParameters), this.programItemOutput((ProgramItem)programItem, outputFormat, (Map<String, String>)mcccReportParameters));
            };
        }
        return super._getProgramItemTransform(outputFormat, reportParameters);
    }

    @Override
    protected String _buildPipeline(String outputFormat, Map<String, String> reportParameters, String contentParameterName, AmetysObject content) {
        if (RulesManager.isRulesEnabled() && !outputFormat.equals("xls")) {
            StringBuilder sb = new StringBuilder();
            sb.append("cocoon://_plugins/odf-pilotage/");
            sb.append(reportParameters.getOrDefault(PARAMETER_RULES_VERSION, "final"));
            sb.append("/container-rules.");
            sb.append(outputFormat);
            sb.append("?");
            sb.append(contentParameterName);
            sb.append("=");
            sb.append(URIUtils.encodeParameter((String)content.getId()));
            sb.append("&reportId=");
            sb.append(this.getId());
            return sb.toString();
        }
        return super._buildPipeline(outputFormat, reportParameters, contentParameterName, content);
    }

    @Override
    protected void saxGlobalInformations(ContentHandler handler, ProgramItem programItem, Map<String, String> reportParameters) throws SAXException {
        super.saxGlobalInformations(handler, programItem, reportParameters);
        if (programItem instanceof Container) {
            Container container = (Container)programItem;
            this._reportHelper.saxMCCWorkflow(handler, container);
        }
    }

    @Override
    protected void saxOtherInformations(ContentHandler handler, ProgramItem programItem, Map<String, String> reportParameters) throws SAXException {
        super.saxOtherInformations(handler, programItem, reportParameters);
        if (ODFSkillsHelper.isSkillsEnabled()) {
            this._reportHelper.saxAcquiredMicroSkills(handler, programItem);
        }
    }
}

