/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfpilotage.report.impl;

import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.ametys.cms.contenttype.ContentType;
import org.ametys.cms.contenttype.ContentTypeExtensionPoint;
import org.ametys.cms.contenttype.RichTextAttributeDefinition;
import org.ametys.cms.repository.Content;
import org.ametys.odf.ODFHelper;
import org.ametys.odf.ProgramItem;
import org.ametys.odf.course.Course;
import org.ametys.odf.courselist.CourseList;
import org.ametys.odf.program.Container;
import org.ametys.odf.program.Program;
import org.ametys.odf.program.SubProgram;
import org.ametys.plugins.odfpilotage.report.impl.AbstractExtract;
import org.ametys.plugins.odfpilotage.report.impl.tree.ProgramItemTree;
import org.ametys.plugins.repository.data.ametysobject.DataAwareAmetysObject;
import org.ametys.plugins.repository.data.holder.group.ModelAwareRepeater;
import org.ametys.plugins.repository.data.holder.group.ModelAwareRepeaterEntry;
import org.ametys.plugins.repository.model.RepeaterDefinition;
import org.ametys.plugins.repository.model.RepositoryDataContext;
import org.ametys.runtime.model.ModelItem;
import org.ametys.runtime.model.ModelViewItem;
import org.ametys.runtime.model.ModelViewItemGroup;
import org.ametys.runtime.model.View;
import org.ametys.runtime.model.ViewItem;
import org.ametys.runtime.model.ViewItemAccessor;
import org.ametys.runtime.model.disableconditions.DefaultDisableConditionsEvaluator;
import org.ametys.runtime.model.disableconditions.DisableConditionsEvaluator;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class MCCSessionsExtract
extends AbstractExtract
implements Initializable {
    protected ContentTypeExtensionPoint _contentTypeEP;
    protected DisableConditionsEvaluator _disableConditionsEvaluator;
    private View _extractMCCView;
    private View _extractMCCSessionsView;

    @Override
    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._contentTypeEP = (ContentTypeExtensionPoint)manager.lookup(ContentTypeExtensionPoint.ROLE);
        this._disableConditionsEvaluator = (DisableConditionsEvaluator)manager.lookup(DefaultDisableConditionsEvaluator.ROLE);
    }

    public void initialize() throws Exception {
        ContentType courseContentType = (ContentType)this._contentTypeEP.getExtension("org.ametys.plugins.odf.Content.course");
        this._extractMCCView = courseContentType.getView("extract-mccsessions");
        this._extractMCCSessionsView = courseContentType.getView("extract-mccsessions-sessions");
    }

    @Override
    public String getType(Map<String, String> reportParameters, boolean shortName) {
        return "mccsessions";
    }

    @Override
    public Set<String> getSupportedOutputFormats() {
        return Set.of("csv");
    }

    @Override
    public void saxProgramItem(ContentHandler handler, String programItemId, Map<String, String> reportParameters) {
        ProgramItem programItem = (ProgramItem)this._resolver.resolveById(programItemId);
        if (!(programItem instanceof Program)) {
            throw new UnsupportedOperationException("The report '" + this.getType(reportParameters, true) + "' can be launch only on programs.");
        }
        Program program = (Program)programItem;
        ProgramItemTree programTree = this.createTreeFromProgramItem(programItem, reportParameters);
        try {
            handler.startDocument();
            AttributesImpl attrs = new AttributesImpl();
            attrs.addCDATAAttribute("type", this.getType(reportParameters, true));
            XMLUtils.startElement((ContentHandler)handler, (String)"report", (Attributes)attrs);
            this.saxHeader(handler);
            this.saxTree(handler, programTree, new CourseStructure(program, null, null, null, null, null));
            XMLUtils.endElement((ContentHandler)handler, (String)"report");
            handler.endDocument();
        }
        catch (Exception e) {
            this.getLogger().error("An error occured while generating 'MCC sessions' extract for program '{}' ({})", new Object[]{program.getTitle(), program.getCode(), e});
        }
    }

    protected ProgramItemTree createTreeFromProgramItem(ProgramItem programItem, Map<String, String> reportParameters) {
        ProgramItemTree programItemTree = new ProgramItemTree(programItem);
        this.populateTree(programItemTree);
        return programItemTree;
    }

    protected void populateTree(ProgramItemTree tree) {
        ProgramItem programItem = tree.getCurrent();
        for (ProgramItem child : this._odfHelper.getChildProgramItems(programItem)) {
            ProgramItemTree childTree = tree.addChild(child);
            this.populateTree(childTree);
        }
    }

    protected void saxTree(ContentHandler handler, ProgramItemTree tree, CourseStructure courseStructure) throws SAXException {
        ProgramItem programItem = tree.getCurrent();
        if (programItem instanceof Course) {
            Course course = (Course)programItem;
            if (!this._pilotageHelper.isExcludedFromMCC(course)) {
                XMLUtils.startElement((ContentHandler)handler, (String)"course");
                courseStructure.saxStructure(handler);
                course.dataToSAX(handler, (ViewItemAccessor)this._extractMCCView);
                this.saxMCCs(handler, tree);
                XMLUtils.endElement((ContentHandler)handler, (String)"course");
                this._saxChildren(handler, tree, programItem, courseStructure);
            }
        } else {
            this._saxChildren(handler, tree, programItem, courseStructure);
        }
    }

    private void _saxChildren(ContentHandler handler, ProgramItemTree tree, ProgramItem programItem, CourseStructure courseStructure) throws SAXException {
        for (ProgramItemTree child : tree.getChildren()) {
            this.saxTree(handler, child, CourseStructure.of(courseStructure, programItem, this._odfHelper));
        }
    }

    protected void saxMCCs(ContentHandler handler, ProgramItemTree tree) throws SAXException {
        XMLUtils.startElement((ContentHandler)handler, (String)"mcc");
        this.saxSession(handler, tree, "mccSession1");
        this.saxSession(handler, tree, "mccSession2");
        XMLUtils.endElement((ContentHandler)handler, (String)"mcc");
    }

    protected void saxSession(ContentHandler handler, ProgramItemTree tree, String sessionName) throws SAXException {
        Course course = (Course)tree.getCurrent();
        if (course.hasValue(sessionName) && !this._disableConditionsEvaluator.evaluateDisableConditions(this._extractMCCSessionsView.getModelViewItem(sessionName).getDefinition(), sessionName, (Object)course)) {
            XMLUtils.startElement((ContentHandler)handler, (String)sessionName);
            List educationalPaths = this._odfHelper.getEducationPathFromPath(tree.getPath().getProgramItems(this._resolver));
            for (ModelAwareRepeaterEntry sessionEntry : this._odfHelper.getRepeaterEntriesByPath((ModelAwareRepeater)course.getRepeater(sessionName), educationalPaths).toList()) {
                this._saxSessionEntry(handler, sessionEntry, (Content)course);
            }
            XMLUtils.endElement((ContentHandler)handler, (String)sessionName);
        }
    }

    private void _saxSessionEntry(ContentHandler handler, ModelAwareRepeaterEntry sessionEntry, Content rootContent) throws SAXException {
        AttributesImpl entryAttrs = new AttributesImpl();
        entryAttrs.addCDATAAttribute("name", String.valueOf(sessionEntry.getPosition()));
        XMLUtils.startElement((ContentHandler)handler, (String)"entry", (Attributes)entryAttrs);
        String repeaterName = sessionEntry.getHoldingRepeater().getModel().getName();
        sessionEntry.dataToSAX(handler, (ViewItemAccessor)this._extractMCCSessionsView.getModelViewItem(repeaterName), RepositoryDataContext.newInstance().withObject((DataAwareAmetysObject)rootContent).withDataPath(repeaterName + "[" + sessionEntry.getPosition() + "]"));
        XMLUtils.endElement((ContentHandler)handler, (String)"entry");
    }

    protected void saxHeader(ContentHandler handler) throws SAXException {
        XMLUtils.startElement((ContentHandler)handler, (String)"header");
        List<ModelViewItem> modelItem = this._extractMCCView.getViewItems().stream().filter(ModelViewItem.class::isInstance).map(ModelViewItem.class::cast).filter(this::_filterModelItem).toList();
        for (ModelViewItem modelViewItem : modelItem) {
            this.saxColumn(handler, (ViewItem)modelViewItem);
        }
        for (ViewItem viewItem : this.getSessionsViewItems()) {
            this.saxColumn(handler, viewItem);
        }
        XMLUtils.endElement((ContentHandler)handler, (String)"header");
    }

    private boolean _filterModelItem(ModelViewItem viewItem) {
        ModelItem definition = viewItem.getDefinition();
        return !(definition instanceof RichTextAttributeDefinition) && !(definition instanceof RepeaterDefinition);
    }

    protected List<ViewItem> getSessionsViewItems() {
        ArrayList<ViewItem> items = new ArrayList<ViewItem>();
        ModelViewItemGroup mccSession1View = (ModelViewItemGroup)this._extractMCCSessionsView.getViewItem("mccSession1");
        for (ViewItem child : mccSession1View.getViewItems()) {
            items.add(child);
        }
        ModelViewItemGroup mccSession2View = (ModelViewItemGroup)this._extractMCCSessionsView.getViewItem("mccSession2");
        for (ViewItem child : mccSession2View.getViewItems()) {
            if (mccSession1View.hasModelViewItem(child.getName())) continue;
            items.add(child);
        }
        return items;
    }

    protected void saxColumn(ContentHandler handler, ViewItem item) throws SAXException {
        if (item instanceof ModelViewItemGroup) {
            ModelViewItemGroup viewItemGroup = (ModelViewItemGroup)item;
            for (ViewItem child : viewItemGroup.getViewItems()) {
                this.saxColumn(handler, child);
            }
        } else if (item instanceof ModelViewItem) {
            ModelViewItem mViewItem = (ModelViewItem)item;
            AttributesImpl attrsItem = new AttributesImpl();
            attrsItem.addCDATAAttribute("path", mViewItem.getDefinition().getPath());
            String pathFromSession = this._getPathFromSession(mViewItem);
            if (StringUtils.isNotBlank((CharSequence)pathFromSession)) {
                attrsItem.addCDATAAttribute("pathFromSession", pathFromSession);
            }
            XMLUtils.startElement((ContentHandler)handler, (String)"column", (Attributes)attrsItem);
            item.getLabel().toSAX(handler, "label");
            XMLUtils.endElement((ContentHandler)handler, (String)"column");
        }
    }

    private String _getPathFromSession(ModelViewItem viewItem) {
        String path = viewItem.getDefinition().getPath();
        if (StringUtils.startsWithAny((CharSequence)path, (CharSequence[])new CharSequence[]{"mccSession1/", "mccSession2/"})) {
            return StringUtils.substring((String)path, (int)12);
        }
        return null;
    }

    private record CourseStructure(Program program, SubProgram subProgram, Container year, Container semester, CourseList level1CourseList, CourseList level2CourseList) {
        public static CourseStructure of(CourseStructure structure, ProgramItem item, ODFHelper odfHelper) {
            Program localProgram = structure.program();
            SubProgram localSubProgram = structure.subProgram();
            Container localYear = structure.year();
            Container localSemester = structure.semester();
            CourseList localLevel1CourseList = structure.level1CourseList();
            CourseList localLevel2CourseList = structure.level2CourseList();
            ProgramItem programItem = item;
            Objects.requireNonNull(programItem);
            ProgramItem programItem2 = programItem;
            int n = 0;
            block7: while (true) {
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{SubProgram.class, Container.class, Container.class, CourseList.class, CourseList.class}, (Object)programItem2, n)) {
                    case 0: {
                        SubProgram subprogram = (SubProgram)programItem2;
                        localSubProgram = localSubProgram == null ? subprogram : localSubProgram;
                        break block7;
                    }
                    case 1: {
                        Container container = (Container)programItem2;
                        if (!odfHelper.isContainerOfTypeYear(container)) {
                            n = 2;
                            continue block7;
                        }
                        localYear = localYear == null ? container : localYear;
                        break block7;
                    }
                    case 2: {
                        Container container = (Container)programItem2;
                        localSemester = localSemester == null ? container : localSemester;
                        break block7;
                    }
                    case 3: {
                        CourseList courseList = (CourseList)programItem2;
                        if (!courseList.getParentCourses().isEmpty()) {
                            n = 4;
                            continue block7;
                        }
                        localLevel1CourseList = localLevel1CourseList == null ? courseList : localLevel1CourseList;
                        break block7;
                    }
                    case 4: {
                        CourseList courseList = (CourseList)programItem2;
                        localLevel2CourseList = localLevel2CourseList == null ? courseList : localLevel2CourseList;
                        break block7;
                    }
                }
                break;
            }
            return new CourseStructure(localProgram, localSubProgram, localYear, localSemester, localLevel1CourseList, localLevel2CourseList);
        }

        public void saxStructure(ContentHandler handler) throws SAXException {
            XMLUtils.createElement((ContentHandler)handler, (String)"programTitle", (String)this.program.getTitle());
            XMLUtils.createElement((ContentHandler)handler, (String)"programCode", (String)this.program.getDisplayCode());
            if (this.subProgram != null) {
                XMLUtils.createElement((ContentHandler)handler, (String)"subProgramTitle", (String)this.subProgram.getTitle());
                XMLUtils.createElement((ContentHandler)handler, (String)"subProgramCode", (String)this.subProgram.getDisplayCode());
            }
            if (this.year != null) {
                XMLUtils.createElement((ContentHandler)handler, (String)"yearTitle", (String)this.year.getTitle());
                XMLUtils.createElement((ContentHandler)handler, (String)"yearCode", (String)this.year.getDisplayCode());
            }
            if (this.semester != null) {
                XMLUtils.createElement((ContentHandler)handler, (String)"semesterTitle", (String)this.semester.getTitle());
                XMLUtils.createElement((ContentHandler)handler, (String)"semesterCode", (String)this.semester.getDisplayCode());
            }
            if (this.level1CourseList != null) {
                XMLUtils.createElement((ContentHandler)handler, (String)"level1CourseListTitle", (String)this.level1CourseList.getTitle());
                XMLUtils.createElement((ContentHandler)handler, (String)"level1CourseListCode", (String)this.level1CourseList.getDisplayCode());
            }
            if (this.level2CourseList != null) {
                XMLUtils.createElement((ContentHandler)handler, (String)"level2CourseListTitle", (String)this.level2CourseList.getTitle());
                XMLUtils.createElement((ContentHandler)handler, (String)"level2CourseListCode", (String)this.level2CourseList.getDisplayCode());
            }
        }
    }
}

