/*
 *  Copyright 2018 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * This tool does display the pilotage history of a content in a timeline
 * @private
 */
Ext.define('Ametys.plugins.odf.pilotage.tool.PilotageHistoryTool', {
	extend: "Ametys.plugins.odf.pilotage.tool.AbstractTimelineTool",
	
    /**
     * @private
     * @readonly
     * @property {Number} MIN_WIDTH The min width
     */
    MIN_WIDTH: 350,
    
	/**
	 * @private
	 * @property {Ext.Template} _contentHintTpl The template used for hint description
	 */
	_contentHintTpl: new Ext.Template("{{i18n plugin.odf-pilotage:PLUGINS_ODF_PILOTAGE_HISTORY_TOOL_HINT}} <strong>{title}</strong>."),
	
	/**
	 * @private
	 * @property {Ext.Template} _contentHintParentTpl The template used for parent hint description
	 */
	_contentHintParentTpl: new Ext.Template("{{i18n plugin.odf-pilotage:PLUGINS_ODF_PILOTAGE_HISTORY_TOOL_PARENT_HINT}} <strong>{title}</strong>."),
	
    updateHintTpl: function(hintEl, result)
	{
		if (result.noright)
        {
            this.getContentPanel().items.get(1).down("*[dock='top']").update("{{i18n plugin.odf-pilotage:PLUGINS_ODF_PILOTAGE_HISTORY_TOOL_NO_RIGHT_HINT}}");
        }
        else if (result.workflow.length == 0)
        {
            this.getContentPanel().items.get(1).down("*[dock='top']").update("{{i18n plugin.odf-pilotage:PLUGINS_ODF_PILOTAGE_HISTORY_TOOL_NO_STEP_HINT}}");
        }
        else if (result.isParentProgram && result.title)
        {
            this.getContentPanel().items.get(1).down("*[dock='top']").update(this._contentHintParentTpl.applyTemplate({'title': result.title}));
        }
        else
        {
            this.getContentPanel().items.get(1).down("*[dock='top']").update(this._contentHintTpl.applyTemplate({'title': result.title}));
        }
    },
	
    getTimelineUrl: function()
    {
        return "pilotage-history.json";
    }
	
	
});
