<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2020 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:exsl="http://exslt.org/common"
                              xmlns:odf="org.ametys.plugins.odfweb.xslt.OdfXSLTHelper"
                              xmlns:cms="http://ametys.org/cms/3.0"
                              xmlns:func="http://exslt.org/functions"
                              xmlns:double="java.lang.Double"
                              exclude-result-prefixes="exsl odf cms double">
    
    <xsl:import href="odf-view:odf-pilotage://stylesheets/pilotage/utils/utils.xsl"/>
    
    <!-- Main table -->
    <xsl:param name="nbColumnsMaquette" select="11"/>
    <xsl:param name="nbColumnsElpEval" select="0"/>
    <xsl:param name="nbColumnsMccSession1" select="9"/>
    <xsl:param name="nbColumnsMccSession2" select="8"/>
    <xsl:param name="titleColumnPosition" select="4"/>
    <xsl:variable name="nbColumns" select="$nbColumnsMaquette + $nbColumnsElpEval + $nbColumnsMccSession1 + $nbColumnsMccSession2"/>
    
    <!-- Skills table -->
    <xsl:param name="nbSkillsColumnsCommon" select="5"/>
    <xsl:variable name="nbSkillsColumns" select="count(/report/skills/macro/micro)"/>
    <xsl:variable name="nbAllSkillsColumns" select="$nbSkillsColumnsCommon + $nbSkillsColumns"/>
    
    <xsl:variable name="naturesEnseignement">
        <xsl:for-each select="/report/items[@id = 'odf-enumeration.EnseignementNature']/category/item">
            <xsl:sort select="../@order" data-type="number"/>
            <xsl:sort select="../@code" data-type="text"/>
            <xsl:sort select="@order" data-type="number"/>
            <xsl:sort select="@code" data-type="text"/>
            
            <xsl:variable name="currentId" select="@id"/>
            <xsl:if test="$root//*[@id = $currentId and local-name() != 'item']">
                <item id="{@id}" code="{@code}"><xsl:value-of select="."/></item>
            </xsl:if>
        </xsl:for-each>
    </xsl:variable>
    
    <xsl:variable name="referenceTables">
        <xsl:copy-of select="odf:getTableRefItems('odf-enumeration.CourseNature', /report/lang, true())"/>
        <xsl:copy-of select="odf:getTableRefItems('odf-enumeration.MccRegime', /report/lang, true())"/>
        <xsl:copy-of select="odf:getTableRefItems('odf-enumeration.MccModaliteSession1', /report/lang, true())"/>
        <xsl:copy-of select="odf:getTableRefItems('odf-enumeration.MccModaliteSession2', /report/lang, true())"/>
        <xsl:copy-of select="odf:getTableRefItems('odf-enumeration.MccSessionNature', /report/lang, true())"/>
    </xsl:variable>
    
    <xsl:template name="default-nb-notes">1</xsl:template>
    <xsl:template name="default-ponderation">100%</xsl:template>
    
    <!-- Get the max number of notes for each session (between session 1 and 2, min value is 1) entry line and sum it -->
    <func:function name="cms:getTotalNotesRowspan">
        <xsl:param name="mcc1"/>
        <xsl:param name="mcc2"/>
        <xsl:param name="displayMcc2"/>
        
        <xsl:variable name="maxPosition" select="double:max(1, double:max(count($mcc1), count($mcc2) * $displayMcc2))"/>
        
        <!-- Méthode de sioux pour faire un for-each incrémental de 1 à $maxPosition en XSL v1 -->
        <xsl:variable name="maxNotesByRow">
            <xsl:for-each select="(//node())[position() &lt;= $maxPosition]">
                <xsl:variable name="currentPosition" select="position()"/>
                <row rowspan="{double:max(1, double:max(count($mcc1[$currentPosition]/notes/entry), count($mcc2[$currentPosition]/notes/entry) * $displayMcc2))}"/>
            </xsl:for-each>
        </xsl:variable>
        
        <func:result select="sum(exsl:node-set($maxNotesByRow)/row/@rowspan)"/>
    </func:function>
</xsl:stylesheet>
