/*
 *  Copyright 2024 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.odfpilotage.rule.observations;

import java.util.Map;
import java.util.Optional;

import org.apache.commons.lang3.StringUtils;

import org.ametys.cms.ObservationConstants;
import org.ametys.cms.repository.Content;
import org.ametys.core.observation.Event;
import org.ametys.odf.program.Container;
import org.ametys.odf.program.Program;

/**
 * Observer to remove derogation and additional rule if the program degree is modified.
 */
public class UpdateProgramRulesStep2Observer extends UpdateContainerRulesStep2Observer
{
    @Override
    protected boolean supportsContent(Content content)
    {
        return content instanceof Program;
    }
    
    @Override
    public void observe(Event event, Map<String, Object> transientVars) throws Exception
    {
        Program program = (Program) event.getArguments().get(ObservationConstants.ARGS_CONTENT);
        
        String degreeId = program.getDegree();
        String oldDegreeId = Optional.ofNullable(_getOldDegreeIds(program))
                .filter(l -> !l.isEmpty())
                .map(l -> l.get(0))
                .orElse(null);
        
        // Only process if the degree has been modified
        if (!StringUtils.equals(degreeId, oldDegreeId))
        {
            for (Container container : _getChildContainerOfTypeYear(program))
            {
                _deleteOldRulesOnContainer(container);
            }
        }
    }
}
