/*
 *  Copyright 2020 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.odfpilotage.schedulable;

import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

import org.ametys.core.ui.SelectionAwareAddTaskClientSideElement;
import org.ametys.plugins.odfpilotage.report.ReportExtensionPoint;

/**
 * This implementation creates an element for adding a new report task with a selected content in the UI.
 */
public class ODFSelectionAwareAddReportTaskClientSideElement extends SelectionAwareAddTaskClientSideElement implements Initializable
{
    /** The report extension point. */
    protected ReportExtensionPoint _reportEP;
    
    @Override
    public void service(ServiceManager smanager) throws ServiceException
    {
        _reportEP = (ReportExtensionPoint) smanager.lookup(ReportExtensionPoint.ROLE);
        super.service(smanager);
    }

    @Override
    public void initialize() throws Exception
    {
        AddReportTaskClientSideElement.initializeSchedulableParameters(_script, _reportEP);
    }

    @Override
    protected String _configureClass(Configuration configuration) throws ConfigurationException
    {
        return "Ametys.plugins.odfpilotage.controllers.ODFSelectionAndReportAwareAddTaskButtonController";
    }
    
    @Override
    protected Script _configureScript(Configuration configuration) throws ConfigurationException
    {
        Script script = super._configureScript(configuration);
        script.getScriptFiles().add(new ScriptFile("/plugins/odf-pilotage/resources/js/Ametys/plugins/odfpilotage/controllers/ODFSelectionAndReportAwareAddTaskButtonController.js"));
        return script;
    }
}
