/*
 *  Copyright 2019 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.odfpilotage.schedulable;

import java.util.Map;

import org.quartz.JobDataMap;

import org.ametys.core.schedule.Schedulable;
import org.ametys.plugins.odfpilotage.schedulable.helper.ConsistencyExtractSchedulableHelper;

/**
 * {@link Schedulable} for pilotage consistency report by orgunit.
 */
public class OrgUnitConsistencyExtractSchedulable extends OrgUnitReportSchedulable
{
    @Override
    public boolean forGenericReports()
    {
        return false;
    }
    
    @Override
    protected Map<String, String> getReportParameters(JobDataMap jobDataMap)
    {
        Map<String, String> reportParameters = super.getReportParameters(jobDataMap);
        reportParameters.putAll(ConsistencyExtractSchedulableHelper.getReportParameters(jobDataMap));
        return reportParameters;
    }
}
