/*
 *  Copyright 2025 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * MicroSkillWeight tool 
 * @private
 */
Ext.define('Ametys.plugins.odf.pilotage.tool.MicroSkillsWeightTool', {
    extend: 'Ametys.plugins.odf.pilotage.tool.MicroSkillsTool',
    
    statics: {
        /** @private */
        _OVER_INDEX: ''
    },
    
    _createTree: function()
    {
        let tree = Ext.create('Ametys.plugins.odf.pilotage.tool.MicroSkillsWeightTreeGridPanel', this._getTreeConfig());
        let me = this;
        window.setTimeout(function() {
            tree.mon(tree.body, 'mousemove', me._onContainerMouseOver, me);
        }, 1);
        return tree;
    },
    
    _onContainerMouseOver: function(e, t, eOpts)
    {
        Ametys.plugins.odf.pilotage.tool.MicroSkillsWeightTool._OVER_INDEX = Ext.fly(t).getAttribute('data-ametys-note') || '';
    }
})
