/*
 *  Copyright 2019 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.odfpilotage.report.consistency;

import java.util.Map;
import java.util.stream.Collectors;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.Enumerator;

/**
 * Enumerator for {@link ConsistencyAnalysis}
 */
public class AnalysisEnumerator implements Enumerator<String>, Serviceable
{
    /** The analysis extension point */
    protected AnalysisExtensionPoint _analysisEP;
    
    @Override
    public void service(ServiceManager smanager) throws ServiceException
    {
        _analysisEP = (AnalysisExtensionPoint) smanager.lookup(AnalysisExtensionPoint.ROLE);
    }
    
    public Map<String, I18nizableText> getEntries() throws Exception
    {
        Map<String, I18nizableText> entries = _analysisEP.getExtensionsIds()
            .stream()
            .map(_analysisEP::getExtension)
            .collect(Collectors.toMap(ConsistencyAnalysis::getId, ConsistencyAnalysis::getLabel));
        
        return entries;
    }
    
    @Override
    public I18nizableText getEntry(String value) throws Exception
    {
        ConsistencyAnalysis analysis = _analysisEP.getExtension(value);
        return analysis.getLabel();
    }
}
