/*
 *  Copyright 2019 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.odfpilotage.schedulable;

import java.util.Map;
import java.util.stream.Collectors;

import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

import org.ametys.core.schedule.SchedulableExtensionPoint;
import org.ametys.plugins.odfpilotage.report.PilotageReport;
import org.ametys.plugins.odfpilotage.report.ReportExtensionPoint;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.Enumerator;

/**
 * Enumerator for {@link ReportExtensionPoint}
 */
public class ReportExtensionEnumerator implements Enumerator<String>, Serviceable, Configurable, Initializable
{
    /** The report extension point */
    protected ReportExtensionPoint _reportEP;
    
    /** The schedulable extension point */
    protected SchedulableExtensionPoint _schedulableEP;
    
    /** The ID of the schedulable to instanciate. */
    protected String _schedulableId;
    
    /** The schedulable. */
    protected AbstractReportSchedulable _schedulable;
    
    @Override
    public void configure(Configuration configuration) throws ConfigurationException
    {
        _schedulableId = configuration.getChild("enumeration").getChild("custom-enumerator").getChild("schedulable").getValue();
    }
    
    @Override
    public void service(ServiceManager smanager) throws ServiceException
    {
        _reportEP = (ReportExtensionPoint) smanager.lookup(ReportExtensionPoint.ROLE);
        _schedulableEP = (SchedulableExtensionPoint) smanager.lookup(SchedulableExtensionPoint.ROLE);
    }

    @Override
    public void initialize() throws Exception
    {
        _schedulable = (AbstractReportSchedulable) _schedulableEP.getExtension(_schedulableId);
    }

    @Override
    public Map<String, I18nizableText> getEntries() throws Exception
    {
        return _reportEP.getSupportingExtensions(_schedulable)
            .stream()
            .collect(Collectors.toMap(PilotageReport::getId, PilotageReport::getLabel));
    }

    @Override
    public I18nizableText getEntry(String value) throws Exception
    {
        PilotageReport report = _reportEP.getExtension(value);
        return report.getLabel();
    }
}
