/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfpilotage.clientsideelement;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import org.ametys.cms.clientsideelement.SmartContentClientSideElement;
import org.ametys.cms.repository.Content;
import org.ametys.core.right.RightManager;
import org.ametys.core.schedule.Runnable;
import org.ametys.core.schedule.Schedulable;
import org.ametys.core.schedule.SchedulableExtensionPoint;
import org.ametys.core.ui.Callable;
import org.ametys.core.ui.ClientSideElement;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.util.DateUtils;
import org.ametys.core.util.JSONUtils;
import org.ametys.odf.ODFHelper;
import org.ametys.odf.program.Container;
import org.ametys.plugins.core.impl.schedule.DefaultRunnable;
import org.ametys.plugins.core.schedule.Scheduler;
import org.ametys.plugins.odfpilotage.helper.MCCWorkflowException;
import org.ametys.plugins.odfpilotage.helper.MCCWorkflowHelper;
import org.ametys.plugins.odfpilotage.rule.RulesManager;
import org.ametys.plugins.odfpilotage.schedulable.MCCValidatedPDFSchedulable;
import org.ametys.plugins.repository.lock.LockAwareAmetysObject;
import org.ametys.plugins.repository.lock.LockHelper;
import org.ametys.runtime.i18n.I18nizableText;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.commons.lang3.StringUtils;
import org.quartz.SchedulerException;

public class MCCWorkflowClientSideElement
extends SmartContentClientSideElement {
    protected MCCWorkflowHelper _mccWorkflowHelper;
    protected ODFHelper _odfHelper;
    protected Scheduler _scheduler;
    protected SchedulableExtensionPoint _schedulerEP;
    protected JSONUtils _jsonUtils;

    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._mccWorkflowHelper = (MCCWorkflowHelper)((Object)manager.lookup(MCCWorkflowHelper.ROLE));
        this._odfHelper = (ODFHelper)manager.lookup(ODFHelper.ROLE);
        this._scheduler = (Scheduler)manager.lookup(Scheduler.ROLE);
        this._schedulerEP = (SchedulableExtensionPoint)manager.lookup(SchedulableExtensionPoint.ROLE);
        this._jsonUtils = (JSONUtils)manager.lookup(JSONUtils.ROLE);
    }

    public List<ClientSideElement.Script> getScripts(boolean ignoreRights, Map<String, Object> contextParameters) {
        MCCWorkflowHelper.MCCWorkflowAction mccWorkflowAction;
        String mccWorkflowActionName;
        List scripts = super.getScripts(ignoreRights, contextParameters);
        if (!scripts.isEmpty() && StringUtils.isNotEmpty((CharSequence)(mccWorkflowActionName = (String)((ClientSideElement.Script)scripts.get(0)).getParameters().get("mcc-workflow-action"))) && (MCCWorkflowHelper.MCCWorkflowAction.VALIDATE_RULES.equals((Object)(mccWorkflowAction = MCCWorkflowHelper.MCCWorkflowAction.valueOf(mccWorkflowActionName))) || MCCWorkflowHelper.MCCWorkflowAction.REFUSE_RULES_ORGUNIT_CONTROL.equals((Object)mccWorkflowAction)) && !RulesManager.isRulesEnabled()) {
            return List.of();
        }
        return scripts;
    }

    @Callable(rights={""})
    public Map<String, Object> getStatus(List<String> containerIds, String mccWorkflowAction) {
        Map results = super.getStatus(containerIds);
        results.put("active-contents", new ArrayList());
        results.put("invalidmccstatus-contents", new ArrayList());
        results.put("noyear-contents", new ArrayList());
        List invalidContents = (List)results.get("invalidmccstatus-contents");
        List noYearContents = (List)results.get("noyear-contents");
        List allrightContents = (List)results.get("allright-contents");
        for (Map allRightContent : allrightContents) {
            String containerId = (String)allRightContent.get("id");
            Container container = (Container)this._resolver.resolveById(containerId);
            this._getStatus(container, MCCWorkflowHelper.MCCWorkflowAction.valueOf(mccWorkflowAction), noYearContents, invalidContents);
        }
        List<Object> invalidContentIds = invalidContents.stream().map(p -> p.get("id")).toList();
        List<Object> noYearContentIds = noYearContents.stream().map(p -> p.get("id")).toList();
        results.put("allright-contents", allrightContents.stream().filter(p -> !invalidContentIds.contains(p.get("id")) && !noYearContentIds.contains(p.get("id"))).toList());
        return results;
    }

    protected void _getStatus(Container container, MCCWorkflowHelper.MCCWorkflowAction workflowAction, List<Map<String, Object>> noYearContents, List<Map<String, Object>> invalidMCCStatusContents) {
        boolean disabled;
        Map defaultContentParams = this.getContentDefaultParameters((Content)container);
        if (!this._odfHelper.isContainerOfTypeYear(container)) {
            HashMap<String, I18nizableText> noYearContentParams = new HashMap<String, I18nizableText>(defaultContentParams);
            noYearContentParams.put("description", this._getNoYearDescription((Content)container));
            noYearContents.add(noYearContentParams);
            return;
        }
        boolean bl = disabled = !this._mccWorkflowHelper.isAvailableAction(container, workflowAction);
        if (disabled) {
            HashMap<String, I18nizableText> invalidContentParams = new HashMap<String, I18nizableText>(defaultContentParams);
            invalidContentParams.put("description", this._getInvalidMCCStatusDescription((Content)container));
            invalidMCCStatusContents.add(invalidContentParams);
        }
    }

    protected I18nizableText _getInvalidMCCStatusDescription(Content content) {
        ArrayList<String> workflowI18nParameters = new ArrayList<String>();
        workflowI18nParameters.add(this._contentHelper.getTitle(content));
        I18nizableText ed = (I18nizableText)this._script.getParameters().get("invalidmccstatus-content-description");
        return new I18nizableText(ed.getCatalogue(), ed.getKey(), workflowI18nParameters);
    }

    protected I18nizableText _getNoYearDescription(Content content) {
        ArrayList<String> workflowI18nParameters = new ArrayList<String>();
        workflowI18nParameters.add(this._contentHelper.getTitle(content));
        I18nizableText ed = (I18nizableText)this._script.getParameters().get("noyear-content-description");
        return new I18nizableText(ed.getCatalogue(), ed.getKey(), workflowI18nParameters);
    }

    @Callable(rights={""})
    public Map<String, Object> validateRules(List<String> containerIds, String validationDate, String comment, Map<String, Object> contextualParameters) {
        UserIdentity user = this._currentUserProvider.getUser();
        LocalDate localDate = StringUtils.isNotEmpty((CharSequence)validationDate) ? DateUtils.parseLocalDate((String)validationDate) : LocalDate.now();
        return this.doMCCAction(containerIds, "ODF_Pilotage_MCC_Rules_Validated_Rights", container -> this._mccWorkflowHelper.validateRules((Container)container, localDate, user, comment));
    }

    @Callable(rights={""})
    public Map<String, Object> refuseRulesOrgunitControl(List<String> containerIds, boolean sendMail, String comment, boolean reset) {
        UserIdentity user = this._currentUserProvider.getUser();
        return this.doMCCAction(containerIds, "ODF_Pilotage_MCC_Rules_Refuse_Control_Rights", container -> this._mccWorkflowHelper.refuseRulesOrgUnitControl((Container)container, user, sendMail, comment, reset));
    }

    @Callable(rights={""})
    public Map<String, Object> validateMCC(List<String> containerIds, String validationDate, String comment, Map<String, Object> contextualParameters) {
        UserIdentity user = this._currentUserProvider.getUser();
        LocalDate localDate = StringUtils.isNotEmpty((CharSequence)validationDate) ? DateUtils.parseLocalDate((String)validationDate) : LocalDate.now();
        return this.doMCCAction(containerIds, "ODF_Pilotage_MCC_Validated_Rights", container -> this._mccWorkflowHelper.validateMCC((Container)container, localDate, user, comment));
    }

    @Callable(rights={""})
    public Map<String, Object> refuseMCCOrgunitControl(List<String> containerIds, boolean sendMail, String comment, boolean reset) {
        UserIdentity user = this._currentUserProvider.getUser();
        return this.doMCCAction(containerIds, "ODF_Pilotage_MCC_Validated_Rights", container -> this._mccWorkflowHelper.refuseMCCOrgunitControl((Container)container, user, sendMail, comment, reset));
    }

    @Callable(rights={""})
    public LocalDate getMinDateForMCCOrgUnitControl(List<String> containerIds) {
        UserIdentity user = this._currentUserProvider.getUser();
        LocalDate minDate = null;
        for (String containerId : containerIds) {
            Container container = (Container)this._resolver.resolveById(containerId);
            if (this._rightManager.hasRight(user, "ODF_Pilotage_MCC_Orgunit_Control_Rights", (Object)container) != RightManager.RightResult.RIGHT_ALLOW) continue;
            LocalDate cMinDate = this._mccWorkflowHelper.getMinDateForMCCOrgUnitControl(container);
            if (minDate != null && !cMinDate.isAfter(minDate)) continue;
            minDate = cMinDate;
        }
        return minDate;
    }

    @Callable(rights={""})
    public LocalDate getMinDateForMCCOrgUnitValidation(List<String> containerIds) {
        UserIdentity user = this._currentUserProvider.getUser();
        LocalDate minDate = null;
        for (String containerId : containerIds) {
            Container container = (Container)this._resolver.resolveById(containerId);
            if (this._rightManager.hasRight(user, "ODF_Pilotage_MCC_Orgunit_Validated_Rights", (Object)container) != RightManager.RightResult.RIGHT_ALLOW) continue;
            LocalDate cMinDate = this._mccWorkflowHelper.getMinDateForMCCOrgUnitValidation(container);
            if (minDate != null && !cMinDate.isAfter(minDate)) continue;
            minDate = cMinDate;
        }
        return minDate;
    }

    @Callable(rights={""})
    public Map<String, Object> controlOrgunitMCC(List<String> containerIds, String validationDate, String comment, Map<String, Object> contextualParameters) {
        UserIdentity user = this._currentUserProvider.getUser();
        LocalDate localDate = StringUtils.isNotEmpty((CharSequence)validationDate) ? DateUtils.parseLocalDate((String)validationDate) : LocalDate.now();
        return this.doMCCAction(containerIds, "ODF_Pilotage_MCC_Orgunit_Control_Rights", container -> this._mccWorkflowHelper.controlMCCForOrgunit((Container)container, localDate, user, comment));
    }

    @Callable(rights={""})
    public Map<String, Object> validateOrgunitMCC(List<String> containerIds, String validationDate, String comment, Map<String, Object> contextualParameters) {
        return this.validateOrgunitMCC(containerIds, "ODF_Pilotage_MCC_Orgunit_Validated_Rights", validationDate, comment, contextualParameters);
    }

    public Map<String, Object> validateOrgunitMCC(List<String> containerIds, String rightId, String validationDate, String comment, Map<String, Object> contextualParameters) {
        UserIdentity user = this._currentUserProvider.getUser();
        LocalDate localDate = StringUtils.isNotEmpty((CharSequence)validationDate) ? DateUtils.parseLocalDate((String)validationDate) : LocalDate.now();
        return this.doMCCAction(containerIds, rightId, container -> this._mccWorkflowHelper.validateMCCForOrgunit((Container)container, localDate, user, comment));
    }

    @Callable(rights={""})
    public Map<String, Object> refuseCFVUControl(List<String> containerIds, boolean sendMail, String comment, boolean reset) {
        UserIdentity user = this._currentUserProvider.getUser();
        return this.doMCCAction(containerIds, "ODF_Pilotage_MCC_CFVU_Refuse_Control_Rights", container -> this._mccWorkflowHelper.refuseCFVUControl((Container)container, user, sendMail, comment, reset));
    }

    @Callable(rights={""})
    public Map<String, Object> controlMCCForCFVU(List<String> containerIds, String validationDate, String comment, Map<String, Object> contextualParameters) {
        UserIdentity user = this._currentUserProvider.getUser();
        LocalDate localDate = StringUtils.isNotEmpty((CharSequence)validationDate) ? DateUtils.parseLocalDate((String)validationDate) : LocalDate.now();
        return this.doMCCAction(containerIds, "ODF_Pilotage_CFVU_MCC_Control_Rights", container -> this._mccWorkflowHelper.controlMCCForCVFU((Container)container, localDate, user, comment));
    }

    @Callable(rights={""})
    public Map<String, Object> refuseCFVUValidation(List<String> containerIds, boolean sendMail, String comment, boolean reset) {
        UserIdentity user = this._currentUserProvider.getUser();
        return this.doMCCAction(containerIds, "ODF_Pilotage_MCC_CFVU_Refuse_Validation_Rights", container -> this._mccWorkflowHelper.refuseCFVUValidation((Container)container, user, sendMail, comment, reset));
    }

    @Callable(rights={""})
    public LocalDate getMinDateForMCCCFVUControl(List<String> containerIds) {
        UserIdentity user = this._currentUserProvider.getUser();
        LocalDate minDate = null;
        for (String containerId : containerIds) {
            Container container = (Container)this._resolver.resolveById(containerId);
            if (this._rightManager.hasRight(user, "ODF_Pilotage_CFVU_MCC_Control_Rights", (Object)container) != RightManager.RightResult.RIGHT_ALLOW) continue;
            LocalDate cMinDate = this._mccWorkflowHelper.getMinDateForMCCCFVUControl(container);
            if (minDate != null && !cMinDate.isAfter(minDate)) continue;
            minDate = cMinDate;
        }
        return minDate;
    }

    @Callable(rights={""})
    public Map<String, Object> refuseOrgUnitValidation(List<String> containerIds, boolean sendMail, String comment, boolean reset) {
        UserIdentity user = this._currentUserProvider.getUser();
        return this.doMCCAction(containerIds, "ODF_Pilotage_MCC_Orgunit_Refuse_Validation_Right", container -> this._mccWorkflowHelper.refuseOrgunitValidation((Container)container, user, sendMail, comment, reset));
    }

    @Callable(rights={""})
    public LocalDate getMinDateForMCCCFVUValidation(List<String> containerIds) {
        UserIdentity user = this._currentUserProvider.getUser();
        LocalDate minDate = null;
        for (String containerId : containerIds) {
            Container container = (Container)this._resolver.resolveById(containerId);
            if (this._rightManager.hasRight(user, "ODF_Pilotage_CFVU_MCC_Validated_Rights", (Object)container) != RightManager.RightResult.RIGHT_ALLOW) continue;
            LocalDate cMinDate = this._mccWorkflowHelper.getMinDateForMCCCFVUValidation(container);
            if (minDate != null && !cMinDate.isAfter(minDate)) continue;
            minDate = cMinDate;
        }
        return minDate;
    }

    @Callable(rights={""})
    public Map<String, Object> validateMCCForCFVU(List<String> containerIds, String validationDate, String comment, Map<String, Object> contextualParameters) {
        return this.validateMCCForCFVU(containerIds, "ODF_Pilotage_CFVU_MCC_Validated_Rights", validationDate, comment, contextualParameters);
    }

    public Map<String, Object> validateMCCForCFVU(List<String> containerIds, String rightId, String validationDate, String comment, Map<String, Object> contextualParameters) {
        UserIdentity user = this._currentUserProvider.getUser();
        LocalDate localDate = StringUtils.isNotEmpty((CharSequence)validationDate) ? DateUtils.parseLocalDate((String)validationDate) : LocalDate.now();
        Map<String, Object> results = this.doMCCAction(containerIds, rightId, container -> this._mccWorkflowHelper.validateMCCForCVFU((Container)container, localDate, user, comment));
        try {
            List successContentIds = (List)results.get("success-contents");
            if (!successContentIds.isEmpty()) {
                HashMap<String, Object> parameters = new HashMap<String, Object>();
                parameters.put("date", localDate);
                parameters.put("containerIds", successContentIds);
                parameters.put("contextualParameters", this._jsonUtils.convertObjectToJson(contextualParameters));
                Schedulable mccValidatedPDFSchedulable = (Schedulable)this._schedulerEP.getExtension(MCCValidatedPDFSchedulable.ID);
                String runnableId = mccValidatedPDFSchedulable.getId() + "$" + String.valueOf(UUID.randomUUID());
                DefaultRunnable runnable = new DefaultRunnable(runnableId, mccValidatedPDFSchedulable.getLabel(), mccValidatedPDFSchedulable.getDescription(), Runnable.FireProcess.NOW, null, mccValidatedPDFSchedulable.getId(), true, false, false, Runnable.MisfirePolicy.FIRE_ONCE, true, this._currentUserProvider.getUser(), parameters);
                this._scheduler.scheduleJob((Runnable)runnable);
                results.put("schedulable-id", runnableId);
                results.put("schedulable-label", mccValidatedPDFSchedulable.getLabel());
            }
        }
        catch (SchedulerException e) {
            results.put("error", "schedulable-error");
        }
        return results;
    }

    @Callable(rights={""})
    public Map<String, Object> invalidateMCCForCFVU(List<String> containerIds, boolean sendMail, String comment, boolean reset) {
        UserIdentity user = this._currentUserProvider.getUser();
        return this.doMCCAction(containerIds, "ODF_Pilotage_MCC_CFVU_Revert_Validation_Right", container -> this._mccWorkflowHelper.invalidateMCCForCVFU((Container)container, user, sendMail, comment, reset));
    }

    protected Map<String, Object> doMCCAction(List<String> containerIds, String rightId, Function<Container, Boolean> mccWorkflowAction) {
        HashMap<String, Object> results = new HashMap<String, Object>();
        ArrayList<Map<String, String>> noRightContents = new ArrayList<Map<String, String>>();
        ArrayList<Map<String, String>> lockedContents = new ArrayList<Map<String, String>>();
        ArrayList<Map<String, Object>> workflowErrorContents = new ArrayList<Map<String, Object>>();
        ArrayList<String> successContents = new ArrayList<String>();
        UserIdentity user = this._currentUserProvider.getUser();
        for (String containerId : containerIds) {
            Container container = (Container)this._resolver.resolveById(containerId);
            try {
                if (rightId != null && this._rightManager.hasRight(user, rightId, (Object)container) != RightManager.RightResult.RIGHT_ALLOW) {
                    noRightContents.add(Map.of("id", containerId, "title", container.getTitle()));
                    continue;
                }
                if (container.isLocked() && !LockHelper.isLockOwner((LockAwareAmetysObject)container, (UserIdentity)user)) {
                    lockedContents.add(Map.of("id", containerId, "title", container.getTitle()));
                    continue;
                }
                mccWorkflowAction.apply(container);
                successContents.add(containerId);
            }
            catch (MCCWorkflowException e) {
                workflowErrorContents.add(Map.of("id", containerId, "title", container.getTitle(), "errorType", e.getType() != null ? e.getType().name() : null));
            }
        }
        results.put("success-contents", successContents);
        results.put("noright-contents", noRightContents);
        results.put("locked-contents", lockedContents);
        results.put("invalidmccstatus-contents", workflowErrorContents);
        return results;
    }
}

