/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfpilotage.cost.entity;

import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.ametys.plugins.odfpilotage.cost.entity.Effectives;
import org.ametys.plugins.odfpilotage.cost.entity.EqTD;
import org.ametys.plugins.odfpilotage.cost.entity.Groups;
import org.ametys.plugins.odfpilotage.cost.entity.NormDetails;
import org.ametys.plugins.odfpilotage.cost.entity.VolumesOfHours;

public class ProgramItemData {
    private Effectives _effectives = null;
    private VolumesOfHours _volumesOfHours = null;
    private EqTD _eqTD = null;
    private Double _weight = null;
    private Set<String> _pathes = null;
    private Groups _groups = null;
    private NormDetails _normDetails = null;
    private boolean _isCoursePart = false;

    public Effectives getEffectives() {
        return this._effectives;
    }

    public void setEffectives(Effectives effectives) {
        this._effectives = effectives;
    }

    public VolumesOfHours getVolumesOfHours() {
        return this._volumesOfHours;
    }

    public void setVolumesOfHours(VolumesOfHours volumesOfHours) {
        this._volumesOfHours = volumesOfHours;
    }

    public Groups getGroups() {
        return this._groups;
    }

    public void setGroups(Groups groups) {
        this._groups = groups;
    }

    public EqTD getEqTD() {
        return this._eqTD;
    }

    public void setEqTD(EqTD eqTD) {
        this._eqTD = eqTD;
    }

    public Double getWeight() {
        return this._weight;
    }

    public void setWeight(Double weight) {
        this._weight = weight;
    }

    public Map<String, Optional<Double>> getHeRatios() {
        return Optional.ofNullable(this._effectives).map(Effectives::getLocalEffectiveByPath).map(Map::keySet).map(Collection::stream).orElseGet(() -> Stream.of(new String[0])).collect(Collectors.toMap(Function.identity(), this::getHeRatio));
    }

    public Optional<Double> getHeRatio(String programItemPath) {
        Optional<Double> localEffective = Optional.ofNullable(this._effectives).map(eff -> eff.getLocalEffective(programItemPath)).filter(eff -> eff > 0.0);
        if (localEffective.isEmpty()) {
            return Optional.empty();
        }
        Double proratedEqTD = Optional.ofNullable(this._eqTD).map(eqTD -> eqTD.getProratedEqTD(programItemPath)).orElse(0.0);
        return Optional.of(proratedEqTD / localEffective.get());
    }

    public Set<String> getPathes() {
        return this._pathes;
    }

    public void setPathes(Set<String> pathes) {
        this._pathes = pathes;
    }

    public NormDetails getNormDetails() {
        return this._normDetails;
    }

    public void setNormDetails(NormDetails normDetails) {
        this._normDetails = normDetails;
    }

    public boolean isCoursePart() {
        return this._isCoursePart;
    }

    public void setIsCoursePart(boolean isCoursePart) {
        this._isCoursePart = isCoursePart;
    }
}

