/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfpilotage.report.impl;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.ametys.odf.ProgramItem;
import org.ametys.odf.data.EducationalPath;
import org.ametys.odf.program.AbstractProgram;
import org.ametys.odf.program.Container;
import org.ametys.odf.program.Program;
import org.ametys.odf.program.TraversableProgramPart;
import org.ametys.odf.skill.ODFSkillsHelper;
import org.ametys.plugins.odfpilotage.report.PilotageReport;
import org.ametys.plugins.odfpilotage.report.impl.AbstractMaquetteExtract;
import org.apache.cocoon.xml.XMLUtils;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class ElpCompetencesExtract
extends AbstractMaquetteExtract {
    @Override
    public void initialize() throws Exception {
        this._courseView = this.getView("org.ametys.plugins.odf.Content.course", "report-elpcompetences");
        this._courseListView = this.getView("org.ametys.plugins.odf.Content.courseList", "report-elpcompetences");
        this._containerView = this.getView("org.ametys.plugins.odf.Content.container", "report-elpcompetences");
        this._subProgramView = this.getView("org.ametys.plugins.odf.Content.subProgram", "report-elpcompetences");
        this._programView = this.getView("org.ametys.plugins.odf.Content.program", "report-elpcompetences");
    }

    @Override
    public String getType(Map<String, String> reportParameters, boolean shortName) {
        return "elpcompetences";
    }

    @Override
    public String getDefaultOutputFormat() {
        return "xls";
    }

    @Override
    public Set<String> getSupportedOutputFormats() {
        return Set.of("xls");
    }

    @Override
    protected PilotageReport.PilotageReportContent getReportContentForOrgUnit(String outputFormat, Map<String, String> reportParameters) {
        throw new UnsupportedOperationException("Impossible to launch the report '" + this.getType() + "' on an org unit.");
    }

    @Override
    public void saxProgramItem(ContentHandler handler, String programItemId, Map<String, String> reportParameters) {
        if (!ODFSkillsHelper.isSkillsEnabled()) {
            throw new UnsupportedOperationException("Skills cannot be exported because the skills feature is disabled.");
        }
        super.saxProgramItem(handler, programItemId, reportParameters);
    }

    @Override
    protected void _saxOrgUnit(ContentHandler handler, String catalog, String lang, String orgUnitId, Map<String, String> reportParameters) {
        throw new UnsupportedOperationException("Impossible to launch the report '" + this.getType() + "' on an org unit.");
    }

    @Override
    protected ProgramItem getProgramItemIfValid(String programItemId) {
        ProgramItem programItem = (ProgramItem)this._resolver.resolveById(programItemId);
        if (!(programItem instanceof AbstractProgram) && !(programItem instanceof Container)) {
            throw new UnsupportedOperationException("The report '" + this.getType() + "' can be launch only on programs and containers.");
        }
        return programItem;
    }

    @Override
    protected Stream<? extends ProgramItem> _getProgramItemsFromProgram(Program program, Map<String, String> reportParameters) {
        return this._odfHelper.getYears((TraversableProgramPart)program).stream();
    }

    @Override
    protected StringBuilder buildReportFileNamePrefix(ProgramItem programItem, Map<String, String> reportParameters) {
        StringBuilder filenamePrefix = super.buildReportFileNamePrefix(programItem, reportParameters);
        if (!(programItem instanceof Program) && reportParameters.containsKey("program")) {
            Program parentProgram = (Program)this._resolver.resolveById(reportParameters.get("program"));
            filenamePrefix.append(parentProgram.getDisplayCode());
            filenamePrefix.append("-");
        }
        return filenamePrefix;
    }

    @Override
    protected void saxGlobalInformations(ContentHandler handler, ProgramItem programItem, Map<String, String> reportParameters) throws SAXException {
        super.saxGlobalInformations(handler, programItem, reportParameters);
        String programId = reportParameters.get("program");
        Program program = (Program)this._resolver.resolveById(programId);
        XMLUtils.createElement((ContentHandler)handler, (String)"programId", (String)program.getId());
        List<EducationalPath> pathsInProgram = this._odfHelper.getEducationalPaths(programItem, false, true).stream().filter(path -> ((String)path.getProgramItemIds().get(0)).equals(programId)).toList();
        for (EducationalPath path2 : pathsInProgram) {
            XMLUtils.createElement((ContentHandler)handler, (String)"path", (String)this._odfHelper.getEducationalPathAsString(path2));
        }
        this._reportHelper.saxAcquiredMicroSkills(handler, programItem, program);
    }
}

