/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfpilotage.rule;

import org.ametys.cms.contenttype.ContentType;
import org.ametys.cms.contenttype.ContentTypeExtensionPoint;
import org.ametys.cms.repository.Content;
import org.ametys.odf.catalog.CatalogsManager;
import org.ametys.odf.enumeration.OdfReferenceTableHelper;
import org.ametys.plugins.odfpilotage.rule.ThematicsHelper;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.runtime.model.View;
import org.ametys.runtime.model.ViewItemAccessor;
import org.ametys.runtime.model.type.DataContext;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.generation.ServiceableGenerator;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public abstract class AbstractThematicsGenerator
extends ServiceableGenerator {
    protected OdfReferenceTableHelper _odfRefTableHelper;
    protected ContentTypeExtensionPoint _contentTypeExtensionPoint;
    protected AmetysObjectResolver _resolver;
    protected CatalogsManager _catalogsManager;
    protected ThematicsHelper _thematicsHelper;

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._odfRefTableHelper = (OdfReferenceTableHelper)smanager.lookup(OdfReferenceTableHelper.ROLE);
        this._contentTypeExtensionPoint = (ContentTypeExtensionPoint)smanager.lookup(ContentTypeExtensionPoint.ROLE);
        this._resolver = (AmetysObjectResolver)smanager.lookup(AmetysObjectResolver.ROLE);
        this._catalogsManager = (CatalogsManager)smanager.lookup(CatalogsManager.ROLE);
        this._thematicsHelper = (ThematicsHelper)smanager.lookup(ThematicsHelper.ROLE);
    }

    protected void _saxContent(Content content) throws SAXException {
        View resultItems = ((ContentType)this._contentTypeExtensionPoint.getExtension("odf-enumeration.Thematic")).getView("main");
        AttributesImpl attrs = new AttributesImpl();
        attrs.addCDATAAttribute("id", content.getId());
        attrs.addCDATAAttribute("name", content.getName());
        attrs.addCDATAAttribute("title", content.getTitle());
        if (content.getLanguage() != null) {
            attrs.addCDATAAttribute("language", content.getLanguage());
        }
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"content", (Attributes)attrs);
        DataContext context = DataContext.newInstance().withEmptyValues(false);
        content.dataToSAX(this.contentHandler, (ViewItemAccessor)resultItems, context);
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"content");
    }

    protected void _saxCatalog(String catalogId) throws SAXException {
        if (StringUtils.isNotEmpty((CharSequence)catalogId)) {
            AttributesImpl attrs = new AttributesImpl();
            attrs.addCDATAAttribute("value", catalogId);
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"catalog", (Attributes)attrs, (String)this._catalogsManager.getCatalog(catalogId).getTitle());
        }
    }
}

