/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfpilotage.rule.catalog;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.ametys.cms.data.holder.group.IndexableRepeaterEntry;
import org.ametys.cms.data.holder.group.ModifiableIndexableRepeater;
import org.ametys.cms.repository.Content;
import org.ametys.cms.repository.ContentQueryHelper;
import org.ametys.cms.repository.ContentTypeExpression;
import org.ametys.cms.repository.DefaultContent;
import org.ametys.cms.repository.LanguageExpression;
import org.ametys.cms.repository.ModifiableContent;
import org.ametys.odf.catalog.CopyCatalogUpdater;
import org.ametys.odf.program.Container;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.ModifiableTraversableAmetysObject;
import org.ametys.plugins.repository.data.holder.group.ModelAwareRepeaterEntry;
import org.ametys.plugins.repository.data.holder.values.SynchronizableRepeater;
import org.ametys.plugins.repository.jcr.NameHelper;
import org.ametys.plugins.repository.query.expression.AndExpression;
import org.ametys.plugins.repository.query.expression.Expression;
import org.ametys.plugins.repository.query.expression.StringExpression;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public class ThematicsUpdater
extends AbstractLogEnabled
implements CopyCatalogUpdater,
Serviceable {
    private AmetysObjectResolver _resolver;

    public void service(ServiceManager manager) throws ServiceException {
        this._resolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
    }

    public void updateContents(String initialCatalogName, String newCatalogName, Map<Content, Content> copiedContents, Content targetParentContent) {
        for (Content initialContent : copiedContents.keySet()) {
            String code;
            if (!(initialContent instanceof Container)) continue;
            Content copiedContent = copiedContents.get(initialContent);
            this._copyInternalValue(initialContent, copiedContent, "TA");
            for (ModelAwareRepeaterEntry modelAwareRepeaterEntry : this._getRepeaterEntries(copiedContent, "thematics")) {
                code = (String)modelAwareRepeaterEntry.getValue("code");
                this._copyInternalValue(initialContent, copiedContent, code + "-ruleNumber");
            }
            for (ModelAwareRepeaterEntry modelAwareRepeaterEntry : this._getRepeaterEntries(copiedContent, "rules")) {
                if (!modelAwareRepeaterEntry.hasValue("thematicCode")) continue;
                code = (String)modelAwareRepeaterEntry.getValue("thematicCode");
                this._copyInternalValue(initialContent, copiedContent, code + "-ruleNumber");
            }
            ((ModifiableContent)copiedContent).saveChanges();
        }
    }

    private List<? extends ModelAwareRepeaterEntry> _getRepeaterEntries(Content content, String repeaterName) {
        return Optional.ofNullable(content.getRepeater(repeaterName)).map(r -> r.getEntries()).orElseGet(List::of);
    }

    private void _copyInternalValue(Content sourceContent, Content targetContent, String metadataName) {
        targetContent.getInternalDataHolder().setValue(metadataName, sourceContent.getInternalDataHolder().getValue(metadataName, (Object)0L));
    }

    public List<Content> getAdditionalContents(String catalogName) {
        return this._getContents(catalogName);
    }

    public Map<Content, Content> copyAdditionalContents(String initialCatalogName, String newCatalogName) {
        HashMap<Content, Content> copiedContents = new HashMap<Content, Content>();
        List contentsToCopy = this._getContents(initialCatalogName);
        for (DefaultContent thematic : contentsToCopy) {
            if (this._thematicExists((Content)thematic, newCatalogName)) {
                this.getLogger().info("A thematic already exists with the same code, catalog and language [{}, {}, {}]", new Object[]{thematic.getValue("code"), newCatalogName, thematic.getLanguage()});
                continue;
            }
            ModifiableContent newThematic = thematic.copyTo((ModifiableTraversableAmetysObject)thematic.getParent(), NameHelper.filterName((String)thematic.getTitle()));
            this._copyInternalValue((Content)thematic, (Content)newThematic, String.valueOf(thematic.getValue("code")) + "-ruleNumber");
            newThematic.saveChanges();
            HashMap<String, String> values = new HashMap<String, String>();
            values.put("catalog", newCatalogName);
            ArrayList<Integer> positions = new ArrayList<Integer>();
            ArrayList<Map<String, String>> repeaterValues = new ArrayList<Map<String, String>>();
            ModifiableIndexableRepeater repeater = newThematic.getRepeater("rules");
            if (repeater != null) {
                for (IndexableRepeaterEntry entry : repeater.getEntries()) {
                    String status = (String)entry.getValue("status");
                    if ("NON_MODIFIED".equals(status) || "SUSPENDED".equals(status)) continue;
                    positions.add(entry.getPosition());
                    repeaterValues.add(Map.of("status", "NON_MODIFIED"));
                }
            }
            if (!repeaterValues.isEmpty()) {
                values.put("rules", (String)SynchronizableRepeater.replace(repeaterValues, positions));
            }
            newThematic.synchronizeValues(values);
            newThematic.saveChanges();
            copiedContents.put((Content)thematic, (Content)newThematic);
        }
        return copiedContents;
    }

    private boolean _thematicExists(Content thematic, String newCatalogName) {
        return this._getContents(newCatalogName, thematic).findAny().isPresent();
    }

    private <T extends Content> List<T> _getContents(String catalogName) {
        return this._getContents(catalogName, null).toList();
    }

    private <T extends Content> Stream<T> _getContents(String catalogName, Content thematic) {
        AndExpression expression = new AndExpression(new Expression[0]);
        expression.add((Object)new ContentTypeExpression(Expression.Operator.EQ, new String[]{"odf-enumeration.Thematic"}));
        expression.add((Object)new StringExpression("catalog", Expression.Operator.EQ, catalogName));
        if (thematic != null) {
            expression.add((Object)new LanguageExpression(Expression.Operator.EQ, thematic.getLanguage()));
            expression.add((Object)new StringExpression("code", Expression.Operator.EQ, (String)thematic.getValue("code")));
        }
        String query = ContentQueryHelper.getContentXPathQuery((Expression)expression);
        return this._resolver.query(query).stream();
    }
}

