/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfpilotage.rule.observations;

import java.util.Map;
import org.ametys.cms.contenttype.ContentTypesHelper;
import org.ametys.cms.helper.AmetysIdentifiers;
import org.ametys.cms.repository.Content;
import org.ametys.cms.repository.ModifiableContent;
import org.ametys.core.observation.Event;
import org.ametys.core.observation.Observer;
import org.ametys.plugins.odfpilotage.rule.RulesManager;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.ModifiableTraversableAmetysObject;
import org.ametys.plugins.repository.jcr.DefaultTraversableAmetysObject;
import org.ametys.runtime.plugin.component.PluginAware;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.lang3.StringUtils;

public class ThematicCreationObserver
implements Observer,
Serviceable,
PluginAware {
    protected AmetysObjectResolver _resolver;
    protected ContentTypesHelper _contentTypesHelper;
    protected AmetysIdentifiers _identifiers;
    protected String _pluginName;

    public void service(ServiceManager manager) throws ServiceException {
        this._resolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
        this._contentTypesHelper = (ContentTypesHelper)manager.lookup(ContentTypesHelper.ROLE);
        this._identifiers = (AmetysIdentifiers)manager.lookup(AmetysIdentifiers.ROLE);
    }

    public void setPluginInfo(String pluginName, String featureName, String id) {
        this._pluginName = pluginName;
    }

    public boolean supports(Event event) {
        if (!RulesManager.isRulesEnabled()) {
            return false;
        }
        if (event.getId().equals("content.added")) {
            Content content = (Content)event.getArguments().get("content");
            return this._contentTypesHelper.isInstanceOf(content, "odf-enumeration.Thematic");
        }
        return false;
    }

    public int getPriority() {
        return 0;
    }

    public void observe(Event event, Map<String, Object> transientVars) throws Exception {
        ModifiableContent content = (ModifiableContent)event.getArguments().get("content");
        String code = (String)content.getValue("code");
        if (StringUtils.isEmpty((CharSequence)code)) {
            content.setValue("code", (Object)("TS" + this._getAndIncrement("TS")));
        }
        content.saveChanges();
    }

    private long _getAndIncrement(String prefix) {
        long counter = this._identifiers.readCounter(this._pluginName, prefix) + 1L;
        this._identifiers.saveCounter(this._pluginName, prefix, counter);
        return counter;
    }

    protected DefaultTraversableAmetysObject _getOrCreateNode(ModifiableTraversableAmetysObject parentNode, String nodeName, String nodeType) throws AmetysRepositoryException {
        DefaultTraversableAmetysObject definitionsNode;
        if (parentNode.hasChild(nodeName)) {
            definitionsNode = (DefaultTraversableAmetysObject)parentNode.getChild(nodeName);
        } else {
            definitionsNode = (DefaultTraversableAmetysObject)parentNode.createChild(nodeName, nodeType);
            parentNode.saveChanges();
        }
        return definitionsNode;
    }
}

