/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfpilotage.schedulable.helper;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.ametys.plugins.odfpilotage.rule.RulesManager;
import org.ametys.runtime.model.ElementDefinition;
import org.apache.commons.lang3.StringUtils;
import org.quartz.JobDataMap;

public final class MCCReportSchedulableHelper {
    public static final String JOBDATAMAP_ONE_FILE_BY_PROGRAM_KEY = "oneFileByProgram";
    public static final String JOBDATAMAP_DEFINITIVE_KEY = "definitive";
    public static final String JOBDATAMAP_RULES_VERSION_KEY = "rulesVersion";
    public static final String JOBDATAMAP_FILTER_ON_CURRENT_ORGUNIT = "filterOnCurrentOrgUnit";
    public static final String JOBDATAMAP_FILTER_BY_ORGUNIT = "filterByOrgUnit";

    private MCCReportSchedulableHelper() {
    }

    public static Map<String, String> getReportParameters(JobDataMap jobDataMap) {
        String chosenOrgUnitId;
        HashMap<String, String> reportParameters = new HashMap<String, String>();
        boolean isDefinitive = false;
        if (jobDataMap.containsKey((Object)"parameterValues#definitive")) {
            isDefinitive = jobDataMap.getBoolean("parameterValues#definitive");
            reportParameters.put(JOBDATAMAP_DEFINITIVE_KEY, Boolean.toString(isDefinitive));
        }
        if (isDefinitive) {
            if (jobDataMap.containsKey((Object)"parameterValues#outputFormat")) {
                reportParameters.put("outputFormat", "pdf");
            }
        } else if (jobDataMap.containsKey((Object)"parameterValues#oneFileByProgram")) {
            boolean oneFileByProgram = jobDataMap.getBoolean("parameterValues#oneFileByProgram");
            reportParameters.put(JOBDATAMAP_ONE_FILE_BY_PROGRAM_KEY, Boolean.toString(oneFileByProgram));
        }
        if (jobDataMap.containsKey((Object)"parameterValues#rulesVersion")) {
            reportParameters.put(JOBDATAMAP_RULES_VERSION_KEY, jobDataMap.getString("parameterValues#rulesVersion"));
        }
        if (jobDataMap.containsKey((Object)"parameterValues#filterOnCurrentOrgUnit")) {
            boolean filterOnOrgUnit = jobDataMap.getBoolean("parameterValues#filterOnCurrentOrgUnit");
            reportParameters.put(JOBDATAMAP_FILTER_ON_CURRENT_ORGUNIT, Boolean.toString(filterOnOrgUnit));
        } else if (jobDataMap.containsKey((Object)"parameterValues#filterByOrgUnit") && StringUtils.isNotBlank((CharSequence)(chosenOrgUnitId = jobDataMap.getString("parameterValues#filterByOrgUnit")))) {
            reportParameters.put(JOBDATAMAP_FILTER_BY_ORGUNIT, chosenOrgUnitId);
        }
        return reportParameters;
    }

    public static Map<String, ElementDefinition> getParameters(Map<String, ElementDefinition> original) {
        if (RulesManager.isRulesEnabled()) {
            if (original.containsKey(JOBDATAMAP_ONE_FILE_BY_PROGRAM_KEY)) {
                LinkedHashMap<String, ElementDefinition> copy = new LinkedHashMap<String, ElementDefinition>(original);
                copy.remove(JOBDATAMAP_ONE_FILE_BY_PROGRAM_KEY);
                return copy;
            }
        } else if (original.containsKey(JOBDATAMAP_RULES_VERSION_KEY)) {
            LinkedHashMap<String, ElementDefinition> copy = new LinkedHashMap<String, ElementDefinition>(original);
            copy.remove(JOBDATAMAP_RULES_VERSION_KEY);
            return copy;
        }
        return original;
    }
}

