/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfpilotage.search;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.ametys.cms.data.ContentValue;
import org.ametys.cms.repository.Content;
import org.ametys.cms.search.model.impl.AbstractStaticSearchModelCriterionDefinition;
import org.ametys.cms.search.query.ContentIdQuery;
import org.ametys.cms.search.query.MatchAllQuery;
import org.ametys.cms.search.query.MatchNoneQuery;
import org.ametys.cms.search.query.Query;
import org.ametys.odf.course.Course;
import org.ametys.odf.data.EducationalPath;
import org.ametys.odf.skill.ODFSkillsHelper;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

public class MicroSkillsAttachedToCourseCriterionDefinition
extends AbstractStaticSearchModelCriterionDefinition<String> {
    protected AmetysObjectResolver _resolver;
    protected ODFSkillsHelper _odfSkillsHelper;

    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._resolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
        this._odfSkillsHelper = (ODFSkillsHelper)manager.lookup(ODFSkillsHelper.ROLE);
    }

    public Query.Operator getOperator() {
        return Query.Operator.EQ;
    }

    protected String getTypeId() {
        return "string";
    }

    public Query getQuery(Object value, Query.Operator customOperator, Map<String, Object> allValues, String language, Map<String, Object> contextualParameters) {
        if (value instanceof EducationalPath) {
            EducationalPath educationalPath = (EducationalPath)value;
            List programItemIds = educationalPath.getProgramItemIds();
            return this._getQueryForCourseAndProgram(programItemIds);
        }
        if (value instanceof String) {
            String educationalPath = (String)value;
            List<String> programItemIds = List.of(educationalPath.split(";"));
            return this._getQueryForCourseAndProgram(programItemIds);
        }
        return new MatchAllQuery();
    }

    private Query _getQueryForCourseAndProgram(List<String> programItemIds) {
        if (programItemIds.size() >= 2) {
            String programId = programItemIds.getFirst();
            String courseId = programItemIds.getLast();
            try {
                Course course;
                ContentValue[] acquiredSkills;
                Content content = (Content)this._resolver.resolveById(courseId);
                if (content instanceof Course && (acquiredSkills = (course = (Course)content).getAcquiredSkills(programId)) != null) {
                    String[] courseMicroSkillsIds = (String[])Arrays.stream(acquiredSkills).map(ContentValue::getContentId).toArray(String[]::new);
                    if (courseMicroSkillsIds.length > 0) {
                        return new ContentIdQuery(courseMicroSkillsIds);
                    }
                    return new MatchNoneQuery();
                }
            }
            catch (AmetysRepositoryException e) {
                this._logger.warn("The search of microskills could not be done because the requested course of id '{}' does not exist.", (Object)courseId, (Object)e);
            }
        }
        return new MatchAllQuery();
    }
}

