/*
 *  Copyright 2024 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

const rightProfileDAO = Ametys.serviceManager.lookup("org.ametys.core.right.RightProfilesDAO");

logger.info("Add news rights to profiles with MCC workflow rights");

let count = 0;
let profiles = rightProfileDAO.getProfiles()

for(let profile of profiles)
{
    let updated = false;
    let profileRights = rightProfileDAO.getRights(profile);
    
    if (profileRights.contains("ODF_Pilotage_MCC_Orgunit_Validated_Super_Rights") && !profileRights.contains("ODF_Pilotage_MCC_Orgunit_Controlled_Super_Rights"))
    {
        rightProfileDAO.addRight(profile, "ODF_Pilotage_MCC_Orgunit_Controlled_Super_Rights");
        updated = true;
    }
	
	if (profileRights.contains("ODF_Pilotage_MCC_CFVU_Validated_Super_Rights") && !profileRights.contains("ODF_Pilotage_MCC_CFVU_Controlled_Super_Rights"))
    {
        rightProfileDAO.addRight(profile, "ODF_Pilotage_MCC_CFVU_Controlled_Super_Rights");
        updated = true;
    }
	
	if (profileRights.contains("ODF_Pilotage_CFVU_MCC_Validated_Rights") && !profileRights.contains("ODF_Pilotage_CFVU_MCC_Control_Rights"))
    {
		rightProfileDAO.addRight(profile, "ODF_Pilotage_CFVU_MCC_Control_Rights");
		rightProfileDAO.addRight(profile, "ODF_Pilotage_MCC_CFVU_Refuse_Control_Rights");
		rightProfileDAO.addRight(profile, "ODF_Pilotage_MCC_CFVU_Refuse_Validation_Rights");
        rightProfileDAO.addRight(profile, "ODF_Pilotage_MCC_CFVU_Revert_Validation_Right");
        updated = true;
    }
	
	if (profileRights.contains("ODF_Pilotage_MCC_Orgunit_Validated_Rights") && !profileRights.contains("ODF_Pilotage_MCC_Orgunit_Control_Rights"))
    {
        rightProfileDAO.addRight(profile, "ODF_Pilotage_MCC_Orgunit_Refuse_Validation_Right");
		rightProfileDAO.addRight(profile, "ODF_Pilotage_MCC_Orgunit_Control_Rights");
		rightProfileDAO.addRight(profile, "ODF_Pilotage_MCC_Rules_Refuse_Control_Rights");
		rightProfileDAO.addRight(profile, "ODF_Pilotage_MCC_Refuse_Control_Rights");
        updated = true;
    }
	
	if (updated)
	{
		count++;
	}
}

logger.info(`${count} profile(s) have been updated`);
