/*
 *  Copyright 2018 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
/**
 * This button allows to create a content and reference-it or create it as sub-content of the selected content (on a given metadata).
 * The catalog of the current selected content is set as additional workflow parameters.
 */
Ext.define('Ametys.plugins.odf.pilotage.controller.AddODFPilotageShareableCourseToCurrentSelectionButtonController', {
    extend: "Ametys.plugins.odf.content.controller.AddShareableCourseToCurrentSelectionButtonController",
   
    constructor: function(config)
    {
        this.callParent(arguments);
        
        Ametys.message.MessageBus.on(Ametys.message.Message.MODIFIED, this._onModified, this);
    },
    
    /**
     * @private
     * Listener handler for modified messages
     * @param {Ametys.message.Message} message the message
     */
    _onModified: function(message)
    {
        if (this.updateTargetsInCurrentSelectionTargets(message))
        {
            this.refresh();
        }
    },
    
    updateState: function ()
	{
        this.callParent(arguments);
        
        if (!this.isDisabled())
        {
            var target = this.getMatchingTargets()[0];
	        Ametys.plugins.odf.pilotage.helper.ODFPilotageControllerHelper.getRestrictionStatus(this, target, this._getSourceAttributeRef());
        }
    	
	}
});
    