<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2025 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                              xmlns:su="org.ametys.core.util.StringUtils"
                              exclude-result-prefixes="su">
    
    <xsl:template match="program|subProgram|container" mode="title">
        <tr><td colspan="{$nbColumns}" class="main-title1"><xsl:value-of select="su:sanitizeXlsHtml(title)"/></td></tr>
        <xsl:call-template name="catalog-title"/>
        <xsl:if test="/report/path">
            <tr><td colspan="{$nbColumns}" class="main-title3"><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_HEADER_INCLUDES"/></td></tr>
            <xsl:for-each select="/report/path">
                <tr><td colspan="{$nbColumns}" class="main-title3">&#x2022; <xsl:value-of select="."/></td></tr>
            </xsl:for-each>
        </xsl:if>
        <xsl:apply-templates select="." mode="section-header-line"/>
        <tr class="new-header"><td colspan="{$nbColumns}">&#160;</td></tr>
    </xsl:template>
    
    <xsl:template name="catalog-title">
        <tr><td colspan="{$nbColumns}" class="main-title2"><xsl:apply-templates select="." mode="catalog"/></td></tr>
    </xsl:template>
    
    <xsl:template match="program|subProgram|container" mode="catalog">
        <xsl:value-of select="/report/catalog"/>
    </xsl:template>
    <xsl:template match="program" mode="section-header-line">
        <xsl:apply-templates select="." mode="section-header-line-title"/>
        <xsl:call-template name="label-value">
            <xsl:with-param name="i18nLabelKey" select="'PLUGINS_ODF_PILOTAGE_MCC_HEADER_ECTS'"/>
            <xsl:with-param name="value" select="ects/@title"/>
        </xsl:call-template>
        <xsl:call-template name="label-value">
            <xsl:with-param name="i18nLabelKey" select="'PLUGINS_ODF_PILOTAGE_MCC_HEADER_DEGREE'"/>
            <xsl:with-param name="value" select="su:sanitizeXlsHtml(degree/@title)"/>
        </xsl:call-template>
        <xsl:call-template name="label-value">
            <xsl:with-param name="i18nLabelKey" select="'PLUGINS_ODF_PILOTAGE_MCC_HEADER_MENTION'"/>
            <xsl:with-param name="value" select="su:sanitizeXlsHtml(mention/@title)"/>
        </xsl:call-template>
        <xsl:variable name="domains">
            <xsl:for-each select="domain">
                <xsl:value-of select="su:sanitizeXlsHtml(@title)"/>
                <xsl:if test="position() != last()"><xsl:text>, </xsl:text></xsl:if>
            </xsl:for-each>
        </xsl:variable>
        <xsl:call-template name="label-value">
            <xsl:with-param name="i18nLabelKey" select="'PLUGINS_ODF_PILOTAGE_MCC_HEADER_DOMAIN'"/>
            <xsl:with-param name="value" select="$domains"/>
        </xsl:call-template>
        <xsl:call-template name="label-value">
            <xsl:with-param name="i18nLabelKey" select="'PLUGINS_ODF_PILOTAGE_MCC_HEADER_SPECIALITY'"/>
            <xsl:with-param name="value" select="speciality"/>
        </xsl:call-template>
        <xsl:apply-templates select="knowledgeCheck"/>
    </xsl:template>
    
    <xsl:template match="subProgram" mode="section-header-line">
        <xsl:variable name="padding" select="count(ancestor::*[parent::program or parent::subProgram or parent::container][local-name() = 'subProgram' or local-name() = 'container'])*4" />
        
        <xsl:apply-templates select="." mode="section-header-line-title">
            <xsl:with-param name="padding" select="$padding"/>
        </xsl:apply-templates>
        <xsl:call-template name="label-value">
            <xsl:with-param name="i18nLabelKey" select="'PLUGINS_ODF_PILOTAGE_MCC_HEADER_ECTS'"/>
            <xsl:with-param name="value" select="ects/@title"/>
            <xsl:with-param name="padding" select="$padding"/>
        </xsl:call-template>
        <xsl:apply-templates select="knowledgeCheck">
            <xsl:with-param name="padding" select="$padding"/>
        </xsl:apply-templates>
    </xsl:template>
    
    <xsl:template match="container" mode="section-header-line">
        <xsl:variable name="padding" select="count(ancestor::*[parent::program or parent::subProgram or parent::container][local-name() = 'subProgram' or local-name() = 'container'])*4" />
        
        <xsl:apply-templates select="." mode="section-header-line-title">
            <xsl:with-param name="padding" select="$padding"/>
        </xsl:apply-templates>
        <xsl:call-template name="label-value">
            <xsl:with-param name="i18nLabelKey" select="'PLUGINS_ODF_PILOTAGE_MCC_HEADER_ECTS'"/>
            <xsl:with-param name="value">
                <xsl:call-template name="display-double">
                    <xsl:with-param name="value" select="ects" />
                    <xsl:with-param name="showZero" select="false()" />
                </xsl:call-template>
            </xsl:with-param>
            <xsl:with-param name="padding" select="$padding"/>
        </xsl:call-template>
        <xsl:call-template name="label-value">
            <xsl:with-param name="i18nLabelKey" select="'PLUGINS_ODF_PILOTAGE_MCC_HEADER_NATURE'"/>
            <xsl:with-param name="value" select="nature/@title"/>
            <xsl:with-param name="padding" select="$padding"/>
        </xsl:call-template>
        <xsl:call-template name="label-value">
            <xsl:with-param name="i18nLabelKey" select="'PLUGINS_ODF_PILOTAGE_MCC_HEADER_PERIOD'"/>
            <xsl:with-param name="value" select="period/@title"/>
            <xsl:with-param name="padding" select="$padding"/>
        </xsl:call-template>
        <xsl:call-template name="label-value">
            <xsl:with-param name="i18nLabelKey" select="'PLUGINS_ODF_PILOTAGE_MCC_HEADER_COMPENSABLE'"/>
            <xsl:with-param name="value" select="mccCompensable"/>
            <xsl:with-param name="padding" select="$padding"/>
        </xsl:call-template>
        <xsl:call-template name="label-value">
            <xsl:with-param name="i18nLabelKey" select="'PLUGINS_ODF_PILOTAGE_MCC_HEADER_ABS_JUSTIF'"/>
            <xsl:with-param name="value" select="justifiedAbsence/@title"/>
            <xsl:with-param name="padding" select="$padding"/>
        </xsl:call-template>
        <xsl:call-template name="label-value">
            <xsl:with-param name="i18nLabelKey" select="'PLUGINS_ODF_PILOTAGE_MCC_HEADER_ABS_INJUSTIF'"/>
            <xsl:with-param name="value" select="unjustifiedAbsence/@title"/>
            <xsl:with-param name="padding" select="$padding"/>
        </xsl:call-template>
        <xsl:call-template name="label-value">
            <xsl:with-param name="i18nLabelKey" select="'PLUGINS_ODF_PILOTAGE_MCC_HEADER_REGIME'"/>
            <xsl:with-param name="value" select="mccRegime/@title"/>
            <xsl:with-param name="padding" select="$padding"/>
        </xsl:call-template>
        <xsl:call-template name="label-value">
            <xsl:with-param name="i18nLabelKey" select="'PLUGINS_ODF_PILOTAGE_MCC_HEADER_NB_SESSIONS'"/>
            <xsl:with-param name="value" select="mccNbSessions"/>
            <xsl:with-param name="padding" select="$padding"/>
        </xsl:call-template>
        <xsl:if test="mcc_workflow/mcc_orgunit_validation_date != ''">
            <tr>
                <td colspan="{$nbColumns}" style="padding-left: {$padding}mm;">
                    <strong><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_HEADER_VALIDATION_DATE_ORGUNIT"/></strong>
                    <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_LABEL_VALUE_SEPARATOR"/>
                    <i18n:date src-pattern="yyyy-MM-dd" pattern="long"><xsl:value-of select="mcc_workflow/mcc_orgunit_validation_date"/></i18n:date>
                </td>
            </tr>
            <xsl:if test="mcc_workflow/mcc_orgunit_validation_comment != ''">
                <tr>
                    <td colspan="{$nbColumns}" style="padding-left: {$padding}mm;">
                        <xsl:call-template name="text.nl2hyphen">  
                            <xsl:with-param name="input" select="mcc_workflow/mcc_orgunit_validation_comment"/>
                        </xsl:call-template>
                    </td>
                </tr>
            </xsl:if>
            <xsl:if test="mcc_workflow/cfvu_mcc_validation_date != ''">
                <tr>
                    <td colspan="{$nbColumns}" style="padding-left: {$padding}mm;">
                        <strong><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_HEADER_VALIDATION_DATE_CFVU"/></strong>
                        <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_LABEL_VALUE_SEPARATOR"/>
                        <i18n:date src-pattern="yyyy-MM-dd" pattern="long"><xsl:value-of select="mcc_workflow/cfvu_mcc_validation_date"/></i18n:date>
                    </td>
                </tr>
                <xsl:if test="mcc_workflow/cfvu_mcc_validation_comment != ''">
                    <tr>
                        <td colspan="{$nbColumns}" style="padding-left: {$padding}mm;">
                            <xsl:call-template name="text.nl2hyphen">  
                                <xsl:with-param name="input" select="mcc_workflow/cfvu_mcc_validation_comment"/>
                            </xsl:call-template>
                        </td>
                    </tr>
                </xsl:if>
            </xsl:if>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="program|subProgram|container" mode="section-header-line-title">
        <xsl:param name="padding" select="0"/>
        
        <tr class="new-header">
            <td colspan="{$nbColumns}" style="padding-left: {$padding}mm;">
                <strong><xsl:value-of select="su:sanitizeXlsHtml(title)"/></strong>
                <xsl:apply-templates select="." mode="code-parenthesis"/>
            </td>
        </tr>
    </xsl:template>
    
    <xsl:template name="label-value">
        <xsl:param name="i18nLabelKey"/>
        <xsl:param name="value"/>
        <xsl:param name="padding" select="0"/>
        
        <xsl:if test="$value != ''">
            <tr>
                <td colspan="{$nbColumns}" style="padding-left: {$padding}mm;">
                    <strong><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="{$i18nLabelKey}"/></strong>
                    <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_LABEL_VALUE_SEPARATOR"/>
                    <xsl:value-of select="$value"/>
                </td>
            </tr>
        </xsl:if>
    </xsl:template>
</xsl:stylesheet>
