/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfpilotage.clientsideelement;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.ametys.core.ui.Callable;
import org.ametys.core.ui.StaticClientSideElement;
import org.ametys.odf.catalog.CatalogsManager;
import org.ametys.plugins.odfpilotage.report.PilotageReport;
import org.ametys.plugins.odfpilotage.report.ReportExtensionPoint;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

public class PilotageSearchClientSideElement
extends StaticClientSideElement {
    private static final String CRITERIA_ENUMERATION_VALUE_FIELD = "value";
    private static final String CRITERIA_ENUMERATION_LABEL_FIELD = "label";
    protected ReportExtensionPoint _reportEP;
    protected CatalogsManager _catalogManager;

    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._reportEP = (ReportExtensionPoint)((Object)manager.lookup(ReportExtensionPoint.ROLE));
        this._catalogManager = (CatalogsManager)manager.lookup(CatalogsManager.ROLE);
    }

    @Callable(rights={"ODF_Rights_Pilotage_Tool"})
    public Map<String, Object> getSearchModelCriteriaConfiguration() {
        LinkedHashMap<String, Object> enumerations = new LinkedHashMap<String, Object>();
        enumerations.put("reportTypes", this._getReportTypeEnumeration());
        enumerations.put("targets", this._getTargetEnumeration());
        enumerations.put("catalogs", this._getCatalogEnumeration());
        return enumerations;
    }

    private List<Map<String, Object>> _getReportTypeEnumeration() {
        return this._reportEP.getExtensionsIds().stream().map(arg_0 -> ((ReportExtensionPoint)this._reportEP).getExtension(arg_0)).map(extension -> Map.of(CRITERIA_ENUMERATION_VALUE_FIELD, extension.getId(), CRITERIA_ENUMERATION_LABEL_FIELD, extension.getLabel())).toList();
    }

    private List<Map<String, Object>> _getTargetEnumeration() {
        PilotageReport.PilotageReportTarget[] targets;
        ArrayList<Map<String, Object>> targetsLabels = new ArrayList<Map<String, Object>>();
        for (PilotageReport.PilotageReportTarget target : targets = PilotageReport.PilotageReportTarget.values()) {
            targetsLabels.add(Map.of(CRITERIA_ENUMERATION_VALUE_FIELD, target.name(), CRITERIA_ENUMERATION_LABEL_FIELD, target.getLabel()));
        }
        return targetsLabels;
    }

    private List<Map<String, String>> _getCatalogEnumeration() {
        return this._catalogManager.getCatalogs().stream().map(catalog -> Map.of(CRITERIA_ENUMERATION_VALUE_FIELD, catalog.getName(), CRITERIA_ENUMERATION_LABEL_FIELD, catalog.getTitle())).toList();
    }
}

