/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfpilotage.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.ametys.cms.model.restrictions.RestrictedModelItem;
import org.ametys.cms.repository.Content;
import org.ametys.cms.repository.WorkflowAwareContent;
import org.ametys.cms.search.ui.model.SearchUIModel;
import org.ametys.core.ui.Callable;
import org.ametys.odf.EducationalPathHelper;
import org.ametys.odf.ODFHelper;
import org.ametys.odf.ProgramItem;
import org.ametys.odf.course.Course;
import org.ametys.odf.data.EducationalPath;
import org.ametys.odf.data.type.EducationalPathRepositoryElementType;
import org.ametys.odf.rights.ODFRightHelper;
import org.ametys.plugins.odfpilotage.helper.ContentsWithViewTreeGridHelper;
import org.ametys.plugins.repository.UnknownAmetysObjectException;
import org.ametys.plugins.repository.jcr.SimpleAmetysObject;
import org.ametys.plugins.repository.model.ViewHelper;
import org.ametys.runtime.model.ModelItem;
import org.ametys.runtime.model.ViewItemAccessor;
import org.ametys.runtime.model.type.DataContext;
import org.ametys.runtime.model.type.ModelItemType;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Request;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class MCCCourseTreeGridHelper
extends ContentsWithViewTreeGridHelper {
    private ODFHelper _odfHelper;
    private EducationalPathHelper _educationalPathHelper;

    @Override
    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._odfHelper = (ODFHelper)smanager.lookup(ODFHelper.ROLE);
        this._educationalPathHelper = (EducationalPathHelper)smanager.lookup(EducationalPathHelper.ROLE);
    }

    @Override
    protected Map<String, Object> content2Json(Content content, List<String> path) {
        Map<String, Object> content2Json = super.content2Json(content, path);
        String localClientPath = path.stream().collect(Collectors.joining(";"));
        if (content instanceof ProgramItem) {
            ProgramItem programItem = (ProgramItem)content;
            List educationalPaths = this._odfHelper.getEducationalPaths(programItem);
            List<Map> educationalPathsJson = educationalPaths.stream().map(ep -> Pair.of((Object)ep.toString(), (Object)ep)).filter(pep -> ((String)pep.getKey()).endsWith(localClientPath)).map(pep -> Pair.of((Object)((String)pep.getKey()), (Object)this._odfHelper.getEducationalPathAsString((EducationalPath)pep.getValue()))).map(pep -> Map.of("path", (String)pep.getKey(), "label", (String)pep.getValue())).toList();
            content2Json.put("educationalPaths", educationalPathsJson);
        }
        return content2Json;
    }

    @Override
    protected void fillContentData(Content content, SearchUIModel searchUIModel, List<String> path, Map<String, Object> content2Json) {
        boolean isManager = this._contentWorkflowHelper.isAvailableAction((WorkflowAwareContent)content, 2);
        if (isManager) {
            content2Json.put("data", this.getContentData(content, searchUIModel));
            content2Json.put("notEditableDataIndex", this.canEdit((ViewItemAccessor)searchUIModel.getResultItems(Map.of()), content));
        } else {
            EducationalPath currentPath = EducationalPath.of((String[])((String[])path.toArray(String[]::new)));
            List fullPaths = this._odfHelper.getEducationPathFromPath(currentPath);
            currentPath = fullPaths.size() == 1 ? (EducationalPath)fullPaths.getFirst() : currentPath;
            Request request = ContextHelper.getRequest((Context)this._context);
            request.setAttribute(ODFRightHelper.REQUEST_ATTR_EDUCATIONAL_PATHS, List.of(currentPath));
            boolean isConsumer = this._contentWorkflowHelper.isAvailableAction((WorkflowAwareContent)content, 20);
            content2Json.put("data", this._getContentDataForPath(content, searchUIModel, EducationalPath.of((String[])((String[])path.toArray(String[]::new))), isConsumer));
            if (isConsumer) {
                content2Json.put("notEditableDataIndex", this._canEditContextualizedDataPath((ViewItemAccessor)searchUIModel.getResultItems(Map.of()), content));
            } else {
                content2Json.put("notEditableData", true);
            }
        }
    }

    protected List<String> _canEditContextualizedDataPath(ViewItemAccessor viewItemAcessor, Content content) {
        ArrayList<String> results = new ArrayList<String>();
        ViewHelper.visitView((ViewItemAccessor)viewItemAcessor, (element, definition) -> results.add(definition.getPath()), (group, definition) -> results.addAll(this._canEditContextualizedDataPath((ViewItemAccessor)group, content)), (group, definition) -> {
            if (this._educationalPathHelper.isRepeaterWithEducationalPath(definition)) {
                RestrictedModelItem restrictedModelItem;
                if (definition instanceof RestrictedModelItem && !(restrictedModelItem = (RestrictedModelItem)definition).canWrite((Object)content)) {
                    results.add(definition.getPath());
                } else {
                    results.addAll(this.canEdit((ViewItemAccessor)group, content));
                }
            } else {
                results.add(definition.getPath());
            }
        }, group -> results.addAll(this._canEditContextualizedDataPath((ViewItemAccessor)group, content)));
        return results;
    }

    private Map<String, Object> _getContentDataForPath(Content content, SearchUIModel searchUIModel, EducationalPath currentPath, boolean isConsumer) {
        Map<String, Object> data = super.getContentData(content, searchUIModel);
        this._checkMCCRepeater(content, data, "mccSession1", currentPath, isConsumer);
        this._checkMCCRepeater(content, data, "mccSession2", currentPath, isConsumer);
        return data;
    }

    private void _checkMCCRepeater(Content content, Map<String, Object> data, String repeaterName, EducationalPath currentPath, boolean isConsumer) {
        if (data.containsKey(repeaterName)) {
            Map repeaterData = (Map)data.get(repeaterName);
            List entries = (List)repeaterData.get("entries");
            for (Map entry : entries) {
                if (!isConsumer) {
                    entry.put("notEditable", true);
                    continue;
                }
                Map values = (Map)entry.get("values");
                if (values == null) continue;
                boolean isCommon = values.getOrDefault("common", true);
                if (isCommon) {
                    entry.put("notEditable", true);
                    continue;
                }
                ModelItem definition = content.getDefinition(repeaterName + "/path");
                ModelItemType modelItemType = definition.getType();
                if (!(modelItemType instanceof EducationalPathRepositoryElementType)) continue;
                EducationalPathRepositoryElementType pathType = (EducationalPathRepositoryElementType)modelItemType;
                EducationalPath educationalPath = (EducationalPath)pathType.fromJSONForClient(values.get("path"), DataContext.newInstance());
                entry.put("notEditable", !currentPath.equals((Object)educationalPath));
            }
        }
    }

    @Callable(rights={"__READ_ACCESS"}, rightContext="right.assignment.context.content", paramIndex=0)
    public String getCourseEducationalPath(String courseId) {
        Optional<String> programId = Optional.ofNullable(courseId).filter(StringUtils::isNotBlank).map(this::_resolveSilently).filter(Course.class::isInstance).map(Course.class::cast).map(arg_0 -> ((ODFHelper)this._odfHelper).getParentPrograms(arg_0)).filter(parents -> parents.size() == 1).map(Collection::stream).flatMap(Stream::findFirst).map(SimpleAmetysObject::getId);
        if (programId.isPresent()) {
            return EducationalPath.of((String[])new String[]{programId.get(), courseId}).toString();
        }
        return null;
    }

    private <T> T _resolveSilently(String id) {
        try {
            return (T)this._ametysResolver.resolveById(id);
        }
        catch (UnknownAmetysObjectException e) {
            return null;
        }
    }
}

