/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfpilotage.rights;

import java.util.ArrayList;
import java.util.List;
import org.ametys.cms.repository.Content;
import org.ametys.cms.search.query.OrQuery;
import org.ametys.cms.search.query.Query;
import org.ametys.cms.search.query.UsersQuery;
import org.ametys.core.user.UserIdentity;
import org.ametys.odf.ProgramItem;
import org.ametys.odf.course.Course;
import org.ametys.odf.orgunit.OrgUnit;
import org.ametys.odf.program.Container;
import org.ametys.odf.program.ProgramPart;
import org.ametys.odf.rights.ODFRightHelper;
import org.ametys.plugins.odfpilotage.helper.PilotageHelper;
import org.ametys.runtime.config.Config;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.commons.lang3.tuple.Pair;

public class ODFRightHelper
extends org.ametys.odf.rights.ODFRightHelper {
    public static final String MCC_MANAGERS_FIELD_PATH = "odf-mcc-managers";
    protected PilotageHelper _pilotageHelper;

    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._pilotageHelper = (PilotageHelper)((Object)manager.lookup(PilotageHelper.ROLE));
    }

    public String getMCCManagerProfileId() {
        return (String)Config.getInstance().getValue("odf.profile.mcc.manager");
    }

    public UserIdentity[] getMCCManagers(Content content) {
        if (content instanceof OrgUnit || content instanceof ProgramItem) {
            return (UserIdentity[])content.getValue(MCC_MANAGERS_FIELD_PATH);
        }
        return null;
    }

    public Query getMCCManagersQuery(UserIdentity ... users) {
        return new UsersQuery("odf-mcc-managers_s", Query.Operator.EQ, users);
    }

    public Query getRolesQuery(UserIdentity user) {
        ArrayList<Query> userQueries = new ArrayList<Query>();
        userQueries.add(this.getContributorsQuery(new UserIdentity[]{user}));
        userQueries.add(this.getManagersQuery(new UserIdentity[]{user}));
        userQueries.add(this.getMCCManagersQuery(user));
        return new OrQuery(userQueries);
    }

    protected List<ProgramItem> computeParentProgramItem(Course course, ODFRightHelper.PermissionContext permissionCtx) {
        Pair<PilotageHelper.StepHolderStatus, Container> stepHolder = this._pilotageHelper.getStepHolder((ProgramItem)course);
        switch ((PilotageHelper.StepHolderStatus)((Object)stepHolder.getLeft())) {
            case SINGLE: {
                if (permissionCtx.getAncestor() == null) {
                    permissionCtx.withAncestor((ProgramPart)stepHolder.getRight());
                }
                return super.computeParentProgramItem(course, permissionCtx);
            }
            case MULTIPLE: {
                if (permissionCtx.getAncestor() != null) {
                    return super.computeParentProgramItem(course, permissionCtx);
                }
                return List.of();
            }
            case NONE: {
                if (this._odfHelper.getParentPrograms((ProgramItem)course).size() == 1) {
                    return super.computeParentProgramItem(course, permissionCtx);
                }
                return List.of();
            }
        }
        return super.computeParentProgramItem(course, permissionCtx);
    }
}

