/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.workspaces.odfpilotage;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.ametys.cms.repository.ContentQueryHelper;
import org.ametys.cms.repository.ContentTypeExpression;
import org.ametys.cms.repository.LanguageExpression;
import org.ametys.odf.ODFHelper;
import org.ametys.odf.catalog.CatalogsManager;
import org.ametys.odf.program.Container;
import org.ametys.plugins.odfpilotage.helper.MCCWorkflowHelper;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.data.holder.group.ModelAwareRepeaterEntry;
import org.ametys.plugins.repository.query.expression.AndExpression;
import org.ametys.plugins.repository.query.expression.Expression;
import org.ametys.plugins.repository.query.expression.StringExpression;
import org.ametys.runtime.config.Config;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.acting.ServiceableAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;

public class GetMCCValidatedAction
extends ServiceableAction {
    protected MCCWorkflowHelper _mccWorkflowHelper;
    protected AmetysObjectResolver _resolver;
    protected ODFHelper _odfHelper;
    protected CatalogsManager _catalogsManager;

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._mccWorkflowHelper = (MCCWorkflowHelper)((Object)smanager.lookup(MCCWorkflowHelper.ROLE));
        this._resolver = (AmetysObjectResolver)smanager.lookup(AmetysObjectResolver.ROLE);
        this._odfHelper = (ODFHelper)smanager.lookup(ODFHelper.ROLE);
        this._catalogsManager = (CatalogsManager)smanager.lookup(CatalogsManager.ROLE);
    }

    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception {
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        String lang = Optional.ofNullable(request.getParameter("lang")).orElseGet(() -> (String)Config.getInstance().getValue("odf.programs.lang"));
        String catalog = Optional.ofNullable(request.getParameter("catalog")).orElseGet(() -> this._catalogsManager.getDefaultCatalogName());
        Map<String, String> attributeParameters = this._getAttributeParameters(request);
        List<Container> contents = this._getYearFromAttributeParameters(lang, catalog, attributeParameters);
        int size = contents.size();
        switch (size) {
            case 0: {
                this.getLogger().error("No year content has been found in catalog '" + catalog + "' and language '" + lang + "' with attributes " + this._attributes2String(attributeParameters));
                return null;
            }
            case 1: {
                Container content = contents.get(0);
                ModelAwareRepeaterEntry entry = this._mccWorkflowHelper.getLastMCCValidatedEntry(content);
                if (entry != null) {
                    return Map.of("id", content.getId(), "path", "mcc-validated-pdf[" + entry.getPosition() + "]/pdf");
                }
                this.getLogger().error("No validated MCC PDF has been found in catalog '" + catalog + "' and language '" + lang + "' with attributes " + this._attributes2String(attributeParameters));
                return null;
            }
        }
        this.getLogger().error(size + " year contents have been found in catalog '" + catalog + "' and language '" + lang + "' with attributes " + this._attributes2String(attributeParameters));
        return null;
    }

    private String _attributes2String(Map<String, String> attributeParameters) {
        return attributeParameters.entrySet().stream().map(e -> (String)e.getKey() + " '" + (String)e.getValue() + "'").collect(Collectors.joining(" and "));
    }

    private Map<String, String> _getAttributeParameters(Request request) {
        HashMap<String, String> attributesValues = new HashMap<String, String>();
        int i = 1;
        String attrName = request.getParameter("attr" + i);
        while (attrName != null) {
            String attrValue = request.getParameter("value" + i);
            attributesValues.put(attrName, attrValue);
            attrName = request.getParameter("attr" + ++i);
        }
        return attributesValues;
    }

    private List<Container> _getYearFromAttributeParameters(String lang, String catalog, Map<String, String> attributeParameters) {
        Optional yearId = this._odfHelper.getYearId();
        if (yearId.isPresent()) {
            AndExpression expr = new AndExpression(new Expression[0]);
            expr.add((Object)new ContentTypeExpression(Expression.Operator.EQ, new String[]{"org.ametys.plugins.odf.Content.container"}));
            expr.add((Object)new LanguageExpression(Expression.Operator.EQ, lang));
            expr.add((Object)new StringExpression("catalog", Expression.Operator.EQ, catalog));
            expr.add((Object)new StringExpression("nature", Expression.Operator.EQ, (String)yearId.get()));
            attributeParameters.entrySet().stream().map(entry -> new StringExpression((String)entry.getKey(), Expression.Operator.EQ, (String)entry.getValue())).forEach(arg_0 -> expr.add(arg_0));
            String xpathQuery = ContentQueryHelper.getContentXPathQuery((Expression)expr);
            AmetysObjectIterable contents = this._resolver.query(xpathQuery);
            return contents.stream().toList();
        }
        return List.of();
    }
}

