/*
 *  Copyright 2021 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

let nbcontent = 0;             
function _migratePilotageStatus(content)             
{         
	if (content.hasValue("pilotage/pilotage_status"))
    {
	    var status = content.getValue("pilotage/pilotage_status");
	    content.setValue("pilotage/pilotage_status", status.toUpperCase());
    }
}
  
Repository.query("//element(*, ametys:content)[@ametys-internal:contentType = 'org.ametys.plugins.odf.Content.program']")             
    .forEach(
    	content =>
	    {      
	    	if (content.hasValue("pilotage/pilotage_status"))
	        {
	    		var status = content.getValue("pilotage/pilotage_status");
	    		if (!org.apache.commons.lang.StringUtils.equals(status, status.toUpperCase()))
	    		{
	    			nbcontent++;
	    			logger.debug("Migration du statut '" + status + "' pour la formation " + content.toString());
	    			Content.migrate(             
	    					content,             
	    					[_migratePilotageStatus]         
	    			); 
	    		}
	        }
	    }             
    );
logger.info(nbcontent + " formation(s) migrée(s)");
