/*
 *  Copyright 2020 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * This class listen the disabled parameter of configuration to add additionalDescription on button
 */
Ext.define('Ametys.plugins.odf.pilotage.controller.CostModelingToolButtonController', {
	extend: "Ametys.ribbon.element.ui.ButtonController",
	
	constructor: function(config)
    {
    	this.callParent(arguments);
	    Ametys.message.MessageBus.on(Ametys.message.Message.TOOL_DIRTY_STATE_CHANGED, this._onToolDirtyStateChanged, this);
		Ametys.message.MessageBus.on(Ametys.message.Message.TOOL_OPENED, this._onToolOpenedOrClosed, this);                
		Ametys.message.MessageBus.on(Ametys.message.Message.TOOL_CLOSED, this._onToolOpenedOrClosed, this);        		
	},
		
	/**
	 * Listener on tool dirty state changed
	 * @param {Ametys.message.Message} message Tool message
	 * @private
	 */
	_onToolDirtyStateChanged: function(message)
	{
		var description = this.getInitialConfig("description");
	    if (!this._toolDirtyStateMatch)
	    {
	        this.setDescription(description + "<br>" + this.getInitialConfig("disable-description"));
	    }
	    else
	    {
	       	this.setDescription(description);
	    }
	},
	   
	/**
	 * Listener on tool opened/closed
	 * @param {Ametys.message.Message} message Tool message
	 * @private
	 */
	_onToolOpenedOrClosed: function(message)
	{
		this.setDescription(this.getInitialConfig("description") + "<br>" + this.getInitialConfig("disable-description"));
	}
});