<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2025 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                              xmlns:cms="http://ametys.org/cms/3.0"
                              xmlns:odf="org.ametys.plugins.odfweb.xslt.OdfXSLTHelper"
                              xmlns:stringutils="org.apache.commons.lang.StringUtils"
                              xmlns:su="org.ametys.core.util.StringUtils"
                              exclude-result-prefixes="cms odf stringutils su">
    
    <xsl:import href="odf-view:odf-pilotage://stylesheets/pilotage/report/params/mccc.xsl"/>
    <xsl:import href="odf-view:odf-pilotage://stylesheets/pilotage/utils/xls.xsl"/>
    <xsl:import href="odf-view:odf-pilotage://stylesheets/pilotage/report/mcc/styles2xls.xsl"/>
    <xsl:import href="odf-view:odf-pilotage://stylesheets/pilotage/report/mcc/header2xls.xsl"/>
    <xsl:import href="odf-view:odf-pilotage://stylesheets/pilotage/report/mccc/legende2xls.xsl"/>
    
    <xsl:template name="css-styles">
        <xsl:call-template name="css-styles-mcc"/>
    </xsl:template>
    
    <xsl:template name="table-head">
        <xsl:apply-templates select="program|subProgram|container" mode="title" />
        <xsl:call-template name="skills-table-header"/>
    </xsl:template>
    
    <xsl:template name="table-body">
        <tr class="skills-title">
            <td colspan="{$nbAllSkillsColumns}">
                <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_COL_MCC_SESSION_1"/>
            </td>
        </tr>
        <xsl:apply-templates select="program|subProgram|container" mode="skills">
            <xsl:with-param name="isFirstSession" select="true()"/>
        </xsl:apply-templates>
        
        <xsl:if test="//course[@session2 = 'available']">
            <tr class="skills-title">
                <td colspan="{$nbAllSkillsColumns}">
                    <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_COL_MCC_SESSION_2"/>
                </td>
            </tr>
            <xsl:apply-templates select="program|subProgram|container" mode="skills">
                <xsl:with-param name="isFirstSession" select="false()"/>
            </xsl:apply-templates>
        </xsl:if>
        
        <xsl:call-template name="legende" />
    </xsl:template>
    
    <xsl:template name="skills-table-header">
        <!-- First row to group titles -->
        <tr>
            <td class="maquette" colspan="{$nbSkillsColumnsCommon}">
                <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_COL_MAQUETTE"/>
            </td>
            <td class="evaluation" colspan="{$nbSkillsColumns}">
                <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_COL_SKILLS"/>
            </td>
        </tr>
        
        <!-- Second row with general attributes and macro skills -->
        <tr>
            <td style="width: 8cm;" class="maquette" rowspan="2">
                <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_COL_LABEL"/>
            </td>
            <td style="width: 2cm;" class="maquette" rowspan="2">
                <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_LEGEND_COEF"/>
            </td>
            <td style="width: 2cm;" class="maquette" rowspan="2">
                <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_COL_MCC_SESSION_MODALITE"/>
            </td>
            <td style="width: 2cm;" class="maquette" rowspan="2">
                <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_LEGEND_NB_NOTES"/>
            </td>
            <td style="width: 2cm;" class="maquette" rowspan="2">
                <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_LEGEND_PONDERATION"/>
            </td>
            <xsl:for-each select="/report/skills/macro">
                <td class="session1" colspan="{count(micro)}">
                    <xsl:if test="code != ''">
                        <xsl:value-of select="code"/>
                        <xsl:text> </xsl:text>
                    </xsl:if>
                    <xsl:value-of select="su:sanitizeXlsHtml(title)"/>
                </td>
            </xsl:for-each>
        </tr>
        
        <!-- Third row with micro skills -->
        <tr>
            <xsl:for-each select="/report/skills/macro/micro">
                <td class="session2">
                    <xsl:if test="code != ''">
                        <xsl:value-of select="code"/>
                        <xsl:text> </xsl:text>
                    </xsl:if>
                    <xsl:value-of select="su:sanitizeXlsHtml(title)"/>
                </td>
            </xsl:for-each>
        </tr>
    </xsl:template>
    
    <xsl:template match="program|subProgram|container" mode="skills">
        <xsl:param name="depth" select="0"/>
        <xsl:param name="isFirstSession"/>
        
        <xsl:if test="$isFirstSession or .//course[@session2 = 'available']">
            <!-- Display the program item title -->
            <tr class="programpart">
                <td colspan="{$nbAllSkillsColumns}">
                    <!-- Identation. Print 4 spaces per level -->
                    <xsl:call-template name="recursive-print">
                        <xsl:with-param name="times" select="$depth" />
                    </xsl:call-template>
                    <xsl:value-of select="su:sanitizeXlsHtml(title)"/>
                </td>
            </tr>
            
            <!-- Explore children -->
            <xsl:apply-templates select="subProgram|container|courseList" mode="skills">
                <xsl:with-param name="depth" select="$depth + 1"/>
                <xsl:with-param name="isFirstSession" select="$isFirstSession"/>
            </xsl:apply-templates>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="courseList" mode="skills">
        <xsl:param name="depth"/>
        <xsl:param name="isFirstSession"/>
        
        <xsl:if test="$isFirstSession or .//course[@session2 = 'available']">
            <!-- Display the course list type if it is not mandatory -->
            <xsl:variable name="courseListChoice" select="choiceType/@value"/>
            <xsl:choose>
                <xsl:when test="$courseListChoice = 'CHOICE'">
                    <tr class="courselist">
                        <td colspan="{$nbAllSkillsColumns}">
                            <xsl:call-template name="recursive-print">
                                <xsl:with-param name="times" select="$depth" />
                            </xsl:call-template>
                            <i18n:translate>
                                <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_COURSELIST_CHOICE"/>
                                <i18n:param><xsl:value-of select="min" /></i18n:param>
                            </i18n:translate>
                        </td>
                    </tr>
                </xsl:when>
                <xsl:when test="$courseListChoice = 'OPTIONAL'">
                    <tr class="courselist">
                        <td colspan="{$nbAllSkillsColumns}">
                            <xsl:call-template name="recursive-print">
                                <xsl:with-param name="times" select="$depth" />
                            </xsl:call-template>
                            <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_COURSELIST_OPTIONAL"/>
                        </td>
                    </tr>
                </xsl:when>
            </xsl:choose>
            
            <!-- Explore children -->
            <xsl:apply-templates select="course" mode="skills">
                <xsl:with-param name="depth" select="$depth + ($courseListChoice != 'MANDATORY')"/>
                <xsl:with-param name="isFirstSession" select="$isFirstSession"/>
            </xsl:apply-templates>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="course" mode="skills">
        <xsl:param name="depth"/>
        <xsl:param name="isFirstSession"/>
        
        <xsl:if test="$isFirstSession or @session2 = 'available'">
            <xsl:variable name="sessionName">
                <xsl:choose>
                    <xsl:when test="$isFirstSession">mccSession1</xsl:when>
                    <xsl:otherwise>mccSession2</xsl:otherwise>
                </xsl:choose>
            </xsl:variable>
            <xsl:variable name="mccSessionEntries" select="mcc/*[local-name() = $sessionName]/entry"/>
            
            <xsl:variable name="currentCourseType" select="courseType/code"/>
            <xsl:variable name="nbNotes" select="cms:getTotalNotesRowspan($mccSessionEntries, foo, false())"/>
            
            <!-- Details of the course -->
            <tr>
                <xsl:call-template name="course-attributes">
                    <xsl:with-param name="type" select="$currentCourseType"/>
                    <xsl:with-param name="isFirst" select="false()"/>
                </xsl:call-template>
                <td rowspan="{$nbNotes}">
                    <!-- Identation. Print 4 spaces per level -->
                    <xsl:call-template name="recursive-print">
                        <xsl:with-param name="times" select="$depth" />
                    </xsl:call-template>
                    <xsl:value-of select="su:sanitizeXlsHtml(title)"/>
                </td>
                <td rowspan="{$nbNotes}">
                    <xsl:call-template name="display-double">
                        <xsl:with-param name="value" select="odf:getValueForPath(@id, 'mccCoefficientByEducationalPath/coefficient', @path, 'mccCoefficient')" />
                    </xsl:call-template>
                </td>
                
                <!-- Details of the first mccSession1 entry, if there is not, empty cells are displayed -->
                <xsl:choose>
                    <xsl:when test="$mccSessionEntries">
                        <xsl:apply-templates select="$mccSessionEntries[1]" mode="skills-session"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <td/>
                        <td/>
                        <td/>
                        <xsl:variable name="currentCourse" select="."/>
                        <xsl:for-each select="/report/skills/macro/micro">
                            <xsl:variable name="currentSkillId" select="@id"/>
                            <xsl:variable name="enableSkill" select="$currentCourse/acquiredMicroSkills/entry/microSkills[@id = $currentSkillId]"/>
                            <td>
                                <xsl:if test="$enableSkill">
                                    <xsl:attribute name="class">enabled</xsl:attribute>
                                </xsl:if>
                             </td>
                        </xsl:for-each>
                    </xsl:otherwise>
                </xsl:choose>
            </tr>
            
            <!-- Details of the other mccSession1 entries, except the first one (already displayed in the previous row) -->
            <!-- But for the first entry, we displayed the note except the first one too (already displayed in the previous row) -->
            <xsl:for-each select="$mccSessionEntries">
                <!-- Details of the mccSession1 entry -->
                <xsl:if test="position() != 1">
                    <tr>
                        <xsl:call-template name="course-attributes">
                            <xsl:with-param name="type" select="$currentCourseType"/>
                            <xsl:with-param name="isFirst" select="false()"/>
                        </xsl:call-template>
                        <xsl:apply-templates select="." mode="skills-session"/>
                    </tr>
                </xsl:if>
                
                <!-- Details of notes of the mccSession entry, except the first one (already displayed in the previous row) -->
                <xsl:for-each select="notes/entry[position() > 1]">
                    <tr>
                        <xsl:call-template name="course-attributes">
                            <xsl:with-param name="type" select="$currentCourseType"/>
                            <xsl:with-param name="isFirst" select="false()"/>
                        </xsl:call-template>
                        <xsl:apply-templates select="." mode="skills-session-notes"/>
                    </tr>
                </xsl:for-each>
            </xsl:for-each>
        </xsl:if>
        
        <!-- Explore children -->
        <xsl:apply-templates select="courseList" mode="skills">
            <xsl:with-param name="depth" select="$depth + 1"/>
            <xsl:with-param name="isFirstSession" select="$isFirstSession"/>
        </xsl:apply-templates>
    </xsl:template>
    
    <xsl:template match="entry" mode="skills-session">
        <xsl:variable name="nbNotesSessionEntry" select="count(notes/entry)"/>
        <td rowspan="{$nbNotesSessionEntry}">
            <xsl:call-template name="displayCodeOrShortLabel">
                <xsl:with-param name="contentId" select="modalite/@id"/>
            </xsl:call-template>
            <xsl:if test="label != ''">
                <xsl:text> - </xsl:text>
                <xsl:value-of select="su:sanitizeXlsHtml(label)"/>
            </xsl:if>
        </td>
        <td rowspan="{$nbNotesSessionEntry}">
            <xsl:choose>
                <xsl:when test="notes/entry">
                    <xsl:value-of select="$nbNotesSessionEntry"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:call-template name="default-nb-notes"/>
                </xsl:otherwise>
            </xsl:choose>
        </td>
        
        <xsl:choose>
            <xsl:when test="notes/entry">
                <xsl:apply-templates select="notes/entry[1]" mode="skills-session-notes"/>
            </xsl:when>
            <xsl:otherwise>
                <td/>
                <xsl:variable name="currentCourse" select="ancestor::course[1]"/>
                <xsl:for-each select="/report/skills/macro/micro">
                    <xsl:variable name="currentSkillId" select="@id"/>
                    <xsl:variable name="enableSkill" select="$currentCourse/acquiredMicroSkills/entry/microSkills[@id = $currentSkillId]"/>
                    <td>
                        <xsl:if test="$enableSkill">
                            <xsl:attribute name="class">enabled</xsl:attribute>
                        </xsl:if>
                     </td>
                </xsl:for-each>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template match="entry" mode="skills-session-notes">
        <td>
            <xsl:choose>
                <xsl:when test="ponderation != ''">
                    <xsl:call-template name="display-double">
                        <xsl:with-param name="value" select="ponderation"/>
                        <xsl:with-param name="showZero" select="true()" />
                        <xsl:with-param name="format" select="'#,##'"/>
                    </xsl:call-template>
                    <xsl:text>%</xsl:text>
                    <xsl:if test="label != ''">
                        <xsl:text> - </xsl:text>
                        <xsl:value-of select="su:sanitizeXlsHtml(label)"/>
                    </xsl:if>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:call-template name="default-ponderation"/>
                </xsl:otherwise>
            </xsl:choose>
        </td>
        
        <xsl:variable name="currentNote" select="."/>
        <xsl:variable name="currentCourse" select="ancestor::course[1]"/>
        <xsl:for-each select="/report/skills/macro/micro">
            <xsl:variable name="currentSkillId" select="@id"/>
            <xsl:variable name="enableSkill" select="$currentCourse/acquiredMicroSkills/entry/microSkills[@id = $currentSkillId]"/>
            <td>
                <xsl:if test="$enableSkill">
                    <xsl:attribute name="class">enabled</xsl:attribute>
                    <xsl:variable name="matchingSkillEntry" select="$currentNote/skills/entry[skill/@id = $currentSkillId][not(path) or stringutils:endsWith(path, $currentCourse/@path)]"/>
                    <xsl:if test="$matchingSkillEntry">
                        <xsl:call-template name="display-double">
                            <xsl:with-param name="value" select="$matchingSkillEntry/ponderation"/>
                            <xsl:with-param name="showZero" select="true()" />
                            <xsl:with-param name="format" select="'#,##'"/>
                        </xsl:call-template>
                        <xsl:text>%</xsl:text>
                    </xsl:if>
                </xsl:if>
            </td>
        </xsl:for-each>
    </xsl:template>
    
    <xsl:template name="course-attributes">
        <xsl:param name="type"/>
        <xsl:param name="isFirst" select="true()"/>
        
        <xsl:attribute name="class">
            <xsl:choose>
                <xsl:when test="$type='UE'"><xsl:if test="$isFirst">first-</xsl:if>ue</xsl:when>
                <xsl:otherwise>elp</xsl:otherwise>
            </xsl:choose>
        </xsl:attribute>
    </xsl:template>
</xsl:stylesheet>
